// Sets the display property of an element.
function SetVisibility(element, bit) {
  if(bit == 0) {
    element.style.display = 'none';
  } else {
    element.style.display = 'block';
  }
}

// Greys out the menu item of the current page.
function SetCurrentMenuItem(list, pageNum, dbExists) {
  var items = document.getElementsByTagName("a");

  if(pageNum < items.length) {
    if(pageNum > 0 && pageNum < 9) {
      var learnMoreElement = document.getElementById('learnMore');

      items[pageNum].style.fontStyle = "italic";
      items[pageNum].style.backgroundImage = "url(images/arrowon.gif)";
      items[pageNum].style.backgroundRepeat = "no-repeat";
      items[pageNum].style.textDecoration = "underline";

      learnMoreElement.style.fontWeight = "bold";
    } else if(pageNum > 8 && pageNum < 12) {
      var prefsElement = document.getElementById('prefs');

      items[pageNum].style.fontStyle = "italic";
      items[pageNum].style.backgroundImage = "url(images/arrowon.gif)";
      items[pageNum].style.backgroundRepeat = "no-repeat";
      items[pageNum].style.textDecoration = "underline";

      prefsElement.style.fontWeight = "bold";
    } else {
      items[pageNum].style.fontWeight = "bold";
    }

    items[pageNum].focus();
  }
}

// Get a query string value by name. NOTE: Does not handle duplicate names.
function GetQueryValue(name) {
  var query = document.location.search.substring(1);
  var vars = query.split('&');

  for(var i = 0; i < vars.length; i++) {
    var pair = vars[i].split('=');

    if(pair[0] == name) {
      return pair[1];
    }
  }
}
