
function CalibrateAudio(clip c, int channels, int samplepersec, string bitspersample)
{
	(channels <= 0) ? Eval("""
			aclip = c.KillAudio()
		""") : Eval("""
			aclip = NeedAudio(c, channels, samplepersec, bitspersample)
		""")

	return AudioDubEx(c, aclip)
}

function NeedAudio(clip c, int channels, int samplepersec, string bitspersample)
{
# 2.58 can use this for effient
#		haschannels = c.AudioChannels()
#		(haschannels > 0) ? Eval("""
#			aclip = CalibrateChannels(c, channels, samplepersec, bitspersample)
#		""") : Eval("""
#			aclip = BlankClip(c, audio_rate=samplepersec, channels=channels, sample_type=bitspersample)
#		""")

# 2.57 use this
	aclip = CalibrateChannels(c, channels, samplepersec, bitspersample)
	
	return aclip
}

function CalibrateChannels(clip c, int channels, int samplepersec, string bitspersample)
{
	haschannels = c.AudioChannels()
#2.58 can use this for accurate
#	silent = BlankClip(c, audio_rate=samplepersec, channels=1, sample_type=bitspersample).KillVideo()

# 2.57 use this
	silent = Tone(length=c.FrameCount/c.FrameRate, samplerate=samplepersec, channels=1, type="silence")
	(haschannels == 0) ? Eval("""
		ar = ArrayCreate(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
		ar = ar.ArrayInsert(silent)
	""") : Eval("""
		ar = ArrayCreate(GetChannel(c, 1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 1%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 2%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 3%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 4%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 5%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 6%haschannels+1).ResampleAudio(samplepersec))
		ar = ar.ArrayInsert(GetChannel(c, 7%haschannels+1).ResampleAudio(samplepersec))
	""")
	
	# Prepare the desired audio clip	
	(channels == 1) ? Eval("""
	aclip = ar.ArrayGet(0)
	""") : NOP
	
	(channels == 2) ? Eval("""
	if (haschannels == 6) 
	{
	 fl = GetChannel(c, 1).ResampleAudio(samplepersec)
	 fr = GetChannel(c, 2).ResampleAudio(samplepersec)
	 center = GetChannel(c, 3).ResampleAudio(samplepersec)
	 rl = GetChannel(c, 5).ResampleAudio(samplepersec)
	 rr = GetChannel(c, 6).ResampleAudio(samplepersec)
	 bl = MixAudio(rl,center,0.42,0.58)
	 l = MixAudio(fl,bl,0.45,0.55)
	 br = MixAudio(rr,center,0.42,0.58)
	 r = MixAudio(fr,br,0.45,0.55)
	 aclip = MergeChannels(l, r)
	} 
	else 
	{ 
	 aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1)) 
	} 
	""") : NOP
	
	(channels == 3) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2))
	""") : NOP

	(channels == 4) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3))
	""") : NOP

	(channels == 5) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4))
	""") : NOP

	(channels == 6) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5))
	""") : NOP

	(channels == 7) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5), ar.ArrayGet(6))
	""") : NOP

	(channels >= 8) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5), ar.ArrayGet(6), ar.ArrayGet(7))
	""") : NOP

	return aclip
}
