<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output 
    method="html" 
    indent="yes" 
    version="4.0"/>

  <xsl:template match="/">
    <xsl:call-template name="DisplayStocks"></xsl:call-template>
    
  </xsl:template>


  <xsl:template name="DisplayStocks">

  <table id="stocks">
    <thead class="head">
      <tr>
        <td>Company</td>
        <td>Price</td>
        <td>Direction</td>
      </tr>
    </thead>
    <tbody>
      <xsl:for-each select="//company">
        <tr>
          <td class="border2">
            <xsl:value-of select="name"/>
          </td>
          <td class="border2" align="center">
            <xsl:value-of select="price"/>
          </td>
          <xsl:choose>
            <xsl:when test="direction='Up'">
              <td class="border2" style="color:blue;">
                <xsl:value-of select="direction"/>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="border2" style="color:red;">
                <xsl:value-of select="direction"/>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
      </xsl:for-each>
    </tbody>
  </table>
  </xsl:template>

</xsl:stylesheet>

