<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output 
    method="html" 
    indent="yes" 
    version="4.0" />
   
  <xsl:template match="/">
    <table border="1">
      <thead>
        <tr>
          <td>Position</td>
          <td>Name</td>
          <td>Time</td>
        </tr>
      </thead>
      <xsl:for-each select="//runner">
        <xsl:sort select="totalseconds"/>
        <tr>
          <td>
            <xsl:value-of select="position()"/>
          </td>
          <td>
            <xsl:value-of select="name"/>
          </td>
          <td>
            <xsl:value-of select="floor(totalseconds div 60)"/>.
            <xsl:choose>
              <xsl:when test ="(totalseconds mod 60) &gt; 9">
                <xsl:value-of select="(totalseconds mod 60)"/>
              </xsl:when>
              <xsl:otherwise>
                  0<xsl:value-of select="(totalseconds mod 60)"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </xsl:for-each>
      <tr>
        <td>Average Time:</td>
        <td>
        </td>
        <td>
          <xsl:variable name="avgtime" select="sum(//totalseconds) div count(//runner)"/>
          <xsl:value-of select="floor($avgtime div 60)"/>.
            <xsl:choose>
              <xsl:when test ="($avgtime mod 60) &gt; 9">
                <xsl:value-of select="($avgtime mod 60)"/>
              </xsl:when>
              <xsl:otherwise>
                  0<xsl:value-of select="($avgtime mod 60)"/>
              </xsl:otherwise>
            </xsl:choose>
        </td>
      </tr>
    </table>
  </xsl:template>


</xsl:stylesheet>

