/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.cache;

import com.modnut.framework2.resource.ResPack;

public abstract class CacheBase<CO> {
    private CO none;

    private CO getNoneObjIns() {
        if (this.none == null) {
            this.none = this.getNone();
        }
        return this.none;
    }

    protected abstract CO getNone();

    protected abstract String getCacheKey(String var1);

    protected abstract CO fromDB(ResPack var1, String var2) throws Exception;

    protected abstract CO fromCache(ResPack var1, String var2) throws Exception;

    protected abstract void toCache(ResPack var1, String var2, CO var3) throws Exception;

    protected abstract void delCache(ResPack var1, String var2) throws Exception;

    public CO get(ResPack res, String key) {
        return this.get(res, key, false);
    }

    public CO get(ResPack res, String key, boolean refresh) {
        if (key == null) {
            return this.getNoneObjIns();
        }
        String cacheKey = this.getCacheKey(key);
        if (cacheKey == null) {
            return this.getNoneObjIns();
        }
        try {
            CO dbObj;
            if (!refresh) {
                Object obj = res.getVar(cacheKey);
                if (obj != null) {
                    return (CO)obj;
                }
                CO cacheObj = this.fromCache(res, cacheKey);
                if (cacheObj != null) {
                    return cacheObj;
                }
            }
            if ((dbObj = this.fromDB(res, key)) != null) {
                res.putVar(cacheKey, dbObj);
                this.toCache(res, cacheKey, dbObj);
                return dbObj;
            }
            return this.getNoneObjIns();
        }
        catch (Exception ex) {
            return this.getNoneObjIns();
        }
    }

    public void del(ResPack res, String key) {
        if (key == null) {
            return;
        }
        String cacheKey = this.getCacheKey(key);
        if (cacheKey == null) {
            return;
        }
        try {
            res.removeVar(cacheKey);
            this.delCache(res, cacheKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

