/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.cache;

import com.modnut.framework2.cache.CacheBase;
import com.modnut.framework2.resource.ResPack;
import java.util.HashMap;

public abstract class CacheInsBase<CO>
extends CacheBase<CO> {
    protected final HashMap<String, CacheWrap> cachePool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CO fromCache(ResPack res, String cacheKey) throws Exception {
        CacheWrap cache;
        HashMap<String, CacheWrap> hashMap = this.cachePool;
        synchronized (hashMap) {
            cache = this.cachePool.get(cacheKey);
        }
        if (cache != null && cache.isAvailable()) {
            return cache.obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void toCache(ResPack res, String cacheKey, CO cacheObj) throws Exception {
        HashMap<String, CacheWrap> hashMap = this.cachePool;
        synchronized (hashMap) {
            this.cachePool.put(cacheKey, new CacheWrap(cacheObj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delCache(ResPack res, String cacheKey) throws Exception {
        HashMap<String, CacheWrap> hashMap = this.cachePool;
        synchronized (hashMap) {
            this.cachePool.remove(cacheKey);
        }
    }

    @Override
    protected String getCacheKey(String key) {
        return key;
    }

    @Override
    protected CO getNone() {
        return null;
    }

    protected abstract int getCacheTime();

    protected class CacheWrap {
        protected CO obj;
        protected long ts;

        public CacheWrap(CO obj) {
            this.obj = obj;
            this.ts = System.currentTimeMillis();
        }

        public boolean isAvailable() {
            return this.ts + (long)CacheInsBase.this.getCacheTime() * 1000L > System.currentTimeMillis();
        }
    }
}

