/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.compiler;

import com.modnut.framework2.compiler.CompilerException;
import com.modnut.framework2.tool.ToolFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class CompilerBasic {
    protected static final String[] EXT_SOURCE = new String[]{".java", ".form"};
    public static final int DEBUG_DEFAULT = 0;
    public static final int DEBUG_NONE = 1;
    public static final int DEBUG_SOURCE = 2;
    public static final int DEBUG_LINES = 4;
    public static final int DEBUG_VARS = 8;
    public int debug = 0;
    public String encode = null;
    public String source = null;
    public String target = null;
    public String dest = null;
    public ArrayList<String> classpath = null;
    public ArrayList<String> sources = null;

    public void addClassDir(String path) throws CompilerException {
        this.addClassDir(new File(path));
    }

    public void addClassDir(File file) throws CompilerException {
        if (file.isDirectory()) {
            if (this.classpath == null) {
                this.classpath = new ArrayList();
            }
            this.classpath.add(file.getAbsolutePath());
        }
    }

    public void addClassJar(String path) throws CompilerException {
        this.addClassJar(new File(path));
    }

    public void addClassJar(File file) throws CompilerException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.addClassJar(f);
            }
        } else if (file.getName().toLowerCase().endsWith(".jar")) {
            if (this.classpath == null) {
                this.classpath = new ArrayList();
            }
            this.classpath.add(file.getAbsolutePath());
        }
    }

    public void addSource(String path) throws CompilerException {
        this.addSource(new File(path));
    }

    public void addSource(File file) throws CompilerException {
        block5: {
            if (file == null || !file.exists()) break block5;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.addSource(f);
                }
            } else {
                String name = file.getName().toLowerCase();
                for (String ext : EXT_SOURCE) {
                    if (!name.endsWith(ext)) continue;
                    if (this.sources == null) {
                        this.sources = new ArrayList();
                    }
                    this.sources.add(file.getAbsolutePath());
                }
            }
        }
    }

    private void solveOptionDebug(ArrayList<String> arguments) throws CompilerException {
        if (this.debug != 0) {
            if (this.debug == 1) {
                arguments.add("-g:none");
            } else {
                ArrayList<String> goptions = new ArrayList<String>();
                if ((this.debug & 2) == 2) {
                    goptions.add("source");
                }
                if ((this.debug & 4) == 4) {
                    goptions.add("lines");
                }
                if ((this.debug & 8) == 8) {
                    goptions.add("vars");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("-g:{");
                for (int i = 0; i < goptions.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append((String)goptions.get(i));
                }
                sb.append("}");
                arguments.add(sb.toString());
            }
        }
    }

    private void solveOptionEncode(ArrayList<String> arguments) throws CompilerException {
        if (this.encode != null) {
            arguments.add("-encoding");
            arguments.add(this.encode);
        }
    }

    private void solveOptionSource(ArrayList<String> arguments) throws CompilerException {
        if (this.source != null) {
            arguments.add("-source");
            arguments.add(this.source);
        }
    }

    private void solveOptionTarget(ArrayList<String> arguments) throws CompilerException {
        if (this.target != null) {
            arguments.add("-target");
            arguments.add(this.target);
        }
    }

    private void solveOptionDest(ArrayList<String> arguments) throws CompilerException {
        if (this.dest != null) {
            File file = new File(this.dest);
            ToolFile.deleteFile(file);
            file.mkdirs();
            arguments.add("-d");
            arguments.add(this.dest);
        }
    }

    private void solveOptionClasspath(ArrayList<String> arguments) throws CompilerException {
        if (this.classpath != null && !this.classpath.isEmpty()) {
            arguments.add("-classpath");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.classpath.size(); ++i) {
                if (i > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(this.classpath.get(i));
            }
            arguments.add(sb.toString());
        }
    }

    public void compile(InputStream in, OutputStream out, OutputStream err) throws CompilerException {
        ArrayList<String> arguments = new ArrayList<String>();
        this.solveOptionDebug(arguments);
        this.solveOptionEncode(arguments);
        this.solveOptionSource(arguments);
        this.solveOptionTarget(arguments);
        this.solveOptionDest(arguments);
        this.solveOptionClasspath(arguments);
        if (this.sources != null) {
            for (String s : this.sources) {
                arguments.add(s);
            }
        }
        CompilerBasic.compile(in, out, err, arguments.toArray(new String[0]));
    }

    public static void compile(InputStream in, OutputStream out, OutputStream err, String ... arguments) throws CompilerException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler.run(in, out, err, arguments) != 0) {
            throw new CompilerException("compile failed");
        }
    }
}

