/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.compiler;

import com.modnut.framework2.compiler.CompilerException;
import com.modnut.framework2.tool.ToolFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class CompilerPacker {
    public boolean stored = false;
    public int level = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(File jarFile, File packDir, Manifest manifest) throws CompilerException {
        if (jarFile.exists() && !ToolFile.deleteFile(jarFile)) {
            throw new CompilerException("old jar file delete failed");
        }
        try {
            JarOutputStream out = manifest == null ? new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile))) : new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest);
            try {
                out.setMethod(this.stored ? 0 : 8);
                out.setLevel(this.level);
                if (packDir != null && packDir.isDirectory()) {
                    for (File f : packDir.listFiles()) {
                        this.addFile(out, f, "");
                    }
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CompilerPacker.class.getName()).log(Level.SEVERE, null, ex);
            throw new CompilerException("io exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(JarOutputStream out, File file, String basePath) throws CompilerException {
        block13: {
            try {
                if (file.isDirectory()) {
                    File[] listFiles;
                    String name = basePath + file.getName() + File.separator;
                    JarEntry entry = new JarEntry(name);
                    entry.setMethod(0);
                    entry.setCompressedSize(0L);
                    entry.setSize(0L);
                    entry.setTime(file.lastModified());
                    entry.setCrc(0L);
                    out.putNextEntry(entry);
                    out.closeEntry();
                    for (File f : listFiles = file.listFiles()) {
                        this.addFile(out, f, name);
                    }
                    break block13;
                }
                String name = basePath + file.getName();
                JarEntry entry = new JarEntry(name);
                if (this.stored) {
                    entry.setMethod(0);
                    entry.setCompressedSize(file.length());
                    entry.setSize(file.length());
                    entry.setTime(file.lastModified());
                    entry.setCrc(CompilerPacker.getCRC32(file));
                } else {
                    entry.setMethod(8);
                }
                out.putNextEntry(entry);
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    try {
                        int c;
                        while ((c = in.read()) != -1) {
                            out.write(c);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    out.closeEntry();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CompilerPacker.class.getName()).log(Level.SEVERE, null, ex);
                throw new CompilerException("io exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws CompilerException {
        try {
            long checksum = 0L;
            CheckedInputStream cin = new CheckedInputStream(new FileInputStream(file), new CRC32());
            try {
                while (cin.read() != -1) {
                }
                checksum = cin.getChecksum().getValue();
            }
            finally {
                cin.close();
            }
            return checksum;
        }
        catch (IOException ex) {
            Logger.getLogger(CompilerPacker.class.getName()).log(Level.SEVERE, null, ex);
            throw new CompilerException("io exception");
        }
    }
}

