/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.compiler;

import com.modnut.framework2.compiler.CompilerBasic;
import com.modnut.framework2.compiler.CompilerException;
import com.modnut.framework2.compiler.CompilerPacker;
import com.modnut.framework2.tool.ToolFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Manifest;

public class CompilerProject {
    private static final String[] EXT_SOURCE = CompilerBasic.EXT_SOURCE;
    protected static final String DIR_CLASSES = "classes";
    public final CompilerBasic compiler = new CompilerBasic();
    protected final Manifest manifest;
    protected final File src;
    protected final File pack;
    public boolean stored = false;
    public int level = -1;

    public CompilerProject(File src) {
        this.manifest = new Manifest();
        this.src = src;
        this.pack = src;
    }

    public CompilerProject(File src, Manifest manifest) {
        this.manifest = manifest;
        this.src = src;
        this.pack = src;
    }

    public CompilerProject(File src, File pack) {
        this.manifest = new Manifest();
        this.src = src;
        this.pack = pack;
    }

    public CompilerProject(File src, File pack, Manifest manifest) {
        this.manifest = manifest;
        this.src = src;
        this.pack = src;
    }

    public void setManifestVersion(String version) throws CompilerException {
        if (version != null && !version.isEmpty()) {
            this.setManifest("Manifest-Version", version);
        }
    }

    public void setMainClass(String mainClass) throws CompilerException {
        if (mainClass != null && !mainClass.isEmpty()) {
            this.setManifest("Main-Class", mainClass);
        }
    }

    public void setCreateBy(String createBy) throws CompilerException {
        if (createBy != null && !createBy.isEmpty()) {
            this.setManifest("Created-By", createBy);
        }
    }

    public void setClassPath(String classPath) throws CompilerException {
        if (classPath != null && !classPath.isEmpty()) {
            this.setManifest("Class-Path", classPath);
        }
    }

    public void setClassPath(String[] classPath) throws CompilerException {
        this.setClassPath(Arrays.asList(classPath));
    }

    public void setClassPath(List<String> classPath) throws CompilerException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classPath.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(classPath.get(i));
        }
        this.setManifest("Class-Path", sb.toString());
    }

    public void setManifest(String name, String value) throws CompilerException {
        this.manifest.getMainAttributes().putValue(name, value);
    }

    public void setDebug(int debug) throws CompilerException {
        this.compiler.debug = debug;
    }

    public void setEncode(String encode) throws CompilerException {
        this.compiler.encode = encode;
    }

    public void setSource(String source) throws CompilerException {
        this.compiler.source = source;
    }

    public void setTarget(String target) throws CompilerException {
        this.compiler.target = target;
    }

    public void addClassJar(String path) throws CompilerException {
        this.compiler.addClassJar(path);
    }

    public void addClassJar(File file) throws CompilerException {
        this.compiler.addClassJar(file);
    }

    public void addClassDir(String path) throws CompilerException {
        this.compiler.addClassDir(path);
    }

    public void addClassDir(File file) throws CompilerException {
        this.compiler.addClassDir(file);
    }

    public void compile(InputStream in, OutputStream out, OutputStream err, File packFile) throws CompilerException {
        this.compiler.dest = null;
        if (this.compiler.sources != null) {
            this.compiler.sources.clear();
        }
        this.compiler.addSource(this.src);
        this.compiler.compile(in, out, err);
        CompilerProject.deleteSourceFile(this.src);
        File parentFile = packFile.getParentFile();
        if (!parentFile.exists()) {
            if (!parentFile.mkdirs()) {
                throw new CompilerException("create pack file parent dir failed");
            }
        } else if (!parentFile.isDirectory()) {
            throw new CompilerException("pack file parent file is not dir");
        }
        this.packToFile(packFile, this.pack);
        if (!ToolFile.deleteFile(this.pack)) {
            throw new CompilerException("delete pack file failed");
        }
    }

    protected void packToFile(File jarFile, File packDir) throws CompilerException {
        CompilerPacker packer = new CompilerPacker();
        packer.stored = this.stored;
        packer.level = this.level;
        packer.pack(jarFile, packDir, this.manifest);
    }

    protected static void deleteSourceFile(File file) throws CompilerException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                CompilerProject.deleteSourceFile(f);
            }
        } else {
            String name = file.getName().toLowerCase();
            for (String ext : EXT_SOURCE) {
                if (!name.endsWith(ext) || file.delete()) continue;
                throw new CompilerException("delete source file " + file.getName() + " failed");
            }
        }
    }
}

