/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class DH {
    private static final String KEY_ALGORITHM = "DH";
    private static final int KEY_SIZE = 1024;
    private Cipher cipher;

    public DH(String publicKey, String privateKey, MODE mode) {
        this.init(publicKey, privateKey, mode, null);
    }

    public DH(String publicKey, String privateKey, MODE mode, SECRET_ALGORITHM algorithm) {
        this.init(publicKey, privateKey, mode, algorithm);
    }

    private boolean init(String publicKey, String privateKey, MODE mode, SECRET_ALGORITHM algorithm) {
        block10: {
            if (mode == null) {
                mode = MODE.DEFAULT;
            }
            if (algorithm == null) {
                algorithm = SECRET_ALGORITHM.DEFAULT;
            }
            try {
                byte[] pubKeyBytes = BASE64.decode(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyBytes);
                PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
                byte[] priKeyBytes = BASE64.decode(privateKey);
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKeyBytes);
                PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
                KeyAgreement keyAgree = KeyAgreement.getInstance(keyFactory.getAlgorithm());
                keyAgree.init(priKey);
                keyAgree.doPhase(pubKey, true);
                SecretKey secretKey = keyAgree.generateSecret(algorithm.getAlgorithm());
                this.cipher = Cipher.getInstance(algorithm.getAlgorithm());
                this.cipher.init(mode.getMode(), secretKey);
                return true;
            }
            catch (NoSuchPaddingException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeySpecException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block10;
                Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cipher = null;
        return false;
    }

    public byte[] update(byte[] input) {
        return this.cipher.update(input);
    }

    public byte[] update(byte[] input, int offset, int len) {
        return this.cipher.update(input, offset, len);
    }

    public byte[] doFinal(byte[] input) {
        block4: {
            try {
                return this.cipher.doFinal(input);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] doFinal(byte[] input, int offset, int len) {
        block4: {
            try {
                return this.cipher.doFinal(input, offset, len);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static Keys generateKeys() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            Keys keys = new Keys();
            keys.publicKey = BASE64.encode(keyPair.getPublic().getEncoded());
            keys.privateKey = BASE64.encode(keyPair.getPrivate().getEncoded());
            return keys;
        }
        catch (NoSuchAlgorithmException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public static Keys generateKeys(String key) {
        block6: {
            try {
                byte[] keyBytes = BASE64.decode(key);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
                DHParameterSpec dhParamSpec = ((DHPublicKey)pubKey).getParams();
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyFactory.getAlgorithm());
                keyPairGenerator.initialize(dhParamSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                Keys keys = new Keys();
                keys.publicKey = BASE64.encode(keyPair.getPublic().getEncoded());
                keys.privateKey = BASE64.encode(keyPair.getPrivate().getEncoded());
                return keys;
            }
            catch (InvalidAlgorithmParameterException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeySpecException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block6;
                Logger.getLogger(DH.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static byte[] encrypt(byte[] data, String publicKey, String privateKey) {
        return DH.encrypt(data, publicKey, privateKey, null);
    }

    public static byte[] encrypt(byte[] data, String publicKey, String privateKey, SECRET_ALGORITHM algorithm) {
        return new DH(publicKey, privateKey, MODE.ENCRYPT, algorithm).doFinal(data);
    }

    public static byte[] decrypt(byte[] data, String publicKey, String privateKey) {
        return DH.decrypt(data, publicKey, privateKey, null);
    }

    public static byte[] decrypt(byte[] data, String publicKey, String privateKey, SECRET_ALGORITHM algorithm) {
        return new DH(publicKey, privateKey, MODE.DECRYPT, algorithm).doFinal(data);
    }

    public static enum SECRET_ALGORITHM {
        DES,
        DESede,
        AES,
        Blowfish;

        public static SECRET_ALGORITHM DEFAULT;

        public String getAlgorithm() {
            switch (this) {
                case DES: {
                    return "DES";
                }
                case DESede: {
                    return "DESede";
                }
                case AES: {
                    return "AES";
                }
                case Blowfish: {
                    return "Blowfish";
                }
            }
            return null;
        }

        static {
            DEFAULT = DES;
        }
    }

    public static enum MODE {
        ENCRYPT,
        DECRYPT;

        public static MODE DEFAULT;

        public int getMode() {
            switch (this) {
                case ENCRYPT: {
                    return 1;
                }
                case DECRYPT: {
                    return 2;
                }
            }
            return DEFAULT.getMode();
        }

        static {
            DEFAULT = ENCRYPT;
        }
    }

    public static class Keys {
        public String publicKey;
        public String privateKey;
    }
}

