/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMAC {
    private static int DEFAULT_BUFF_SIZE = 1024;
    private Mac mac;

    public HMAC(String key) {
        this.init(key, null);
    }

    public HMAC(String key, ALGORITHM algorithm) {
        this.init(key, algorithm);
    }

    private boolean init(String key, ALGORITHM algorithm) {
        block5: {
            if (algorithm == null) {
                algorithm = ALGORITHM.DEFAULT;
            }
            try {
                SecretKeySpec secretKey = new SecretKeySpec(BASE64.decode(key), algorithm.getAlgorithm());
                this.mac = Mac.getInstance(algorithm.getAlgorithm());
                this.mac.init(secretKey);
                return true;
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(HMAC.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block5;
                Logger.getLogger(HMAC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.mac = null;
        return false;
    }

    public HMAC update(byte input) {
        this.mac.update(input);
        return this;
    }

    public HMAC update(byte[] input) {
        this.mac.update(input);
        return this;
    }

    public HMAC update(byte[] input, int offset, int len) {
        this.mac.update(input, offset, len);
        return this;
    }

    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    public static String generateKey() {
        return HMAC.generateKey(null);
    }

    public static String generateKey(ALGORITHM algorithm) {
        if (algorithm == null) {
            algorithm = ALGORITHM.DEFAULT;
        }
        try {
            SecureRandom secureRandom = new SecureRandom();
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm.getAlgorithm());
            keyGenerator.init(secureRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            return BASE64.encode(secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(HMAC.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public static byte[] encode(byte[] data, String key) {
        return HMAC.encode(data, key, null);
    }

    public static byte[] encode(byte[] data, String key, ALGORITHM algorithm) {
        return new HMAC(key, algorithm).update(data).doFinal();
    }

    public static byte[] encode(InputStream in, String key) throws IOException {
        return HMAC.encode(in, key, null);
    }

    public static byte[] encode(InputStream in, String key, ALGORITHM algorithm) throws IOException {
        int read;
        HMAC h = new HMAC(key, algorithm);
        byte[] data = new byte[DEFAULT_BUFF_SIZE];
        while ((read = in.read(data)) != -1) {
            h.update(data, 0, read);
        }
        return h.doFinal();
    }

    public static enum ALGORITHM {
        HmacMD5,
        HmacSHA1,
        HmacSHA256,
        HmacSHA384,
        HmacSHA512;

        public static ALGORITHM DEFAULT;

        public String getAlgorithm() {
            switch (this) {
                case HmacMD5: {
                    return "HmacMD5";
                }
                case HmacSHA1: {
                    return "HmacSHA1";
                }
                case HmacSHA256: {
                    return "HmacSHA256";
                }
                case HmacSHA384: {
                    return "HmacSHA384";
                }
                case HmacSHA512: {
                    return "HmacSHA512";
                }
            }
            return null;
        }

        static {
            DEFAULT = HmacMD5;
        }
    }
}

