/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBE {
    private Cipher cipher;
    private static final int ITERATION_COUNT = 100;

    public PBE(String password, byte[] salt, MODE mode) {
        this.init(password, salt, mode, null);
    }

    public PBE(String password, byte[] salt, MODE mode, ALGORITHM algorithm) {
        this.init(password, salt, mode, algorithm);
    }

    private boolean init(String password, byte[] salt, MODE mode, ALGORITHM algorithm) {
        block12: {
            try {
                if (algorithm == null) {
                    algorithm = ALGORITHM.DEFAULT;
                }
                if (mode == null) {
                    mode = MODE.DEFAULT;
                }
                PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm.getAlgorithm());
                SecretKey secretKey = keyFactory.generateSecret(keySpec);
                PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 100);
                this.cipher = Cipher.getInstance(algorithm.getAlgorithm());
                this.cipher.init(mode.getMode(), (Key)secretKey, paramSpec);
                return true;
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidAlgorithmParameterException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchPaddingException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeySpecException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block12;
                Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cipher = null;
        return false;
    }

    public byte[] update(byte[] input) {
        return this.cipher.update(input);
    }

    public byte[] update(byte[] input, int offset, int len) {
        return this.cipher.update(input, offset, len);
    }

    public byte[] doFinal(byte[] input) {
        block4: {
            try {
                return this.cipher.doFinal(input);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] doFinal(byte[] input, int offset, int len) {
        block4: {
            try {
                return this.cipher.doFinal(input, offset, len);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(PBE.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static byte[] generateSalt() {
        byte[] salt = new byte[8];
        Random random = new Random();
        random.nextBytes(salt);
        return salt;
    }

    public static byte[] encrypt(byte[] data, String password, byte[] salt) {
        return PBE.encrypt(data, password, salt, null);
    }

    public static byte[] encrypt(byte[] data, String password, byte[] salt, ALGORITHM algorithm) {
        return new PBE(password, salt, MODE.ENCRYPT, algorithm).doFinal(data);
    }

    public static byte[] decrypt(byte[] data, String password, byte[] salt) {
        return PBE.decrypt(data, password, salt, ALGORITHM.DEFAULT);
    }

    public static byte[] decrypt(byte[] data, String password, byte[] salt, ALGORITHM algorithm) {
        return new PBE(password, salt, MODE.DECRYPT, algorithm).doFinal(data);
    }

    public static enum MODE {
        ENCRYPT,
        DECRYPT;

        public static MODE DEFAULT;

        public int getMode() {
            switch (this) {
                case ENCRYPT: {
                    return 1;
                }
                case DECRYPT: {
                    return 2;
                }
            }
            return DEFAULT.getMode();
        }

        static {
            DEFAULT = ENCRYPT;
        }
    }

    public static enum ALGORITHM {
        PBEWithMD5AndDES,
        PBEWithMD5AndTripleDES,
        PBEWithSHA1AndDESede,
        PBEWithSHA1AndRC2_40;

        public static ALGORITHM DEFAULT;

        public String getAlgorithm() {
            switch (this) {
                case PBEWithMD5AndDES: {
                    return "PBEWithMD5AndDES";
                }
                case PBEWithMD5AndTripleDES: {
                    return "PBEWithMD5AndTripleDES";
                }
                case PBEWithSHA1AndDESede: {
                    return "PBEWithSHA1AndDESede";
                }
                case PBEWithSHA1AndRC2_40: {
                    return "PBEWithSHA1AndRC2_40";
                }
            }
            return null;
        }

        static {
            DEFAULT = PBEWithMD5AndDES;
        }
    }
}

