/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSA {
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;
    private Cipher cipher;
    private Signature signature;
    private MODE mode;

    public RSA(String key, MODE mode) {
        this.init(key, mode, null);
    }

    public RSA(String key, MODE mode, SIGNATURE_ALGORITHM algorithm) {
        this.init(key, mode, algorithm);
    }

    private boolean init(String key, MODE mode, SIGNATURE_ALGORITHM algorithm) {
        block18: {
            try {
                if (mode == null) {
                    this.mode = mode = MODE.DEFAULT;
                }
                if (algorithm == null) {
                    algorithm = SIGNATURE_ALGORITHM.DEFAULT;
                }
                byte[] keyBytes = BASE64.decode(key);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                switch (mode) {
                    case PRIVATE_SIGN: {
                        PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
                        this.signature = Signature.getInstance(algorithm.getAlgorithm());
                        this.signature.initSign(priKey);
                        break;
                    }
                    case PUBLIC_VERIFY: {
                        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
                        this.signature = Signature.getInstance(algorithm.getAlgorithm());
                        this.signature.initVerify(pubKey);
                        break;
                    }
                    case PRIVATE_ENCRYPT: {
                        PrivateKey priKey2 = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
                        this.cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                        this.cipher.init(1, priKey2);
                        break;
                    }
                    case PRIVATE_DECRYPT: {
                        PrivateKey priKey3 = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
                        this.cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                        this.cipher.init(2, priKey3);
                        break;
                    }
                    case PUBLIC_ENCRYPT: {
                        PublicKey pubKey2 = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
                        this.cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                        this.cipher.init(1, pubKey2);
                        break;
                    }
                    case PUBLIC_DECRYPT: {
                        PublicKey pubKey3 = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
                        this.cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                        this.cipher.init(2, pubKey3);
                    }
                }
                return true;
            }
            catch (NoSuchPaddingException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeySpecException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block18;
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cipher = null;
        this.signature = null;
        return false;
    }

    public byte[] update(byte[] input) {
        block3: {
            if (MODE.isCrypto(this.mode)) {
                return this.cipher.update(input);
            }
            try {
                this.signature.update(input);
            }
            catch (SignatureException ex) {
                if (!ConstFramework.getDebug()) break block3;
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] update(byte[] input, int offset, int len) {
        block3: {
            if (MODE.isCrypto(this.mode)) {
                return this.cipher.update(input, offset, len);
            }
            try {
                this.signature.update(input, offset, len);
            }
            catch (SignatureException ex) {
                if (!ConstFramework.getDebug()) break block3;
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] doFinal(byte[] input) {
        block4: {
            try {
                return this.cipher.doFinal(input);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] doFinal(byte[] input, int offset, int len) {
        block4: {
            try {
                return this.cipher.doFinal(input, offset, len);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public String sign() {
        try {
            return BASE64.encode(this.signature.sign());
        }
        catch (SignatureException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public boolean verify(String sign) {
        try {
            return this.signature.verify(BASE64.decode(sign));
        }
        catch (SignatureException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
    }

    public static Keys generateKeys() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            Keys keys = new Keys();
            keys.publicKey = BASE64.encode(keyPair.getPublic().getEncoded());
            keys.privateKey = BASE64.encode(keyPair.getPrivate().getEncoded());
            return keys;
        }
        catch (NoSuchAlgorithmException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(RSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) {
        return new RSA(key, MODE.PRIVATE_ENCRYPT).doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) {
        return new RSA(key, MODE.PRIVATE_DECRYPT).doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) {
        return new RSA(key, MODE.PUBLIC_ENCRYPT).doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) {
        return new RSA(key, MODE.PUBLIC_DECRYPT).doFinal(data);
    }

    public static String signByPrivateKey(byte[] data, String key) {
        return RSA.signByPrivateKey(data, key, null);
    }

    public static String signByPrivateKey(byte[] data, String key, SIGNATURE_ALGORITHM algorithm) {
        RSA rsa = new RSA(key, MODE.PRIVATE_SIGN, algorithm);
        rsa.update(data);
        return rsa.sign();
    }

    public static boolean verifyByPublicKey(byte[] data, String key, String sign) {
        return RSA.verifyByPublicKey(data, key, sign, null);
    }

    public static boolean verifyByPublicKey(byte[] data, String key, String sign, SIGNATURE_ALGORITHM algorithm) {
        RSA rsa = new RSA(key, MODE.PUBLIC_VERIFY, algorithm);
        rsa.update(data);
        return rsa.verify(sign);
    }

    public static enum MODE {
        PRIVATE_SIGN,
        PUBLIC_VERIFY,
        PRIVATE_ENCRYPT,
        PRIVATE_DECRYPT,
        PUBLIC_ENCRYPT,
        PUBLIC_DECRYPT;

        public static MODE DEFAULT;

        public static boolean isCrypto(MODE mode) {
            return mode == PRIVATE_ENCRYPT || mode == PRIVATE_DECRYPT || mode == PUBLIC_ENCRYPT || mode == PUBLIC_DECRYPT;
        }

        static {
            DEFAULT = PRIVATE_SIGN;
        }
    }

    public static enum SIGNATURE_ALGORITHM {
        MD5withRSA,
        SHA1withRSA,
        SHA256withRSA,
        SHA384withRSA,
        SHA512withRSA;

        public static SIGNATURE_ALGORITHM DEFAULT;

        public String getAlgorithm() {
            switch (this) {
                case MD5withRSA: {
                    return "MD5withRSA";
                }
                case SHA1withRSA: {
                    return "SHA1withRSA";
                }
                case SHA256withRSA: {
                    return "SHA256withRSA";
                }
                case SHA384withRSA: {
                    return "SHA384withRSA";
                }
                case SHA512withRSA: {
                    return "SHA512withRSA";
                }
            }
            return null;
        }

        static {
            DEFAULT = MD5withRSA;
        }
    }

    public static class Keys {
        public String publicKey;
        public String privateKey;
    }
}

