/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.daemon;

import com.modnut.framework2.daemon.DaemonBase;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class DaemonPool {
    private static final HashMap<String, DaemonBase> pool = new HashMap();
    private static Timer timer = null;
    private static long lastTime = System.currentTimeMillis();
    private static long TIMER_TIME = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has(String name) {
        HashMap<String, DaemonBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.containsKey(name);
        }
    }

    public static DaemonBase add(String name, DaemonBase task) {
        return DaemonPool.add(name, task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DaemonBase add(String name, DaemonBase task, boolean autoStart) {
        if (autoStart && timer == null) {
            DaemonPool.start(true);
        }
        HashMap<String, DaemonBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.put(name, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DaemonBase remove(String name) {
        HashMap<String, DaemonBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DaemonBase get(String name) {
        HashMap<String, DaemonBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.get(name);
        }
    }

    public static void start(boolean daemon) {
        DaemonPool.stop();
        timer = new Timer(daemon);
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        lastTime = cal.getTimeInMillis();
        timer.scheduleAtFixedRate(DaemonPool.getNewTask(), new Date(lastTime + TIMER_TIME), TIMER_TIME);
    }

    public static void stop() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    private static TimerTask getNewTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                lastTime = lastTime + TIMER_TIME;
                HashMap hashMap = pool;
                synchronized (hashMap) {
                    Iterator iterator = pool.keySet().iterator();
                    while (iterator.hasNext()) {
                        String name = (String)iterator.next();
                        DaemonBase task = (DaemonBase)pool.get(name);
                        if (task == null) continue;
                        if (task.getTimeout()) {
                            if (task.getRunning()) {
                                task.cancelTask();
                            }
                            iterator.remove();
                            continue;
                        }
                        if (task.getRunning() || !task.onSchedule(lastTime)) continue;
                        new Thread(task).start();
                    }
                }
            }
        };
    }
}

