/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import com.modnut.framework2.data.DataArr;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataObj {
    private final HashMap<String, Object> data = new HashMap();

    public Set<String> keys() {
        return this.data.keySet();
    }

    public int size() {
        return this.data.keySet().size();
    }

    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(size=").append(this.data.keySet().size()).append(")");
        int count = 0;
        for (String key : this.data.keySet()) {
            Object obj = this.data.get(key);
            if (count > 0) {
                sb.append(",");
            }
            sb.append(key).append("=");
            if (obj != null) {
                sb.append(obj.toString());
            } else {
                sb.append("null");
            }
            ++count;
        }
        return sb.toString();
    }

    private DataObj putObj(String key, Object obj) {
        if (this.data.containsKey(key)) {
            this.data.remove(key);
        }
        this.data.put(key, obj);
        return this;
    }

    public DataObj put(String key, Object dataObj) {
        return this.putObj(key, dataObj);
    }

    public DataObj put(String key, boolean dataBoolean) {
        return this.putObj(key, dataBoolean ? Boolean.TRUE : Boolean.FALSE);
    }

    public DataObj put(String key, char dataChar) {
        return this.putObj(key, new Character(dataChar));
    }

    public DataObj put(String key, byte dataByte) {
        return this.putObj(key, new Byte(dataByte));
    }

    public DataObj put(String key, short dataShort) {
        Short val = new Short(dataShort);
        return this.putObj(key, val);
    }

    public DataObj put(String key, int dataInteger) {
        Integer val = new Integer(dataInteger);
        return this.putObj(key, val);
    }

    public DataObj put(String key, long dataLong) {
        Long val = new Long(dataLong);
        return this.putObj(key, val);
    }

    public DataObj put(String key, float dataFloat) {
        Float val = new Float(dataFloat);
        return this.putObj(key, val);
    }

    public DataObj put(String key, double dataDouble) {
        Double val = new Double(dataDouble);
        return this.putObj(key, val);
    }

    public DataObj put(String key, String dataString) {
        return this.putObj(key, dataString);
    }

    public DataObj put(String key, DataCall dataCall) {
        return this.putObj(key, dataCall);
    }

    public <T> T get(String key, Class<T> c) {
        return this.get(key, c, false);
    }

    public <T> T get(String key, Class<T> c, boolean accurate) {
        Object obj;
        if (this.data.containsKey(key) && (obj = this.data.get(key)) != null && c != null && (accurate ? c.equals(obj.getClass()) : DataObj.baseOfClass(obj.getClass(), c))) {
            return (T)obj;
        }
        return null;
    }

    public Object getObject(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue() != 0L;
        }
        if (obj instanceof String) {
            try {
                return Boolean.parseBoolean((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public char getChar(String key, char defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return (char)((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                String str = (String)obj;
                return str.isEmpty() ? defaultVal : str.charAt(0);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public byte getByte(String key, byte defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            try {
                return Byte.parseByte((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public short getShort(String key, short defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public int getInt(String key, int defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public long getLong(String key, long defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public float getFloat(String key, float defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public double getDouble(String key, double defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public String getString(String key, String defaultVal) {
        Object obj = this.getObject(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public DataCall getCall(String key) {
        Object obj = this.getObject(key);
        if (obj != null && obj instanceof DataCall) {
            return (DataCall)obj;
        }
        return null;
    }

    public Object remove(String key) {
        return this.data.remove(key);
    }

    public void clear() {
        this.data.clear();
    }

    public static DataObj parseObj(Object obj) {
        return DataObj.parseObj(obj, false);
    }

    public static DataObj parseObj(Object obj, boolean parseArr) {
        return DataObj.parse(obj, DataObj.class, parseArr);
    }

    public static DataArr parseArr(Object obj) {
        return DataObj.parseArr(obj, false);
    }

    public static DataArr parseArr(Object obj, boolean parseArr) {
        return DataObj.parse(obj, DataArr.class, parseArr);
    }

    public static <T> T parse(Object obj, Class<T> c) {
        return DataObj.parse(obj, c, false);
    }

    public static <T> T parse(Object obj, Class<T> c, boolean parseArr) {
        return DataObj.parseObject(DataObj.obj2dat(obj, parseArr), c);
    }

    public static void update(Object obj, DataObj dat) {
        DataObj.update(obj, dat, false);
    }

    public static void update(Object obj, DataObj dat, boolean parseArr) {
        if (obj == null || dat == null) {
            return;
        }
        DataObj.obj2dat(obj, dat, parseArr);
    }

    public static <T> T create(Object obj, Class<T> c) {
        return DataObj.dat2obj(obj, c);
    }

    public static void update(DataObj dat, Object obj) {
        if (obj == null || dat == null) {
            return;
        }
        DataObj.dat2obj((Object)dat, obj);
    }

    protected static Object obj2dat(Object obj, boolean parseArr) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            if (parseArr) {
                DataArr data = new DataArr();
                DataObj.obj2dat(obj, data, parseArr);
                return data;
            }
            if (DataObj.hasInterface(cls.getComponentType(), DataParse.class)) {
                int length = Array.getLength(obj);
                Object arr = Array.newInstance(DataObj.class, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(arr, i, DataObj.obj2dat(Array.get(obj, i), parseArr));
                }
                return arr;
            }
            return obj;
        }
        if (DataObj.hasInterface(cls, DataParse.class)) {
            DataObj data = new DataObj();
            DataObj.obj2dat(obj, data, parseArr);
            return data;
        }
        if (DataObj.hasInterface(cls, List.class)) {
            List listObj = (List)obj;
            List newListObj = (List)DataObj.newInstance(cls);
            if (newListObj != null) {
                for (int i = 0; i < listObj.size(); ++i) {
                    newListObj.add(DataObj.obj2dat(listObj.get(i), parseArr));
                }
                return newListObj;
            }
            return listObj;
        }
        if (DataObj.hasInterface(cls, Map.class)) {
            Map mapObj = (Map)obj;
            Map newMapObj = (Map)DataObj.newInstance(cls);
            if (newMapObj != null) {
                for (Object mapKey : mapObj.keySet()) {
                    newMapObj.put(mapKey, DataObj.obj2dat(mapObj.get(mapKey), parseArr));
                }
                return newMapObj;
            }
            return mapObj;
        }
        return obj;
    }

    protected static void obj2dat(Object obj, DataObj dat, boolean parseArr) {
        block23: {
            Class<?> cls;
            block22: {
                if (obj == null || dat == null) {
                    return;
                }
                cls = obj.getClass();
                if (!cls.isArray()) break block22;
                if (!(dat instanceof DataArr)) break block23;
                DataArr arr = (DataArr)dat;
                arr.clear(true, false);
                Class<?> type = cls.getComponentType();
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    if (Boolean.TYPE.equals(type)) {
                        arr.put(Array.getBoolean(obj, i));
                        continue;
                    }
                    if (Byte.TYPE.equals(type)) {
                        arr.put(Array.getByte(obj, i));
                        continue;
                    }
                    if (Character.TYPE.equals(type)) {
                        arr.put(Array.getChar(obj, i));
                        continue;
                    }
                    if (Short.TYPE.equals(type)) {
                        arr.put(Array.getShort(obj, i));
                        continue;
                    }
                    if (Integer.TYPE.equals(type)) {
                        arr.put(Array.getInt(obj, i));
                        continue;
                    }
                    if (Long.TYPE.equals(type)) {
                        arr.put(Array.getLong(obj, i));
                        continue;
                    }
                    if (Float.TYPE.equals(type)) {
                        arr.put(Array.getFloat(obj, i));
                        continue;
                    }
                    if (Double.TYPE.equals(type)) {
                        arr.put(Array.getDouble(obj, i));
                        continue;
                    }
                    arr.put(DataObj.obj2dat(Array.get(obj, i), parseArr));
                }
                break block23;
            }
            if (!cls.isArray()) {
                for (Field field : cls.getFields()) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                    String name = field.getName();
                    Class<?> type = field.getType();
                    try {
                        if (Boolean.TYPE.equals(type)) {
                            dat.put(name, field.getBoolean(obj));
                            continue;
                        }
                        if (Byte.TYPE.equals(type)) {
                            dat.put(name, field.getByte(obj));
                            continue;
                        }
                        if (Character.TYPE.equals(type)) {
                            dat.put(name, field.getChar(obj));
                            continue;
                        }
                        if (Short.TYPE.equals(type)) {
                            dat.put(name, field.getShort(obj));
                            continue;
                        }
                        if (Integer.TYPE.equals(type)) {
                            dat.put(name, field.getInt(obj));
                            continue;
                        }
                        if (Long.TYPE.equals(type)) {
                            dat.put(name, field.getLong(obj));
                            continue;
                        }
                        if (Float.TYPE.equals(type)) {
                            dat.put(name, field.getFloat(obj));
                            continue;
                        }
                        if (Double.TYPE.equals(type)) {
                            dat.put(name, field.getDouble(obj));
                            continue;
                        }
                        dat.put(name, DataObj.obj2dat(field.get(obj), parseArr));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected static <T> T dat2obj(Object dat, Class<T> cls) {
        if (dat == null || cls == null) {
            return null;
        }
        Class<?> datCls = dat.getClass();
        if (cls.isArray()) {
            Class<?> type = cls.getComponentType();
            if (dat instanceof DataArr) {
                DataArr arr = (DataArr)dat;
                Object obj = Array.newInstance(type, arr.length());
                DataObj.dat2obj(dat, obj);
                return (T)obj;
            }
            if (datCls.isArray()) {
                Class<?> datType = datCls.getComponentType();
                if (datCls.equals(cls)) {
                    return (T)dat;
                }
                if (DataObj.hasInterface(type, DataParse.class) && DataObj.baseOfClass(datType, DataObj.class)) {
                    Object obj = Array.newInstance(type, Array.getLength(dat));
                    DataObj.dat2obj(dat, obj);
                    return (T)obj;
                }
                return null;
            }
            return null;
        }
        if (DataObj.hasInterface(cls, DataParse.class) && dat instanceof DataObj) {
            T obj = DataObj.newInstance(cls);
            DataObj.dat2obj(dat, obj);
            return obj;
        }
        return DataObj.parseObject(dat, cls);
    }

    protected static void dat2obj(Object dat, Object obj) {
        block35: {
            Class<?> cls;
            block33: {
                Class<?> datType;
                Class<?> type;
                block36: {
                    Class<?> datCls;
                    block34: {
                        if (dat == null || obj == null) {
                            return;
                        }
                        cls = obj.getClass();
                        datCls = dat.getClass();
                        if (!cls.isArray()) break block33;
                        type = cls.getComponentType();
                        if (!(dat instanceof DataArr)) break block34;
                        DataArr datArr = (DataArr)dat;
                        int len1 = datArr.length();
                        int len2 = Array.getLength(obj);
                        for (int i = 0; i < len2; ++i) {
                            if (Boolean.TYPE.equals(type)) {
                                Array.setBoolean(obj, i, i < len1 ? datArr.getBoolean(i, false) : false);
                                continue;
                            }
                            if (Byte.TYPE.equals(type)) {
                                Array.setByte(obj, i, i < len1 ? datArr.getByte(i, (byte)0) : (byte)0);
                                continue;
                            }
                            if (Character.TYPE.equals(type)) {
                                Array.setChar(obj, i, i < len1 ? datArr.getChar(i, '\u0000') : (char)'\u0000');
                                continue;
                            }
                            if (Short.TYPE.equals(type)) {
                                Array.setShort(obj, i, i < len1 ? datArr.getShort(i, (short)0) : (short)0);
                                continue;
                            }
                            if (Integer.TYPE.equals(type)) {
                                Array.setInt(obj, i, i < len1 ? datArr.getInt(i, 0) : 0);
                                continue;
                            }
                            if (Long.TYPE.equals(type)) {
                                Array.setLong(obj, i, i < len1 ? datArr.getLong(i, 0L) : 0L);
                                continue;
                            }
                            if (Float.TYPE.equals(type)) {
                                Array.setFloat(obj, i, i < len1 ? datArr.getFloat(i, 0.0f) : 0.0f);
                                continue;
                            }
                            if (Double.TYPE.equals(type)) {
                                Array.setDouble(obj, i, i < len1 ? datArr.getDouble(i, 0.0) : 0.0);
                                continue;
                            }
                            Array.set(obj, i, i < len1 ? DataObj.dat2obj(datArr.getObject(i), type) : null);
                        }
                        break block35;
                    }
                    if (!datCls.isArray()) break block35;
                    datType = datCls.getComponentType();
                    if (!datCls.equals(cls)) break block36;
                    int len1 = Array.getLength(dat);
                    int len2 = Array.getLength(obj);
                    for (int i = 0; i < len2; ++i) {
                        if (Boolean.TYPE.equals(type)) {
                            Array.setBoolean(obj, i, i < len1 ? Array.getBoolean(dat, i) : false);
                            continue;
                        }
                        if (Byte.TYPE.equals(type)) {
                            Array.setByte(obj, i, i < len1 ? Array.getByte(dat, i) : (byte)0);
                            continue;
                        }
                        if (Character.TYPE.equals(type)) {
                            Array.setChar(obj, i, i < len1 ? Array.getChar(dat, i) : (char)'\u0000');
                            continue;
                        }
                        if (Short.TYPE.equals(type)) {
                            Array.setShort(obj, i, i < len1 ? Array.getShort(dat, i) : (short)0);
                            continue;
                        }
                        if (Integer.TYPE.equals(type)) {
                            Array.setInt(obj, i, i < len1 ? Array.getInt(dat, i) : 0);
                            continue;
                        }
                        if (Long.TYPE.equals(type)) {
                            Array.setLong(obj, i, i < len1 ? Array.getLong(dat, i) : 0L);
                            continue;
                        }
                        if (Float.TYPE.equals(type)) {
                            Array.setFloat(obj, i, i < len1 ? Array.getFloat(dat, i) : 0.0f);
                            continue;
                        }
                        if (Double.TYPE.equals(type)) {
                            Array.setDouble(obj, i, i < len1 ? Array.getDouble(dat, i) : 0.0);
                            continue;
                        }
                        Array.set(obj, i, i < len1 ? DataObj.dat2obj(Array.get(dat, i), type) : null);
                    }
                    break block35;
                }
                if (!DataObj.hasInterface(type, DataParse.class) || !DataObj.baseOfClass(datType, DataObj.class)) break block35;
                int len1 = Array.getLength(dat);
                int len2 = Array.getLength(obj);
                for (int i = 0; i < len2; ++i) {
                    Array.set(obj, i, i < len1 ? DataObj.dat2obj(Array.get(dat, i), type) : null);
                }
                break block35;
            }
            if (DataObj.hasInterface(cls, DataParse.class) && dat instanceof DataObj) {
                DataObj datObj = (DataObj)dat;
                for (String name : datObj.keys()) {
                    Field field = DataObj.getField(cls, name);
                    if (field == null) continue;
                    Class<?> type = field.getType();
                    try {
                        if (Boolean.TYPE.equals(type)) {
                            field.setBoolean(obj, datObj.getBoolean(name, false));
                            continue;
                        }
                        if (Byte.TYPE.equals(type)) {
                            field.setByte(obj, datObj.getByte(name, (byte)0));
                            continue;
                        }
                        if (Character.TYPE.equals(type)) {
                            field.setChar(obj, datObj.getChar(name, '\u0000'));
                            continue;
                        }
                        if (Short.TYPE.equals(type)) {
                            field.setShort(obj, datObj.getShort(name, (short)0));
                            continue;
                        }
                        if (Integer.TYPE.equals(type)) {
                            field.setInt(obj, datObj.getInt(name, 0));
                            continue;
                        }
                        if (Long.TYPE.equals(type)) {
                            field.setLong(obj, datObj.getLong(name, 0L));
                            continue;
                        }
                        if (Float.TYPE.equals(type)) {
                            field.setFloat(obj, datObj.getFloat(name, 0.0f));
                            continue;
                        }
                        if (Double.TYPE.equals(type)) {
                            field.setDouble(obj, datObj.getDouble(name, 0.0));
                            continue;
                        }
                        field.set(obj, DataObj.dat2obj(datObj.getObject(name), type));
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(DataObj.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(DataObj.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    protected static boolean baseOfClass(Class c, Class baseclass) {
        Class superclass = c;
        while (superclass != null) {
            if (superclass.equals(baseclass)) {
                return true;
            }
            c = superclass;
            superclass = c.getSuperclass();
        }
        return false;
    }

    protected static <T> T parseObject(Object o, Class<T> c) {
        if (o != null && DataObj.baseOfClass(o.getClass(), c)) {
            return (T)o;
        }
        return null;
    }

    protected static boolean hasInterface(Class c, Class i) {
        for (Class<?> ci : c.getInterfaces()) {
            if (!i.equals(ci)) continue;
            return true;
        }
        return false;
    }

    protected static <T> T newInstance(Class<T> c) {
        T obj = null;
        try {
            obj = c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static Field getField(Class c, String name) {
        Field f = null;
        try {
            f = c.getField(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static interface DataParse {
    }

    public static abstract class DataCall {
        public abstract Object call(Object ... var1);
    }
}

