/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import com.modnut.framework2.constant.ConstFramework;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class DataProp {
    protected final HashMap<String, String> props = new HashMap();
    private Charset charset = ConstFramework.getCharset();

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public String getCharset() {
        return this.charset.name();
    }

    public String get(String name) {
        return this.get(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String name, String defaultVal) {
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            String val = this.props.get(name);
            return val == null ? defaultVal : val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String name, String value) {
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            return this.props.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            return this.props.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(String name) {
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            return this.props.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> names() {
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            return this.props.keySet();
        }
    }

    public void load(InputStream in) throws IOException {
        this.load(new InputStreamReader(in, this.charset));
    }

    public void load(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        try {
            this.load(reader);
        }
        finally {
            reader.close();
        }
    }

    public void load(String str) throws IOException {
        StringReader reader = new StringReader(str);
        try {
            this.load(reader);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            this.props.clear();
            String line = in.readLine();
            while (line != null) {
                int index;
                if (!line.trim().startsWith("#") && !line.trim().isEmpty() && (index = line.indexOf("=")) >= 0) {
                    String name = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (!name.isEmpty() && !value.isEmpty()) {
                        this.props.put(name, value);
                    }
                }
                line = in.readLine();
            }
        }
    }

    public void store(OutputStream out) throws IOException {
        this.store(new OutputStreamWriter(out, this.charset));
    }

    public void store(File file) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        try {
            this.store(writer);
        }
        finally {
            writer.close();
        }
    }

    public String store() throws IOException {
        StringWriter out = new StringWriter();
        try {
            this.store(out);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Writer writer) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        HashMap<String, String> hashMap = this.props;
        synchronized (hashMap) {
            for (String name : this.props.keySet()) {
                String value = this.props.get(name);
                out.write(name);
                out.write(61);
                out.write(value == null ? "" : value);
                out.newLine();
            }
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(InputStream src, OutputStream dest) throws IOException {
        ArrayList<String> buff;
        InputStreamReader reader = new InputStreamReader(src, this.charset);
        try {
            buff = this.readBuff(reader);
        }
        finally {
            reader.close();
        }
        OutputStreamWriter writer = new OutputStreamWriter(dest, this.charset);
        try {
            this.writeBuff(writer, buff);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File src, File dest) throws IOException {
        ArrayList<String> buff;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(src), this.charset);
        try {
            buff = this.readBuff(reader);
        }
        finally {
            reader.close();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), this.charset);
        try {
            this.writeBuff(writer, buff);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String store(String src) throws IOException {
        ArrayList<String> buff;
        StringReader reader = new StringReader(src);
        try {
            buff = this.readBuff(reader);
        }
        finally {
            reader.close();
        }
        StringWriter writer = new StringWriter();
        try {
            this.writeBuff(writer, buff);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public void store(Reader reader, Writer writer) throws IOException {
        this.writeBuff(writer, this.readBuff(reader));
    }

    private ArrayList<String> readBuff(Reader reader) throws IOException {
        String value;
        HashMap<String, String> copy = new HashMap<String, String>();
        for (String name : this.props.keySet()) {
            copy.put(name, this.props.get(name));
        }
        ArrayList<String> buff = new ArrayList<String>();
        BufferedReader in = new BufferedReader(reader);
        String line = in.readLine();
        while (line != null) {
            String name;
            int index;
            if (!(line.trim().startsWith("#") || line.trim().isEmpty() || (index = line.indexOf("=")) < 0 || (name = line.substring(0, index).trim()).isEmpty())) {
                value = (String)copy.get(name);
                buff.add(name + "=" + (value == null ? "" : value));
                line = in.readLine();
                copy.remove(name);
                continue;
            }
            buff.add(line);
            line = in.readLine();
        }
        if (!copy.isEmpty()) {
            for (String name : copy.keySet()) {
                value = (String)copy.get(name);
                buff.add(name + "=" + (value == null ? "" : value));
            }
        }
        return buff;
    }

    private void writeBuff(Writer writer, ArrayList<String> buff) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        for (String buffLine : buff) {
            out.write(buffLine);
            out.newLine();
        }
        out.flush();
    }
}

