/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.database.DBMulValPair;
import com.modnut.framework2.database.DBValPair;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DBMyHelper {
    private static final String SHOW = "SHOW";
    private static final String DATABASES = "DATABASES";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String LIKE = "LIKE";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String INTO = "INTO";
    private static final String WHERE = "WHERE";
    private static final String ORDER_BY = "ORDER BY";
    private static final String GROUP_BY = "GROUP BY";
    private static final String LIMIT = "LIMIT";
    private static final String INSERT = "INSERT";
    private static final String UPDATE = "UPDATE";
    private static final String DELETE = "DELETE";
    private static final String VALUES = "VALUES";
    private static final String SET = "SET";
    private static final String AS = "AS";
    private static final String USE_INDEX = "USE INDEX";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String FUNC_COUNT_NAME = "COUNT";
    private static final String FUNC_MAX_NAME = "MAX";
    private static final String FUNC_MIN_NAME = "MIN";
    private static final String FUNC_SUM_NAME = "SUM";
    private static final String FUNC_AVG_NAME = "AVG";
    private static final String CNT_COLUMN = "c";
    private static final String MAX_COLUMN = "m";
    private static final String MIN_COLUMN = "m";
    private static final String SUM_COLUMN = "s";
    private static final String AVG_COLUMN = "a";
    private static final String NULL = "NULL";
    private static final String[] COUNT_COLS = new String[]{"COUNT(*) AS c"};

    public static ResultSet getDatabases(Statement stat) throws SQLException {
        return DBMyHelper.getDatabases(stat, null);
    }

    public static ResultSet getDatabases(Statement stat, String likeStr) throws SQLException {
        String sqlStr = "SHOW DATABASES";
        if (likeStr != null) {
            sqlStr = sqlStr + " LIKE " + likeStr;
        }
        return DBMyHelper.fullQuery(stat, sqlStr);
    }

    public static ResultSet getTables(Statement stat) throws SQLException {
        return DBMyHelper.getTables(stat, null, null);
    }

    public static ResultSet getTables(Statement stat, String likeStr) throws SQLException {
        return DBMyHelper.getTables(stat, likeStr, null);
    }

    public static ResultSet getTables(Statement stat, String likeStr, String database) throws SQLException {
        String sqlStr = "SHOW TABLES";
        if (database != null) {
            sqlStr = sqlStr + " FROM " + database;
        }
        if (likeStr != null) {
            sqlStr = sqlStr + " LIKE " + likeStr;
        }
        return DBMyHelper.fullQuery(stat, sqlStr);
    }

    public static ResultSet getColumns(Statement stat, String table) throws SQLException {
        return DBMyHelper.getColumns(stat, table, null, null);
    }

    public static ResultSet getColumns(Statement stat, String table, String likeStr) throws SQLException {
        return DBMyHelper.getColumns(stat, table, likeStr, null);
    }

    public static ResultSet getColumns(Statement stat, String table, String likeStr, String database) throws SQLException {
        String sqlStr = "SHOW COLUMNS";
        if (table != null) {
            sqlStr = sqlStr + " FROM " + table;
        }
        if (database != null) {
            sqlStr = sqlStr + " FROM " + database;
        }
        if (likeStr != null) {
            sqlStr = sqlStr + " LIKE " + likeStr;
        }
        return DBMyHelper.fullQuery(stat, sqlStr);
    }

    public static String formatSqlStr(String str) {
        char[] chArr;
        if (str == null) {
            return NULL;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        block11: for (char ch : chArr = str.toCharArray()) {
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '/': {
                    sb.append("\\/");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                default: {
                    if (ch < ' ' && ch >= '\u0000') continue block11;
                    sb.append(ch);
                }
            }
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String createSearchStr(String str) {
        return DBMyHelper.createSearchStr(str, false, false);
    }

    public static String createPrefixSearchStr(String str) {
        return DBMyHelper.createSearchStr(str, true, false);
    }

    public static String createSuffixSearchStr(String str) {
        return DBMyHelper.createSearchStr(str, false, true);
    }

    public static String createSearchStr(String str, boolean prefix, boolean suffix) {
        if (str == null) {
            return "'%'";
        }
        char[] chArr = str.trim().toCharArray();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix ? "'" : "'%");
        block13: for (char ch : chArr) {
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block13;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block13;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block13;
                }
                case '/': {
                    sb.append("\\/");
                    continue block13;
                }
                case '%': {
                    sb.append("\\%");
                    continue block13;
                }
                case '_': {
                    sb.append("\\_");
                    continue block13;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block13;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block13;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block13;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block13;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block13;
                }
                default: {
                    if (ch < ' ' && ch >= '\u0000') continue block13;
                    sb.append(ch);
                }
            }
        }
        sb.append(suffix ? "'" : "%'");
        return sb.toString();
    }

    public static String buildQuery(String tbName, String[] colNames, String whereStr, String groupStr, String orderStr, String limitStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(colNames[i]);
            }
        } else {
            sb.append('*');
        }
        sb.append(" FROM ").append(tbName);
        if (whereStr != null) {
            sb.append(" WHERE ").append(whereStr);
        }
        if (groupStr != null) {
            sb.append(" GROUP BY ").append(groupStr);
        }
        if (orderStr != null) {
            sb.append(" ORDER BY ").append(orderStr);
        }
        if (limitStr != null) {
            sb.append(" LIMIT ").append(limitStr);
        }
        return sb.toString();
    }

    public static String buildSubQuery(String tbName, String colName, String whereStr, String groupStr, String orderStr, String limitStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT ").append(colName).append(" FROM ").append(tbName);
        if (whereStr != null) {
            sb.append(" WHERE ").append(whereStr);
        }
        if (groupStr != null) {
            sb.append(" GROUP BY ").append(groupStr);
        }
        if (orderStr != null) {
            sb.append(" ORDER BY ").append(orderStr);
        }
        if (limitStr != null) {
            sb.append(" LIMIT ").append(limitStr);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String funcSum(String param, String colName) {
        return "SUM(" + param + ") " + AS + " " + colName;
    }

    public static String funcAvg(String param, String colName) {
        return "AVG(" + param + ") " + AS + " " + colName;
    }

    public static String funcMax(String param, String colName) {
        return "MAX(" + param + ") " + AS + " " + colName;
    }

    public static String funcMin(String param, String colName) {
        return "MAX(" + param + ") " + AS + " " + colName;
    }

    public static String funcCount(String param, String colName) {
        return "COUNT(" + param + ") " + AS + " " + colName;
    }

    public static String andWhereStr(String whereStr) {
        return whereStr == null ? "" : " AND " + whereStr;
    }

    public static String orWhereStr(String whereStr) {
        return whereStr == null ? "" : " OR " + whereStr;
    }

    public static String andWhereStrs(String[] whereStrs) {
        if (whereStrs == null || whereStrs.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int solveWhereCnt = 0;
        for (String whereStr : whereStrs) {
            if (whereStr == null) continue;
            if (solveWhereCnt > 0) {
                sb.append(" AND ");
            }
            sb.append(whereStr);
            ++solveWhereCnt;
        }
        return solveWhereCnt == 0 ? null : sb.toString();
    }

    public static String orWhereStrs(String[] whereStrs) {
        if (whereStrs == null || whereStrs.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int solveWhereCnt = 0;
        for (String whereStr : whereStrs) {
            if (whereStr == null) continue;
            if (solveWhereCnt > 0) {
                sb.append(" OR ");
            }
            sb.append(whereStr);
            ++solveWhereCnt;
        }
        return solveWhereCnt == 0 ? null : sb.toString();
    }

    public static String euqalStr(String valueA, String valueB) {
        return DBMyHelper.euqalStr(valueA, valueB, true);
    }

    public static String euqalStr(String valueA, String valueB, boolean bIsStr) {
        return valueA + "=" + (bIsStr ? DBMyHelper.formatSqlStr(valueB) : valueB);
    }

    public static boolean execute(Statement stat, String cmdStr) throws SQLException {
        return stat.execute(DBMyHelper.echoSql((short)0, cmdStr));
    }

    public static ResultSet fullQuery(Statement stat, String sqlStr) throws SQLException {
        return stat.executeQuery(DBMyHelper.echoSql((short)1, sqlStr));
    }

    public static ResultSet query(Statement stat, String tbName, String[] colNames, String whereStr, String groupStr, String orderStr, String limitStr) throws SQLException {
        String queryStr = DBMyHelper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr, limitStr);
        return stat.executeQuery(DBMyHelper.echoSql((short)1, queryStr));
    }

    public static int insert(Statement stat, String tbName, DBValPair[] values) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tbName).append("(");
        for (i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(values[i].colName);
        }
        sb.append(")VALUES(");
        for (i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(DBMyHelper.getDBValPairVal(values[i]));
        }
        sb.append(")");
        return stat.executeUpdate(DBMyHelper.echoSql((short)2, sb.toString()));
    }

    public static int insert(Statement stat, String tbName, DBMulValPair[] values) throws SQLException {
        StringBuilder sb = new StringBuilder();
        int maxRows = 0;
        sb.append("INSERT INTO ").append(tbName).append("(");
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(values[i].colName);
            if (maxRows >= values[i].colValues.size()) continue;
            maxRows = values[i].colValues.size();
        }
        if (maxRows == 0) {
            return 0;
        }
        sb.append(")VALUES");
        for (int row = 0; row < maxRows; ++row) {
            sb.append(row > 0 ? ",(" : "(");
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(DBMyHelper.getDBMulValPairVal(values[i], row));
            }
            sb.append(")");
        }
        return stat.executeUpdate(DBMyHelper.echoSql((short)2, sb.toString()));
    }

    public static int update(Statement stat, String tbName, DBValPair[] values, String whereStr) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(tbName).append(" SET ");
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(values[i].colName);
            sb.append("=");
            sb.append(DBMyHelper.getDBValPairVal(values[i]));
        }
        if (whereStr != null) {
            sb.append(" WHERE ").append(whereStr);
        }
        return stat.executeUpdate(DBMyHelper.echoSql((short)3, sb.toString()));
    }

    public static int delete(Statement stat, String tbName, String whereStr) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(tbName);
        if (whereStr != null) {
            sb.append(" WHERE ").append(whereStr);
        }
        return stat.executeUpdate(DBMyHelper.echoSql((short)4, sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Statement stat, String tbName, String whereStr) throws SQLException {
        ResultSet rs = DBMyHelper.query(stat, tbName, COUNT_COLS, whereStr, null, null, null);
        try {
            long l = rs.next() ? rs.getLong(CNT_COLUMN) : 0L;
            return l;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Statement stat, String tbName, String cntColName, String whereStr) throws SQLException {
        String[] cntParam = new String[]{"COUNT(" + cntColName + ") " + AS + " " + CNT_COLUMN};
        ResultSet rs = DBMyHelper.query(stat, tbName, cntParam, whereStr, null, null, null);
        try {
            long l = rs.next() ? rs.getLong(CNT_COLUMN) : 0L;
            return l;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long max(Statement stat, String tbName, String maxColName, String whereStr) throws SQLException {
        String[] maxParam = new String[]{"MAX(" + maxColName + ") " + AS + " " + "m"};
        ResultSet rs = DBMyHelper.query(stat, tbName, maxParam, whereStr, null, null, null);
        try {
            long l = rs.next() ? rs.getLong("m") : 0L;
            return l;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long min(Statement stat, String tbName, String minColName, String whereStr) throws SQLException {
        String[] minParam = new String[]{"MIN(" + minColName + ") " + AS + " " + "m"};
        ResultSet rs = DBMyHelper.query(stat, tbName, minParam, whereStr, null, null, null);
        try {
            long l = rs.next() ? rs.getLong("m") : 0L;
            return l;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double sum(Statement stat, String tbName, String sumColName, String whereStr) throws SQLException {
        String[] sumParam = new String[]{"SUM(" + sumColName + ") " + AS + " " + SUM_COLUMN};
        ResultSet rs = DBMyHelper.query(stat, tbName, sumParam, whereStr, null, null, null);
        try {
            double d = rs.next() ? rs.getDouble(SUM_COLUMN) : 0.0;
            return d;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double avg(Statement stat, String tbName, String avgColName, String whereStr) throws SQLException {
        String[] avgParam = new String[]{"AVG(" + avgColName + ") " + AS + " " + AVG_COLUMN};
        ResultSet rs = DBMyHelper.query(stat, tbName, avgParam, whereStr, null, null, null);
        try {
            double d = rs.next() ? rs.getDouble(AVG_COLUMN) : 0.0;
            return d;
        }
        finally {
            rs.close();
        }
    }

    private static String getDBValPairVal(DBValPair valuePair) {
        return DBMyHelper.getValString(valuePair.colValue);
    }

    private static String getDBMulValPairVal(DBMulValPair valuesPair, int row) {
        int size = valuesPair.colValues.size();
        if (size <= row) {
            return size > 0 ? DBMyHelper.getDBMulValPairVal(valuesPair, 0) : NULL;
        }
        DBMulValPair.ColValue value = valuesPair.colValues.get(row);
        return DBMyHelper.getValString(value.colObj);
    }

    private static String getValString(Object val) {
        if (val == null) {
            return NULL;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? "b'1'" : "b'0'";
        }
        if (val instanceof Byte) {
            return ((Byte)val).toString();
        }
        if (val instanceof Character) {
            return DBMyHelper.formatSqlStr(((Character)val).toString());
        }
        if (val instanceof Short) {
            return ((Short)val).toString();
        }
        if (val instanceof Integer) {
            return ((Integer)val).toString();
        }
        if (val instanceof Long) {
            return ((Long)val).toString();
        }
        if (val instanceof Float) {
            return ((Float)val).toString();
        }
        if (val instanceof Double) {
            return ((Double)val).toString();
        }
        if (val instanceof String) {
            return DBMyHelper.formatSqlStr((String)val);
        }
        if (val instanceof DBValPair.SqlString) {
            return ((DBValPair.SqlString)val).sql;
        }
        if (val instanceof DBValPair.SqlTimestamp) {
            return DBMyHelper.toDateTimeString(((DBValPair.SqlTimestamp)val).toDate());
        }
        if (val instanceof Date) {
            return DBMyHelper.toDateTimeString((Date)val);
        }
        if (val instanceof Time) {
            return DBMyHelper.toDateTimeString((Time)val);
        }
        if (val instanceof Timestamp) {
            return DBMyHelper.toDateTimeString((Timestamp)val);
        }
        if (val instanceof java.util.Date) {
            return DBMyHelper.toDateTimeString((java.util.Date)val);
        }
        return DBMyHelper.formatSqlStr(val.toString());
    }

    public static String toDateTimeString(java.util.Date date) {
        if (date == null) {
            return NULL;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        StringBuilder sb = new StringBuilder("'");
        sb.append(c.get(1)).append("-");
        DBMyHelper.appendXX(sb, c.get(2) + 1).append("-");
        DBMyHelper.appendXX(sb, c.get(5));
        if (date instanceof Date) {
            return sb.append("'").toString();
        }
        sb.append(' ');
        DBMyHelper.appendXX(sb, c.get(11)).append(':');
        DBMyHelper.appendXX(sb, c.get(12)).append(':');
        return DBMyHelper.appendXX(sb, c.get(13)).append("'").toString();
    }

    private static StringBuilder appendXX(StringBuilder sb, int num) {
        if (num >= 10) {
            sb.append(num);
        } else {
            sb.append('0').append(num);
        }
        return sb;
    }

    private static String echoSql(short type, String sqlStr) {
        if (ConstFramework.getDebug()) {
            System.out.print("[MYSQL-");
            switch (type) {
                case 0: {
                    System.out.print("EXECUTE");
                    break;
                }
                case 1: {
                    System.out.print("QUERY");
                    break;
                }
                case 2: {
                    System.out.print(INSERT);
                    break;
                }
                case 3: {
                    System.out.print(UPDATE);
                    break;
                }
                case 4: {
                    System.out.print(DELETE);
                }
            }
            System.out.print("]");
            System.out.println(sqlStr);
        }
        return sqlStr;
    }

    private static final class ECHO_TYPE {
        static final short EXECUTE = 0;
        static final short QUERY = 1;
        static final short INSERT = 2;
        static final short UPDATE = 3;
        static final short DELETE = 4;

        private ECHO_TYPE() {
        }
    }
}

