/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBConn;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBStat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPool {
    private static final HashMap<String, DBConn> pool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has(String name) {
        HashMap<String, DBConn> hashMap = pool;
        synchronized (hashMap) {
            return pool.containsKey(name);
        }
    }

    public static boolean init(String dbName, String dbUrl) {
        return DBPool.init(dbName, dbUrl, null, null, true);
    }

    public static boolean init(String dbName, String dbUrl, boolean overwrite) {
        return DBPool.init(dbName, dbUrl, null, null, overwrite);
    }

    public static boolean init(String dbName, String dbUrl, String dbUser, String dbPasswd) {
        return DBPool.init(dbName, dbUrl, dbUser, dbPasswd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init(String dbName, String dbUrl, String dbUser, String dbPasswd, boolean overwrite) {
        HashMap<String, DBConn> hashMap = pool;
        synchronized (hashMap) {
            if (pool.containsKey(dbName) && !overwrite) {
                return false;
            }
            if (pool.containsKey(dbName)) {
                DBPool.destroy(dbName);
            }
            try {
                DBConn conn = new DBConn(dbUrl, dbUser, dbPasswd);
                pool.put(dbName, conn);
                return true;
            }
            catch (DBException ex) {
                Logger.getLogger(DBPool.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroy(String name) {
        HashMap<String, DBConn> hashMap = pool;
        synchronized (hashMap) {
            if (pool.containsKey(name)) {
                DBConn.close(pool.remove(name));
                return true;
            }
            return false;
        }
    }

    public static DBConn getConn(String dbName) throws DBException {
        HashMap<String, DBConn> hashMap = pool;
        synchronized (hashMap) {
            if (pool.containsKey(dbName)) {
                return pool.get(dbName);
            }
            throw new DBException("Database config not init");
        }
    }

    public static DBConn getNewConn(String dbName) throws DBException {
        return DBPool.getConn(dbName).getClone();
    }

    public static DBStat getNewStat(String dbName) throws DBException {
        return DBPool.getConn(dbName).getNewDBStat();
    }
}

