/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBResult;
import java.sql.SQLException;
import java.sql.Statement;

public class DBStat {
    private Statement stat;
    private short type;

    public DBStat(Statement stat) throws DBException {
        if (stat == null) {
            throw new DBException("statement is null");
        }
        this.stat = stat;
        this.type = 0;
    }

    public DBStat(Statement stat, short type) throws DBException {
        if (stat == null) {
            throw new DBException("statement is null");
        }
        this.stat = stat;
        this.type = type;
    }

    public synchronized Statement getOrigin() {
        return this.stat;
    }

    public short getType() {
        return this.type;
    }

    public boolean isClosed() throws DBException {
        try {
            return this.getOrigin().isClosed();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        catch (AbstractMethodError ex) {
            return false;
        }
    }

    public void close() throws DBException {
        if (!this.isClosed()) {
            try {
                this.getOrigin().close();
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
    }

    public boolean execute(String sql) throws DBException {
        try {
            return this.getOrigin().execute(sql);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public DBResult getResultSet() throws DBException {
        try {
            return new DBResult(this.getOrigin().getResultSet(), this.type);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getUpdateCount() throws DBException {
        try {
            return this.getOrigin().getUpdateCount();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int executeUpdate(String sql) throws DBException {
        try {
            return this.getOrigin().executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public DBResult executeQuery(String sql) throws DBException {
        try {
            return new DBResult(this.getOrigin().executeQuery(sql), this.type);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static void close(DBStat stat) {
        try {
            if (stat != null && !stat.isClosed()) {
                stat.close();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }
}

