/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.draw;

import com.modnut.framework2.draw.DrawCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class DrawPix
extends DrawCanvas {
    public static final String SUPPORT_CHARS = "abcdefghijklmnopqrstuvwxyz1234567890 `~!@#$%^&*()_+-={}|[]\\:\";'&lt;&gt;?,./";

    public DrawPix(BufferedImage image) {
        super(image);
    }

    public DrawPix(int width, int height) {
        super(width, height);
    }

    public DrawPix(int width, int height, int type) {
        super(width, height, type);
    }

    private void drawPixs(Graphics g, boolean[][] data, int x, int y, int width, int height) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (!data[i][j]) continue;
                int dx = x + j * width;
                int dy = y + i * height;
                g.fillRect(dx, dy, width, height);
            }
        }
    }

    private void drawPixs(Graphics g, Color[][] data, int x, int y, int width, int height) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j] == null) continue;
                int dx = x + j * width;
                int dy = y + i * height;
                g.setColor(data[i][j]);
                g.fillRect(dx, dy, width, height);
            }
        }
    }

    public void drawPixs(boolean[][] data, int x, int y) {
        this.drawPixs(data, x, y, 1, 1);
    }

    public void drawPixs(boolean[][] data, int x, int y, int size) {
        this.drawPixs(data, x, y, size, size);
    }

    public void drawPixs(boolean[][] data, int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setColor(this.getColor());
        this.drawPixs(g, data, x, y, width, height);
        g.dispose();
    }

    public void drawPixs(Color[][] data, int x, int y) {
        this.drawPixs(data, x, y, 1, 1);
    }

    public void drawPixs(Color[][] data, int x, int y, int size) {
        this.drawPixs(data, x, y, size, size);
    }

    public void drawPixs(Color[][] data, int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        this.drawPixs(g, data, x, y, width, height);
        g.dispose();
    }

    public void drawPixChar(char ch, int x, int y) {
        this.drawPixChar(ch, x, y, 1, 1);
    }

    public void drawPixChar(char ch, int x, int y, int size) {
        this.drawPixChar(ch, x, y, size, size);
    }

    public void drawPixChar(char ch, int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        this.drawPixs(g, CHAR.getData(ch), x, y, width, height);
        g.dispose();
    }

    public void drawPixStr(String str, int x, int y) {
        this.drawPixStr(str, x, y, 1, 1);
    }

    public void drawPixStr(String str, int x, int y, int size) {
        this.drawPixStr(str, x, y, size, size);
    }

    public void drawPixStr(String str, int x, int y, int width, int height) {
        int row = 0;
        int col = 0;
        Graphics g = this.getGraphics();
        for (int k = 0; k < str.length(); ++k) {
            char ch = str.charAt(k);
            if (ch == '\n') {
                col = 0;
                ++row;
                continue;
            }
            this.drawPixs(g, CHAR.getData(ch), x + col * width * 6, y + row * height * 6, width, height);
            ++col;
        }
        g.dispose();
    }

    public static class CHAR {
        private static final boolean XX = true;
        private static final boolean __ = false;
        public static final boolean[][] A = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, true, true, true, true}, {true, false, false, false, true}};
        public static final boolean[][] B = new boolean[][]{{true, true, true, true, false}, {true, false, false, false, true}, {true, true, true, true, false}, {true, false, false, false, true}, {true, true, true, true, false}};
        public static final boolean[][] C = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, false}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] D = new boolean[][]{{true, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, false, true}, {true, true, true, true, false}};
        public static final boolean[][] E = new boolean[][]{{true, true, true, true, true}, {true, false, false, false, false}, {true, true, true, true, false}, {true, false, false, false, false}, {true, true, true, true, true}};
        public static final boolean[][] F = new boolean[][]{{true, true, true, true, true}, {true, false, false, false, false}, {true, true, true, true, false}, {true, false, false, false, false}, {true, false, false, false, false}};
        public static final boolean[][] G = new boolean[][]{{false, true, true, true, true}, {true, false, false, false, false}, {true, false, true, true, true}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] H = new boolean[][]{{true, false, false, false, true}, {true, false, false, false, true}, {true, true, true, true, true}, {true, false, false, false, true}, {true, false, false, false, true}};
        public static final boolean[][] I = new boolean[][]{{false, true, true, true, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, true, true, true, false}};
        public static final boolean[][] J = new boolean[][]{{false, false, false, false, true}, {false, false, false, false, true}, {false, false, false, false, true}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] K = new boolean[][]{{true, false, false, false, true}, {true, false, false, true, false}, {true, true, true, false, false}, {true, false, false, true, false}, {true, false, false, false, true}};
        public static final boolean[][] L = new boolean[][]{{true, false, false, false, false}, {true, false, false, false, false}, {true, false, false, false, false}, {true, false, false, false, false}, {true, true, true, true, true}};
        public static final boolean[][] M = new boolean[][]{{true, false, false, false, true}, {true, true, false, true, true}, {true, false, true, false, true}, {true, false, false, false, true}, {true, false, false, false, true}};
        public static final boolean[][] N = new boolean[][]{{true, false, false, false, true}, {true, true, false, false, true}, {true, false, true, false, true}, {true, false, false, true, true}, {true, false, false, false, true}};
        public static final boolean[][] O = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] P = new boolean[][]{{true, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, true, true, true, false}, {true, false, false, false, false}};
        public static final boolean[][] Q = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, true, true}, {false, true, true, true, true}};
        public static final boolean[][] R = new boolean[][]{{true, true, true, true, false}, {true, false, false, false, true}, {true, false, false, false, true}, {true, true, true, true, false}, {true, false, false, false, true}};
        public static final boolean[][] S = new boolean[][]{{false, true, true, true, true}, {true, false, false, false, false}, {false, true, true, true, false}, {false, false, false, false, true}, {true, true, true, true, false}};
        public static final boolean[][] T = new boolean[][]{{true, true, true, true, true}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] U = new boolean[][]{{true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] V = new boolean[][]{{true, false, false, false, true}, {true, false, false, false, true}, {false, true, false, true, false}, {false, true, false, true, false}, {false, false, true, false, false}};
        public static final boolean[][] W = new boolean[][]{{true, false, false, false, true}, {true, false, false, false, true}, {true, false, false, false, true}, {true, false, true, false, true}, {false, true, false, true, false}};
        public static final boolean[][] X = new boolean[][]{{true, false, false, false, true}, {false, true, false, true, false}, {false, false, true, false, false}, {false, true, false, true, false}, {true, false, false, false, true}};
        public static final boolean[][] Y = new boolean[][]{{true, false, false, false, true}, {false, true, false, true, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] Z = new boolean[][]{{true, true, true, true, true}, {false, false, false, true, false}, {false, false, true, false, false}, {false, true, false, false, false}, {true, true, true, true, true}};
        public static final boolean[][] NUM_0 = new boolean[][]{{false, true, true, true, false}, {true, false, false, true, true}, {true, false, true, false, true}, {true, true, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] NUM_1 = new boolean[][]{{false, false, true, false, false}, {false, true, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {true, true, true, true, true}};
        public static final boolean[][] NUM_2 = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, false, true, true, false}, {false, true, false, false, false}, {true, true, true, true, true}};
        public static final boolean[][] NUM_3 = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, false, true, true, false}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] NUM_4 = new boolean[][]{{false, false, true, true, false}, {false, true, false, true, false}, {true, false, false, true, false}, {true, true, true, true, true}, {false, false, false, true, false}};
        public static final boolean[][] NUM_5 = new boolean[][]{{true, true, true, true, true}, {true, false, false, false, false}, {true, true, true, true, false}, {false, false, false, false, true}, {true, true, true, true, false}};
        public static final boolean[][] NUM_6 = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, false}, {true, true, true, true, false}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] NUM_7 = new boolean[][]{{true, true, true, true, true}, {false, false, false, false, true}, {false, false, false, true, false}, {false, false, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] NUM_8 = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, true, true, true, false}, {true, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] NUM_9 = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, true, true, true, true}, {false, false, false, false, true}, {false, true, true, true, false}};
        public static final boolean[][] SPACE = new boolean[][]{{false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] BACKTICK = new boolean[][]{{false, true, false, false, false}, {false, false, true, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] TILDE = new boolean[][]{{false, false, false, false, false}, {false, true, false, false, false}, {true, false, true, false, true}, {false, false, false, true, false}, {false, false, false, false, false}};
        public static final boolean[][] EXCLAM = new boolean[][]{{false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, false, false, false}, {false, false, true, false, false}};
        public static final boolean[][] AT = new boolean[][]{{false, true, true, true, false}, {true, true, true, false, true}, {true, true, true, false, true}, {true, false, false, true, true}, {false, true, true, true, false}};
        public static final boolean[][] NUMBERSIGN = new boolean[][]{{false, true, false, true, false}, {true, true, true, true, true}, {false, true, false, true, false}, {true, true, true, true, true}, {false, true, false, true, false}};
        public static final boolean[][] DOLLAR = new boolean[][]{{false, true, true, true, true}, {true, false, true, false, false}, {false, true, true, true, false}, {false, false, true, false, true}, {true, true, true, true, false}};
        public static final boolean[][] PERCENT = new boolean[][]{{true, true, false, false, true}, {true, true, false, true, false}, {false, false, true, false, false}, {false, true, false, true, true}, {true, false, false, true, true}};
        public static final boolean[][] CARET = new boolean[][]{{false, false, true, false, false}, {false, true, false, true, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] AMPERSAND = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, true, true, true, false}, {true, false, false, true, false}, {false, true, true, true, true}};
        public static final boolean[][] ASTERISK = new boolean[][]{{false, false, true, false, false}, {true, false, true, false, true}, {false, true, true, true, false}, {true, false, true, false, true}, {false, false, true, false, false}};
        public static final boolean[][] RBRACKET_1 = new boolean[][]{{false, false, true, false, false}, {false, true, false, false, false}, {false, true, false, false, false}, {false, true, false, false, false}, {false, false, true, false, false}};
        public static final boolean[][] RBRACKET_2 = new boolean[][]{{false, false, true, false, false}, {false, false, false, true, false}, {false, false, false, true, false}, {false, false, false, true, false}, {false, false, true, false, false}};
        public static final boolean[][] UNDERSCORE = new boolean[][]{{false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {true, true, true, true, true}};
        public static final boolean[][] PLUS = new boolean[][]{{false, false, true, false, false}, {false, false, true, false, false}, {true, true, true, true, true}, {false, false, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] MINUS = new boolean[][]{{false, false, false, false, false}, {false, false, false, false, false}, {true, true, true, true, true}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] EQUAL = new boolean[][]{{false, false, false, false, false}, {true, true, true, true, true}, {false, false, false, false, false}, {true, true, true, true, true}, {false, false, false, false, false}};
        public static final boolean[][] CBRACKET_1 = new boolean[][]{{false, true, true, false, false}, {false, true, false, false, false}, {true, true, false, false, false}, {false, true, false, false, false}, {false, true, true, false, false}};
        public static final boolean[][] CBRACKET_2 = new boolean[][]{{false, false, true, true, false}, {false, false, false, true, false}, {false, false, false, true, true}, {false, false, false, true, false}, {false, false, true, true, false}};
        public static final boolean[][] BAR = new boolean[][]{{false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] SBRACKET_1 = new boolean[][]{{false, true, true, false, false}, {false, true, false, false, false}, {false, true, false, false, false}, {false, true, false, false, false}, {false, true, true, false, false}};
        public static final boolean[][] SBRACKET_2 = new boolean[][]{{false, false, true, true, false}, {false, false, false, true, false}, {false, false, false, true, false}, {false, false, false, true, false}, {false, false, true, true, false}};
        public static final boolean[][] BACKSLASH = new boolean[][]{{true, false, false, false, false}, {false, true, false, false, false}, {false, false, true, false, false}, {false, false, false, true, false}, {false, false, false, false, true}};
        public static final boolean[][] COLON = new boolean[][]{{false, true, true, false, false}, {false, true, true, false, false}, {false, false, false, false, false}, {false, true, true, false, false}, {false, true, true, false, false}};
        public static final boolean[][] DQUOTE = new boolean[][]{{false, true, false, true, false}, {false, true, false, true, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] SEMICOLON = new boolean[][]{{false, true, true, false, false}, {false, true, true, false, false}, {false, false, false, false, false}, {false, true, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] SQUOTE = new boolean[][]{{false, false, true, false, false}, {false, false, true, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
        public static final boolean[][] ABRACKET_1 = new boolean[][]{{false, false, false, true, false}, {false, false, true, false, false}, {false, true, false, false, false}, {false, false, true, false, false}, {false, false, false, true, false}};
        public static final boolean[][] ABRACKET_2 = new boolean[][]{{false, true, false, false, false}, {false, false, true, false, false}, {false, false, false, true, false}, {false, false, true, false, false}, {false, true, false, false, false}};
        public static final boolean[][] QUESTION = new boolean[][]{{false, true, true, true, false}, {true, false, false, false, true}, {false, false, true, true, false}, {false, false, false, false, false}, {false, false, true, false, false}};
        public static final boolean[][] COMMA = new boolean[][]{{false, false, false, false, false}, {false, false, false, false, false}, {false, true, true, false, false}, {false, true, true, false, false}, {false, false, true, false, false}};
        public static final boolean[][] PERIOD = new boolean[][]{{false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, true, true, false, false}, {false, true, true, false, false}};
        public static final boolean[][] SLASH = new boolean[][]{{false, false, false, false, true}, {false, false, false, true, false}, {false, false, true, false, false}, {false, true, false, false, false}, {true, false, false, false, false}};

        public static boolean[][] getData(char ch) {
            switch (ch) {
                case 'A': 
                case 'a': {
                    return A;
                }
                case 'B': 
                case 'b': {
                    return B;
                }
                case 'C': 
                case 'c': {
                    return C;
                }
                case 'D': 
                case 'd': {
                    return D;
                }
                case 'E': 
                case 'e': {
                    return E;
                }
                case 'F': 
                case 'f': {
                    return F;
                }
                case 'G': 
                case 'g': {
                    return G;
                }
                case 'H': 
                case 'h': {
                    return H;
                }
                case 'I': 
                case 'i': {
                    return I;
                }
                case 'J': 
                case 'j': {
                    return J;
                }
                case 'K': 
                case 'k': {
                    return K;
                }
                case 'L': 
                case 'l': {
                    return L;
                }
                case 'M': 
                case 'm': {
                    return M;
                }
                case 'N': 
                case 'n': {
                    return N;
                }
                case 'O': 
                case 'o': {
                    return O;
                }
                case 'P': 
                case 'p': {
                    return P;
                }
                case 'Q': 
                case 'q': {
                    return Q;
                }
                case 'R': 
                case 'r': {
                    return R;
                }
                case 'S': 
                case 's': {
                    return S;
                }
                case 'T': 
                case 't': {
                    return T;
                }
                case 'U': 
                case 'u': {
                    return U;
                }
                case 'V': 
                case 'v': {
                    return V;
                }
                case 'W': 
                case 'w': {
                    return W;
                }
                case 'X': 
                case 'x': {
                    return X;
                }
                case 'Y': 
                case 'y': {
                    return Y;
                }
                case 'Z': 
                case 'z': {
                    return Z;
                }
                case '0': {
                    return NUM_0;
                }
                case '1': {
                    return NUM_1;
                }
                case '2': {
                    return NUM_2;
                }
                case '3': {
                    return NUM_3;
                }
                case '4': {
                    return NUM_4;
                }
                case '5': {
                    return NUM_5;
                }
                case '6': {
                    return NUM_6;
                }
                case '7': {
                    return NUM_7;
                }
                case '8': {
                    return NUM_8;
                }
                case '9': {
                    return NUM_9;
                }
                case ' ': {
                    return SPACE;
                }
                case '`': {
                    return BACKTICK;
                }
                case '~': {
                    return TILDE;
                }
                case '!': {
                    return EXCLAM;
                }
                case '@': {
                    return AT;
                }
                case '#': {
                    return NUMBERSIGN;
                }
                case '$': {
                    return DOLLAR;
                }
                case '%': {
                    return PERCENT;
                }
                case '^': {
                    return CARET;
                }
                case '&': {
                    return AMPERSAND;
                }
                case '*': {
                    return ASTERISK;
                }
                case '(': {
                    return RBRACKET_1;
                }
                case ')': {
                    return RBRACKET_2;
                }
                case '_': {
                    return UNDERSCORE;
                }
                case '+': {
                    return PLUS;
                }
                case '-': {
                    return MINUS;
                }
                case '=': {
                    return EQUAL;
                }
                case '{': {
                    return CBRACKET_1;
                }
                case '}': {
                    return CBRACKET_2;
                }
                case '|': {
                    return BAR;
                }
                case '[': {
                    return SBRACKET_1;
                }
                case ']': {
                    return SBRACKET_2;
                }
                case '\\': {
                    return BACKSLASH;
                }
                case ':': {
                    return COLON;
                }
                case '\"': {
                    return DQUOTE;
                }
                case ';': {
                    return SEMICOLON;
                }
                case '\'': {
                    return SQUOTE;
                }
                case '<': {
                    return ABRACKET_1;
                }
                case '>': {
                    return ABRACKET_2;
                }
                case '?': {
                    return QUESTION;
                }
                case ',': {
                    return COMMA;
                }
                case '.': {
                    return PERIOD;
                }
                case '/': {
                    return SLASH;
                }
            }
            return SPACE;
        }
    }
}

