/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public abstract class DrawPrinter {
    public double pageWidth = -1.0;
    public double pageHeight = -1.0;
    public double innerLeft = -1.0;
    public double innerTop = -1.0;
    public double innerWidth = -1.0;
    public double innerHeight = -1.0;
    private String printerName;

    public DrawPrinter(String printerName) {
        this.printerName = printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public void loadPrinterDefault() throws PrinterException {
        PrintService ps = DrawPrinter.getPrintService(this.printerName);
        if (ps == null) {
            throw new PrinterException("\u6253\u5370\u673a\u4e0d\u5b58\u5728");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(ps);
        PageFormat pageFormat = printerJob.defaultPage();
        this.pageWidth = pageFormat.getWidth();
        this.pageHeight = pageFormat.getHeight();
        this.innerLeft = pageFormat.getImageableX();
        this.innerTop = pageFormat.getImageableY();
        this.innerWidth = pageFormat.getImageableWidth();
        this.innerHeight = pageFormat.getImageableHeight();
    }

    public void doPrint() throws PrinterException {
        PrintService ps = DrawPrinter.getPrintService(this.printerName);
        if (ps == null) {
            throw new PrinterException("\u6253\u5370\u673a\u4e0d\u5b58\u5728");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(ps);
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        paper.setSize(this.pageWidth, this.pageHeight);
        paper.setImageableArea(this.innerLeft, this.innerTop, this.innerWidth, this.innerHeight);
        pageFormat.setPaper(paper);
        printerJob.setPrintable(new InnerPrint(), pageFormat);
        printerJob.print();
    }

    public ArrayList<BufferedImage> doPreview() {
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(this.pageWidth, this.pageHeight);
        paper.setImageableArea(this.innerLeft, this.innerTop, this.innerWidth, this.innerHeight);
        pageFormat.setPaper(paper);
        ArrayList<BufferedImage> imgs = new ArrayList<BufferedImage>();
        boolean end = false;
        while (!end) {
            BufferedImage img = new BufferedImage((int)this.pageWidth, (int)this.pageHeight, 1);
            Graphics g = img.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
            end = this.draw(g, pageFormat, imgs.size());
            g.dispose();
            if (end) continue;
            imgs.add(img);
        }
        return imgs;
    }

    protected abstract boolean draw(Graphics var1, PageFormat var2, int var3);

    public static PrintService getPrintService(String name) {
        PrintService[] pss = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService get = null;
        name = name == null ? "" : name;
        for (PrintService ps : pss) {
            if (!name.equals(ps.getName())) continue;
            get = ps;
            break;
        }
        return get;
    }

    public static String[] getPrinterNames() {
        PrintService[] pss = PrintServiceLookup.lookupPrintServices(null, null);
        String[] printerList = new String[pss.length];
        for (int i = 0; i < pss.length; ++i) {
            printerList[i] = pss[i].getName();
        }
        return printerList;
    }

    private class InnerPrint
    implements Printable {
        private InnerPrint() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            return DrawPrinter.this.draw(graphics, pageFormat, pageIndex) ? 1 : 0;
        }
    }
}

