/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncIO {
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final LinkedList<String> inputs = new LinkedList();
    private final LinkedList<String> outputs = new LinkedList();
    private final Thread r = new Thread((Runnable)new Read(), "AsyncIO Read");
    private final Thread w = new Thread((Runnable)new Write(), "AsyncIO Write");
    private static AsyncIO i = null;

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.r.start();
            this.w.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            this.r.interrupt();
            this.w.interrupt();
            LinkedList<String> linkedList = this.inputs;
            synchronized (linkedList) {
                this.inputs.notifyAll();
            }
            linkedList = this.outputs;
            synchronized (linkedList) {
                this.outputs.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String msg) {
        if (msg != null) {
            this.syncWrite(msg);
        }
        if (this.running.compareAndSet(true, false)) {
            this.r.interrupt();
            this.w.interrupt();
            LinkedList<String> linkedList = this.inputs;
            synchronized (linkedList) {
                this.inputs.notifyAll();
            }
            linkedList = this.outputs;
            synchronized (linkedList) {
                this.outputs.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asyncRead(long timeout) {
        if (this.running.get()) {
            String line;
            LinkedList<String> linkedList = this.inputs;
            synchronized (linkedList) {
                line = this.inputs.poll();
            }
            if (line == null) {
                linkedList = this.inputs;
                synchronized (linkedList) {
                    try {
                        if (timeout > 0L) {
                            this.inputs.wait(timeout);
                        } else {
                            this.inputs.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(AsyncIO.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    line = this.inputs.poll();
                }
            }
            return line;
        }
        return null;
    }

    public void asyncWrite(String ... msg) {
        for (String line : msg) {
            this.asyncWrite(line, false);
        }
        if (msg.length == 0) {
            this.asyncWrite("", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncWrite(String msg, boolean noBreak) {
        if (this.running.get()) {
            String str = msg;
            if (!noBreak) {
                str = str + "\n";
            }
            LinkedList<String> linkedList = this.outputs;
            synchronized (linkedList) {
                this.outputs.add(str);
                this.outputs.notifyAll();
            }
        }
    }

    public void syncWrite(String ... msg) {
        for (String line : msg) {
            this.syncWrite(line, false);
        }
    }

    public void syncWrite(String msg, boolean noBreak) {
        if (this.running.get()) {
            String str = msg;
            if (!noBreak) {
                str = str + "\n";
            }
            try {
                this.writer.write(str, 0, str.length());
                this.writer.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void init() {
        AsyncIO.dispose();
        i = new AsyncIO();
        i.start();
    }

    public static void dispose() {
        if (i != null) {
            i.shutdown();
        }
    }

    public static void dispose(String msg) {
        if (i != null) {
            i.shutdown(msg);
        }
    }

    public static String read(long wait) {
        String line = null;
        if (i != null) {
            line = i.asyncRead(wait);
        }
        return line;
    }

    public static String read(long wait, boolean trim) {
        String str = AsyncIO.read(wait);
        if (str != null) {
            if (trim) {
                str = str.trim();
            }
            if (str.isEmpty()) {
                str = null;
            }
        }
        return str;
    }

    public static String read(long wait, String tip) {
        AsyncIO.echo(tip, true);
        return AsyncIO.read(wait);
    }

    public static String read(long wait, boolean trim, String tip) {
        AsyncIO.echo(tip, true);
        return AsyncIO.read(wait, trim);
    }

    public static String read() {
        return AsyncIO.read(0L);
    }

    public static String read(boolean trim) {
        return AsyncIO.read(0L, trim);
    }

    public static String read(String tip) {
        AsyncIO.echo(tip, true);
        return AsyncIO.read();
    }

    public static String read(boolean trim, String tip) {
        AsyncIO.echo(tip, true);
        return AsyncIO.read(trim);
    }

    public static void echo(String ... msg) {
        if (i != null) {
            i.syncWrite(msg);
        }
    }

    public static void echo(String msg, boolean noBreak) {
        if (i != null) {
            i.syncWrite(msg, noBreak);
        }
    }

    public static void echox(String ... msg) {
        if (i != null) {
            i.asyncWrite(msg);
        }
    }

    public static void echox(String msg, boolean noBreak) {
        if (i != null) {
            i.asyncWrite(msg, noBreak);
        }
    }

    private class Write
    implements Runnable {
        private Write() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (AsyncIO.this.running.get()) {
                    String str;
                    LinkedList linkedList = AsyncIO.this.outputs;
                    synchronized (linkedList) {
                        str = (String)AsyncIO.this.outputs.poll();
                    }
                    if (str != null) {
                        AsyncIO.this.writer.write(str, 0, str.length());
                        AsyncIO.this.writer.flush();
                        continue;
                    }
                    try {
                        linkedList = AsyncIO.this.outputs;
                        synchronized (linkedList) {
                            AsyncIO.this.outputs.wait(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                AsyncIO.this.writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class Read
    implements Runnable {
        private Read() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                while (AsyncIO.this.running.get() && (line = AsyncIO.this.reader.readLine()) != null) {
                    LinkedList linkedList = AsyncIO.this.inputs;
                    synchronized (linkedList) {
                        AsyncIO.this.inputs.add(line);
                        AsyncIO.this.inputs.notifyAll();
                    }
                }
                AsyncIO.this.reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

