/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DomParser {
    private static final String[] SPECIAL_TAG = new String[]{"style", "script"};
    private static final String[] SINGLE_TAG = new String[]{"br", "hr", "img", "input", "param", "meta", "link", "area"};
    private static final String DEFAULT_SPACE = "  ";
    private static final String DEFAULT_LINE = "\n";
    public Node document;

    private DomParser(Node document) {
        this.document = document;
    }

    public String toString() {
        return this.document.toString();
    }

    public static NodeElement createElement(String name) {
        return new NodeElement(name);
    }

    public static DomParser create() {
        return new DomParser(new Node());
    }

    public static DomParser create(Node document) {
        return new DomParser(document);
    }

    public static DomParser create(String document) {
        return new DomParser(DomParser.build(document, false));
    }

    public static DomParser create(String document, boolean xmlmode) {
        return new DomParser(DomParser.build(document, xmlmode));
    }

    public static DomParser create(File file) throws IOException {
        return DomParser.create(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomParser create(File file, String encode) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = encode == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encode));
        try {
            int read;
            char[] buff = new char[1024];
            while ((read = reader.read(buff)) != -1) {
                sb.append(buff, 0, read);
            }
        }
        finally {
            reader.close();
        }
        return DomParser.create(sb.toString());
    }

    private static Node build(String document, boolean xmlmode) {
        Node root = new Node();
        DomParser.build(root, document, 0, document.length(), xmlmode);
        return root;
    }

    private static void build(Node context, String source, int start, int end, boolean xmlmode) {
        int index = start;
        while (index < end) {
            String name;
            int nameEnd;
            int tagStartIndex = source.indexOf(60, index);
            if (tagStartIndex < 0 || tagStartIndex >= end) {
                String text = source.substring(index, end);
                context.addChild(new NodeText(text));
                break;
            }
            if (tagStartIndex > index) {
                String text = source.substring(index, tagStartIndex);
                context.addChild(new NodeText(text));
            }
            if (tagStartIndex + 1 >= end) break;
            char firstChar = source.charAt(tagStartIndex + 1);
            if (firstChar == '?') {
                nameEnd = DomParser.searchWordEnd(source, tagStartIndex + 2, end);
                if (nameEnd < 0 || nameEnd >= end) break;
                name = source.substring(tagStartIndex + 2, nameEnd);
                int tagEndIndex = DomParser.searchMatchStr(source, nameEnd, end, "?>", !xmlmode, true, true);
                if (tagEndIndex < 0 || tagEndIndex >= end) break;
                String content = source.substring(nameEnd, tagEndIndex);
                context.addChild(new NodeDec(name, content));
                index = tagEndIndex + 2;
                continue;
            }
            if (firstChar == '!') {
                if (tagStartIndex + 3 < end && source.charAt(tagStartIndex + 2) == '-' && source.charAt(tagStartIndex + 3) == '-') {
                    int commentEndIndex = source.indexOf("-->", tagStartIndex + 4);
                    if (commentEndIndex < 0 || commentEndIndex >= end) break;
                    String comment = source.substring(tagStartIndex + 4, commentEndIndex);
                    context.addChild(new NodeComment(comment));
                    index = commentEndIndex + 3;
                    continue;
                }
                if (tagStartIndex + 8 < end && source.startsWith("[CDATA[", tagStartIndex + 2)) {
                    int cdataEndIndex = source.indexOf("]]>", tagStartIndex + 9);
                    if (cdataEndIndex < 0 || cdataEndIndex >= end) break;
                    String cdata = source.substring(tagStartIndex + 9, cdataEndIndex);
                    context.addChild(new NodeCDATA(cdata));
                    index = cdataEndIndex + 3;
                    continue;
                }
                nameEnd = DomParser.searchWordEnd(source, tagStartIndex + 2, end);
                if (nameEnd < 0 || nameEnd >= end) break;
                name = source.substring(tagStartIndex + 2, nameEnd);
                int tagEndIndex = DomParser.searchMatchChar(source, nameEnd, end, '>', !xmlmode, true, true);
                if (tagEndIndex < 0 || tagEndIndex >= end) break;
                String content = source.substring(nameEnd, tagEndIndex);
                context.addChild(new NodeDef(name, content));
                index = tagEndIndex + 1;
                continue;
            }
            if (firstChar == '/') {
                int tagEndIndex = DomParser.searchMatchChar(source, tagStartIndex + 2, end, '>', !xmlmode, false, true);
                if (tagEndIndex < 0 || tagEndIndex >= end) break;
                name = source.substring(tagStartIndex + 2, tagEndIndex).trim();
                if (context instanceof NodeElement) {
                    NodeElement elmNode = (NodeElement)context;
                    if (!elmNode.closed && DomParser.strEqual(name, elmNode.name, !xmlmode) && context.parent != null) {
                        context = context.parent;
                    }
                }
                index = tagEndIndex + 1;
                continue;
            }
            nameEnd = DomParser.searchWordEnd(source, tagStartIndex + 1, end);
            if (nameEnd < 0 || nameEnd >= end) break;
            name = source.substring(tagStartIndex + 1, nameEnd);
            int tagEndIndex = source.indexOf(62, nameEnd);
            if (tagEndIndex < 0 || tagEndIndex >= end) break;
            int closeSymbolIndex = DomParser.searchMatchChar(source, nameEnd, tagEndIndex, '/', !xmlmode, false, true);
            boolean selfClose = closeSymbolIndex >= 0 && closeSymbolIndex < tagEndIndex;
            int n = closeSymbolIndex = closeSymbolIndex < 0 ? tagEndIndex : closeSymbolIndex;
            if (DomParser.singleTag(name, xmlmode) >= 0) {
                selfClose = true;
            }
            ArrayList<Attribute> attrs = DomParser.buildAttrs(source, nameEnd, selfClose ? closeSymbolIndex : tagEndIndex);
            int specialIndex = DomParser.specialTag(name, xmlmode);
            if (specialIndex >= 0) {
                if (!selfClose) {
                    int closeTagEndIndex;
                    int specialSearchIndex;
                    int contentStartIndex = specialSearchIndex = tagEndIndex + 1;
                    int contentEndIndex = end;
                    boolean find = false;
                    while (specialSearchIndex < end && !find && (contentEndIndex = DomParser.searchMatchStr(source, specialSearchIndex, end, "</", !xmlmode, false, true)) >= 0 && contentEndIndex < end && (closeTagEndIndex = DomParser.searchMatchChar(source, contentEndIndex + 2, end, '>', !xmlmode, false, true)) >= 0 && closeTagEndIndex < end) {
                        String closeTagName = source.substring(contentEndIndex + 2, closeTagEndIndex);
                        if (DomParser.strEqual(name, closeTagName.trim(), !xmlmode)) {
                            find = true;
                        }
                        specialSearchIndex = closeTagEndIndex + 1;
                    }
                    if (!find) break;
                    String content = source.substring(contentStartIndex, contentEndIndex);
                    NodeSpecial speNode = new NodeSpecial(name, attrs, content);
                    context.addChild(speNode);
                    index = specialSearchIndex;
                    continue;
                }
                NodeSpecial speNode = new NodeSpecial(name, attrs, null);
                context.addChild(speNode);
                index = tagEndIndex + 1;
                continue;
            }
            NodeElement elmNode = new NodeElement(name, attrs, selfClose);
            context.addChild(elmNode);
            if (!selfClose) {
                context = elmNode;
            }
            index = tagEndIndex + 1;
        }
    }

    private static int specialTag(String name, boolean xmlmode) {
        if (xmlmode) {
            return -1;
        }
        name = name.toLowerCase();
        for (int i = 0; i < SPECIAL_TAG.length; ++i) {
            if (!SPECIAL_TAG[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static int singleTag(String name, boolean xmlmode) {
        if (xmlmode) {
            return -1;
        }
        name = name.toLowerCase();
        for (int i = 0; i < SINGLE_TAG.length; ++i) {
            if (!SINGLE_TAG[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static ArrayList<Attribute> buildAttrs(String source, int start, int end) {
        int indexEnd;
        int indexStart;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        int index = start;
        while (index < end && (indexStart = DomParser.searchNextChar(source, index, end)) >= 0 && (indexEnd = DomParser.searchWordEnd(source, indexStart, end)) < end) {
            String attrValue;
            String attrName = source.substring(indexStart, indexEnd);
            if (attrName.isEmpty()) {
                index = indexStart + 1;
                continue;
            }
            indexStart = DomParser.searchNextChar(source, indexEnd, end);
            if (indexStart < 0) {
                attrs.add(new Attribute(attrName, null));
                break;
            }
            char ch = source.charAt(indexStart);
            if (ch != '=') {
                attrs.add(new Attribute(attrName, null));
                index = indexStart;
                continue;
            }
            if ((indexStart = DomParser.searchNextChar(source, indexStart + 1, end)) < 0) {
                attrs.add(new Attribute(attrName, null));
                break;
            }
            ch = source.charAt(indexStart);
            if (ch == '\'' || ch == '\"') {
                if ((indexEnd = source.indexOf(ch, ++indexStart)) >= 0 && indexEnd < end) {
                    attrValue = source.substring(indexStart, indexEnd);
                    attrs.add(new Attribute(attrName, attrValue, ch));
                    index = indexEnd + 1;
                    continue;
                }
                attrValue = source.substring(indexStart, end);
                attrs.add(new Attribute(attrName, attrValue, ch));
                break;
            }
            for (indexEnd = indexStart; indexEnd < end && (ch = source.charAt(indexEnd)) != ' ' && ch != '>'; ++indexEnd) {
            }
            if (indexEnd < end) {
                attrValue = source.substring(indexStart, indexEnd);
                attrs.add(new Attribute(attrName, attrValue, '\u0000'));
                index = indexEnd;
                continue;
            }
            attrValue = source.substring(indexStart, end);
            attrs.add(new Attribute(attrName, attrValue, '\u0000'));
            break;
        }
        return attrs;
    }

    private static int searchNextChar(String source, int start, int end) {
        if (start >= 0) {
            for (int i = start; i < source.length() && i < end; ++i) {
                char ch = source.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
                return i;
            }
        }
        return -1;
    }

    private static int searchWordEnd(String source, int start, int end) {
        if (start >= 0) {
            for (int i = start; i < source.length() && i < end; ++i) {
                if (DomParser.isWordChar(source.charAt(i))) continue;
                return i;
            }
        }
        return end;
    }

    private static int searchMatchStr(String source, int start, int end, String searchStr, boolean ignoreCase, boolean hasStack, boolean quoteEscape) {
        if (source == null || "".equals(source)) {
            return -1;
        }
        int newEndIndex = end - searchStr.length() + 1;
        char[] chs = searchStr.toCharArray();
        int index = DomParser.searchMatchChar(source, start, newEndIndex, chs[0], ignoreCase, hasStack, quoteEscape);
        while (index >= 0) {
            boolean match = true;
            for (int i = 1; i < chs.length; ++i) {
                if (DomParser.chEqual(chs[i], source.charAt(index + i), ignoreCase)) continue;
                match = false;
                break;
            }
            if (match) {
                return index;
            }
            index = DomParser.searchMatchChar(source, index + 1, newEndIndex, chs[0], ignoreCase, hasStack, quoteEscape);
        }
        return index;
    }

    private static int searchMatchChar(String source, int start, int end, char searchCh, boolean ignoreCase, boolean hasStack, boolean quoteEscape) {
        ArrayList<Character> stack = null;
        if (hasStack) {
            stack = new ArrayList<Character>();
        }
        int index = start;
        while (index < end) {
            char ch = source.charAt(index);
            if (DomParser.chEqual(searchCh, ch, ignoreCase)) {
                if (hasStack) {
                    if (stack.isEmpty()) {
                        return index;
                    }
                } else {
                    return index;
                }
            }
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '=' || ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '_' || ch == '-' || ch == ':' || ch == '.') {
                ++index;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                int match = source.indexOf(ch, index + 1);
                if (quoteEscape) {
                    while (match > 0 && source.charAt(match - 1) == '\\') {
                        match = source.indexOf(ch, match + 1);
                    }
                }
                if (match < 0 || match >= end) break;
                index = match + 1;
                continue;
            }
            if (hasStack) {
                if (ch == '<' || ch == '(' || ch == '[' || ch == '{') {
                    stack.add(Character.valueOf(ch));
                    ++index;
                    continue;
                }
                if (ch == '>' || ch == ')' || ch == ']' || ch == '}') {
                    int size = stack.size();
                    if (stack.isEmpty()) break;
                    char stackCh = ((Character)stack.get(size - 1)).charValue();
                    boolean match = false;
                    if (!match && stackCh == '<' && ch == '>') {
                        match = true;
                    }
                    if (!match && stackCh == '(' && ch == ')') {
                        match = true;
                    }
                    if (!match && stackCh == '[' && ch == ']') {
                        match = true;
                    }
                    if (!match && stackCh == '{' && ch == '}') {
                        match = true;
                    }
                    if (!match) break;
                    stack.remove(size - 1);
                    ++index;
                    continue;
                }
            }
            ++index;
        }
        return -1;
    }

    private static boolean chEqual(char ch1, char ch2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
        }
        return ch1 == ch2;
    }

    private static boolean strEqual(String str1, String str2, boolean ignoreCase) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (ignoreCase) {
            return str1.toLowerCase().equals(str2.toLowerCase());
        }
        return str1.equals(str2);
    }

    private static boolean isWordChar(char ch) {
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == ':' || ch == '.') {
            return true;
        }
        return ch != ' ' && ch != '=' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '<' && ch != '>' && ch != '!' && ch != '>' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '{' && ch != '}' && ch != '\\' && ch != '/';
    }

    public static class Attribute {
        public String name;
        public String value;
        public char quote;
        public static final char NONE_QUOTE = '\u0000';
        public static final char DEFAULT_QUOTE = '\"';

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
            this.quote = (char)34;
        }

        public Attribute(String name, String value, char quote) {
            this.name = name;
            this.value = value;
            this.quote = quote;
        }

        public String toString() {
            if (this.quote == '\u0000') {
                if (this.value == null) {
                    return this.name;
                }
                return this.name + "=" + this.value;
            }
            if (this.value == null) {
                return this.name;
            }
            return this.name + "=" + this.quote + this.value + this.quote;
        }
    }

    public static class NodeSpecial
    extends NodeElement {
        public String content;

        public NodeSpecial(String name, ArrayList<Attribute> attrs, String content) {
            super(name, attrs);
            this.content = content;
            this.closed = content == null;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            StringBuilder sb = new StringBuilder("<");
            sb.append(this.name);
            if (this.attrs != null) {
                for (Attribute attr : this.attrs) {
                    sb.append(" ").append(attr.toString());
                }
            }
            if (this.closed) {
                return sb.append("/>").toString();
            }
            sb.append(">");
            if (this.content != null) {
                sb.append(this.content);
            }
            return sb.append("</").append(this.name).append(">").toString();
        }
    }

    public static class NodeElement
    extends Node {
        public String name;
        public ArrayList<Attribute> attrs;
        public boolean closed;

        public NodeElement(String name) {
            this.name = name;
            this.attrs = null;
            this.closed = false;
        }

        public NodeElement(String name, boolean closed) {
            this.name = name;
            this.attrs = null;
            this.closed = closed;
        }

        public NodeElement(String name, ArrayList<Attribute> attrs) {
            this.name = name;
            this.attrs = attrs;
            this.closed = false;
        }

        public NodeElement(String name, ArrayList<Attribute> attrs, boolean closed) {
            this.name = name;
            this.attrs = attrs;
            this.closed = closed;
        }

        public boolean setAttr(String name, String value) {
            return this.setAttr(name, value, true);
        }

        public boolean setAttr(String name, String value, boolean ignoreCase) {
            Attribute attr;
            if (this.attrs == null) {
                this.attrs = new ArrayList();
            }
            if ((attr = this.getAttr(name, ignoreCase)) != null) {
                attr.value = value;
                return false;
            }
            this.attrs.add(new Attribute(name, value));
            return true;
        }

        public Attribute getAttr(String name) {
            return this.getAttr(name, true);
        }

        public Attribute getAttr(String name, boolean ignoreCase) {
            if (this.attrs != null) {
                for (Attribute attr : this.attrs) {
                    if (!DomParser.strEqual(attr.name, name, ignoreCase)) continue;
                    return attr;
                }
            }
            return null;
        }

        public String getAttrValue(String name) {
            return this.getAttrValue(name, true);
        }

        public String getAttrValue(String name, boolean ignoreCase) {
            Attribute attr = this.getAttr(name, true);
            return attr == null ? null : attr.value;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            boolean addPrefixSuffix;
            StringBuilder sb = new StringBuilder("<");
            sb.append(this.name);
            if (this.attrs != null) {
                for (Attribute attr : this.attrs) {
                    sb.append(" ").append(attr.toString());
                }
            }
            if (this.closed) {
                return sb.append("/>").toString();
            }
            sb.append(">");
            boolean bl = addPrefixSuffix = format && this.children != null && this.children.size() > 0;
            if (addPrefixSuffix) {
                sb.append(line);
            }
            sb.append(super.toString(format, space, line, levelref));
            if (addPrefixSuffix) {
                sb.append(line);
                int level = this.getLevel() + levelref;
                for (int i = 0; i < level; ++i) {
                    sb.append(space);
                }
            }
            return sb.append("</").append(this.name).append(">").toString();
        }
    }

    public static class NodeDef
    extends Node {
        public String name;
        public String content;

        public NodeDef(String name) {
            this.name = name;
            this.content = null;
        }

        public NodeDef(String name, String content) {
            this.name = name;
            this.content = content;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            StringBuilder sb = new StringBuilder("<!");
            sb.append(this.name);
            if (this.content != null) {
                sb.append(this.content);
            }
            return sb.append(">").toString();
        }
    }

    public static class NodeDec
    extends Node {
        public String name;
        public String content;

        public NodeDec() {
            this.name = null;
            this.content = null;
        }

        public NodeDec(String name) {
            this.name = name;
            this.content = null;
        }

        public NodeDec(String name, String content) {
            this.name = name;
            this.content = content;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            StringBuilder sb = new StringBuilder("<?");
            if (this.name != null) {
                sb.append(this.name);
            }
            if (this.content != null) {
                sb.append(this.content);
            }
            return sb.append("?>").toString();
        }
    }

    public static class NodeCDATA
    extends Node {
        public String content;

        public NodeCDATA(String content) {
            this.content = content;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            return "<![CDATA[" + this.content + "]]>";
        }
    }

    public static class NodeComment
    extends Node {
        public String comment;

        public NodeComment(String comment) {
            this.comment = comment;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            return "<!--" + this.comment + "-->";
        }
    }

    public static class NodeText
    extends Node {
        public String text;

        public NodeText(String text) {
            this.text = text;
        }

        @Override
        public String toString(boolean format, String space, String line, int levelref) {
            return this.text;
        }
    }

    public static class Node {
        public Node parent;
        public ArrayList<Node> children;

        public Node getParent() {
            return this.parent;
        }

        public ArrayList<Node> getChildren() {
            return this.children;
        }

        public ArrayList<NodeElement> getChildElements() {
            if (this.children == null) {
                return null;
            }
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = this.children.get(i);
                if (!(node instanceof NodeElement)) continue;
                result.add((NodeElement)node);
            }
            return result;
        }

        public ArrayList<NodeElement> getChildElements(String tagName) {
            if (this.children == null) {
                return null;
            }
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = this.children.get(i);
                if (!(node instanceof NodeElement)) continue;
                NodeElement element = (NodeElement)node;
                if (!element.name.equals(tagName)) continue;
                result.add(element);
            }
            return result;
        }

        public Node getChild(int index) {
            return this.children != null && this.children.size() >= index ? this.children.get(index) : null;
        }

        public NodeElement getChildElement(int index) {
            if (this.children != null) {
                int count = 0;
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!(this.children.get(i) instanceof NodeElement)) continue;
                    if (count == index) {
                        return (NodeElement)this.children.get(i);
                    }
                    ++count;
                }
            }
            return null;
        }

        public int indexOfChild(Node child) {
            if (this.children != null && child != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).equals(child)) continue;
                    return i;
                }
            }
            return -1;
        }

        public int indexOfChildElement(NodeElement child) {
            if (this.children != null && child != null) {
                int index = 0;
                for (int i = 0; i < this.children.size(); ++i) {
                    Node node = this.children.get(i);
                    if (!(node instanceof NodeElement)) continue;
                    if (node.equals(child)) {
                        return index;
                    }
                    ++index;
                }
            }
            return -1;
        }

        public Node setParent(Node newParent) {
            Node oldParent = this.parent;
            if (oldParent != null) {
                oldParent.removeChild(this);
            }
            if (newParent != null) {
                newParent.addChild(this);
            } else {
                this.parent = null;
            }
            return oldParent;
        }

        public Node addChild(Node child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.parent = this;
            this.children.add(child);
            return this;
        }

        public Node addChild(Node child, int index) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.parent = this;
            if (index < 0 || index > this.children.size()) {
                this.children.add(child);
            } else {
                this.children.add(index, child);
            }
            return this;
        }

        public boolean removeChild(Node child) {
            if (this.children != null && child != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!child.equals(this.children.get(i))) continue;
                    this.children.remove(i);
                    return true;
                }
            }
            return false;
        }

        public String inner() {
            if (this.children != null) {
                StringBuilder sb = new StringBuilder();
                for (Node child : this.children) {
                    sb.append(child.toString());
                }
                return sb.toString();
            }
            return "";
        }

        public boolean inner(String document) {
            return this.inner(document, false);
        }

        public boolean inner(String document, boolean xmlmode) {
            Node root = DomParser.build(document, xmlmode);
            if (root.children != null) {
                this.children.clear();
                for (Node child : root.children) {
                    this.addChild(child);
                }
                return true;
            }
            return false;
        }

        public String text() {
            return this.text(this);
        }

        private String text(Node context) {
            String rtn;
            if (context instanceof NodeText) {
                rtn = ((NodeText)context).text;
            } else if (context.children != null) {
                StringBuilder sb = new StringBuilder();
                for (Node node : context.children) {
                    sb.append(this.text(node));
                }
                rtn = sb.toString();
            } else {
                rtn = "";
            }
            return rtn == null ? "" : rtn.replace("&nbsp;", " ").replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"");
        }

        public String toString() {
            return this.toString(false, DomParser.DEFAULT_SPACE, DomParser.DEFAULT_LINE, 0);
        }

        public String toString(boolean format) {
            return this.toString(format, DomParser.DEFAULT_SPACE, DomParser.DEFAULT_LINE, 0);
        }

        public String toString(boolean format, String space) {
            return this.toString(format, space, DomParser.DEFAULT_LINE, 0);
        }

        public String toString(boolean format, String space, String line) {
            return this.toString(format, space, line, 0);
        }

        public String toString(boolean format, String space, String line, int levelref) {
            if (this.children != null) {
                StringBuilder sb = new StringBuilder();
                if (format) {
                    int childLevel = this.getLevel() + levelref + 1;
                    int count = 0;
                    for (Node child : this.children) {
                        if (count > 0) {
                            sb.append(line);
                        }
                        for (int i = 0; i < childLevel; ++i) {
                            sb.append(space);
                        }
                        sb.append(child.toString(format, space, line, levelref));
                        ++count;
                    }
                } else {
                    for (Node child : this.children) {
                        sb.append(child.toString(format, space, line, levelref));
                    }
                }
                return sb.toString();
            }
            return "";
        }

        public ArrayList<Node> getNodesByFilter(Filter filter) {
            ArrayList<Node> results = new ArrayList<Node>();
            Node.findNodesByFilter(results, filter, this);
            return results;
        }

        public ArrayList<Node> getChildNodesByFilter(Filter filter) {
            ArrayList<Node> results = new ArrayList<Node>();
            Node.findChildNodesByFilter(results, filter, this);
            return results;
        }

        public ArrayList<NodeElement> getElementsByFilter(FilterElement filter) {
            final FilterElement elmFilter = filter;
            ArrayList<Node> matches = this.getNodesByFilter(new Filter(){

                @Override
                public boolean match(Node node) {
                    if (node instanceof NodeElement) {
                        return elmFilter.match((NodeElement)node);
                    }
                    return false;
                }
            });
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            for (Node node : matches) {
                if (!(node instanceof NodeElement)) continue;
                result.add((NodeElement)node);
            }
            return result;
        }

        public ArrayList<NodeElement> getChildElementsByFilter(FilterElement filter) {
            final FilterElement elmFilter = filter;
            ArrayList<Node> matches = this.getChildNodesByFilter(new Filter(){

                @Override
                public boolean match(Node node) {
                    if (node instanceof NodeElement) {
                        return elmFilter.match((NodeElement)node);
                    }
                    return false;
                }
            });
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            for (Node node : matches) {
                if (!(node instanceof NodeElement)) continue;
                result.add((NodeElement)node);
            }
            return result;
        }

        public ArrayList<NodeElement> getElementById(String id) {
            final String idFinal = id;
            return this.getElementsByFilter(new FilterElement(){

                @Override
                public boolean match(NodeElement node) {
                    return DomParser.strEqual(idFinal, node.getAttrValue("id"), false);
                }
            });
        }

        public ArrayList<NodeElement> getElementsByClassName(String className) {
            final String classNameFinal = className;
            return this.getElementsByFilter(new FilterElement(){

                @Override
                public boolean match(NodeElement node) {
                    String elementClassName = node.getAttrValue("class");
                    if (elementClassName != null) {
                        String[] classes;
                        for (String cn : classes = elementClassName.split("\\s")) {
                            if (!DomParser.strEqual(classNameFinal, cn, false)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }

        public ArrayList<NodeElement> getElementsByTagName(String tagName) {
            return this.getElementsByTagName(tagName, false);
        }

        public ArrayList<NodeElement> getElementsByTagName(String tagName, boolean xmlmode) {
            final String tagNameFinal = tagName;
            final boolean addAll = "*".equals(tagName);
            final boolean xmlmodeFinal = xmlmode;
            return this.getElementsByFilter(new FilterElement(){

                @Override
                public boolean match(NodeElement node) {
                    return addAll || DomParser.strEqual(tagNameFinal, node.name, !xmlmodeFinal);
                }
            });
        }

        public ArrayList<NodeElement> getElementsByTagAttr(String tagAttrName, String tagAttrValue, boolean xmlmode) {
            final String tagAttrNameFinal = tagAttrName;
            final String tagAttrValueFinal = tagAttrValue;
            final boolean xmlmodeFinal = xmlmode;
            return this.getElementsByFilter(new FilterElement(){

                @Override
                public boolean match(NodeElement node) {
                    return DomParser.strEqual(tagAttrValueFinal, node.getAttrValue(tagAttrNameFinal, !xmlmodeFinal), false);
                }
            });
        }

        private static void findNodesByFilter(ArrayList<Node> matches, Filter filter, Node context) {
            if (context.children != null) {
                for (Node child : context.children) {
                    if (filter.match(child)) {
                        matches.add(child);
                    }
                    Node.findNodesByFilter(matches, filter, child);
                }
            }
        }

        private static void findChildNodesByFilter(ArrayList<Node> matches, Filter filter, Node context) {
            if (context.children != null) {
                for (Node child : context.children) {
                    if (!filter.match(child)) continue;
                    matches.add(child);
                }
            }
        }

        public ArrayList<NodeElement> search(String cssSelector) {
            ArrayList<Node> context = new ArrayList<Node>();
            ArrayList<NodeElement> result = null;
            context.add(this);
            if (cssSelector == null || cssSelector.isEmpty()) {
                return new ArrayList<NodeElement>();
            }
            ArrayList<String> words = Node.getSelectorWordList(cssSelector);
            for (int index = 0; index < words.size(); ++index) {
                String word = words.get(index);
                if ("#".equals(word) || ".".equals(word) || ">".equals(word) || "+".equals(word) || "~".equals(word)) {
                    if (index + 1 < words.size()) {
                        result = Node.searchElement(context, word.charAt(0), words.get(index + 1));
                        ++index;
                    } else {
                        result = null;
                    }
                } else if (":".equals(word)) {
                    if (index + 1 < words.size()) {
                        result = Node.searchElement(context, word.charAt(0), words.get(index + 1));
                        ++index;
                    } else {
                        result = null;
                    }
                } else if ("[".equals(word)) {
                    int endIndex;
                    for (endIndex = index + 1; endIndex < words.size() && !"]".equals(words.get(endIndex)); ++endIndex) {
                    }
                    if (endIndex < words.size()) {
                        int size = endIndex - index;
                        switch (size) {
                            case 2: {
                                result = Node.searchElement(context, '[', words.get(index + 1));
                                break;
                            }
                            case 4: {
                                result = Node.searchElement(context, '[', words.get(index + 1), ' ', words.get(index + 3));
                                break;
                            }
                            case 5: {
                                result = Node.searchElement(context, '[', words.get(index + 1), words.get(index + 2).charAt(0), words.get(index + 4));
                                break;
                            }
                            default: {
                                result = null;
                            }
                        }
                        index = endIndex + 1;
                    } else {
                        result = null;
                    }
                } else {
                    result = Node.searchElement(context, ' ', word);
                }
                if (result == null) continue;
                context = new ArrayList();
                for (NodeElement elm : result) {
                    context.add(elm);
                }
            }
            return result;
        }

        private static ArrayList<String> getSelectorWordList(String cssSelector) {
            String buffStr;
            ArrayList<String> words = new ArrayList<String>();
            char[] splitCh = " #.*:^$|>+~=[]\t\r\n".toCharArray();
            StringBuilder buff = new StringBuilder();
            int index = 0;
            while (index < cssSelector.length()) {
                boolean doSplit;
                char ch = cssSelector.charAt(index);
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                    doSplit = false;
                } else {
                    if (ch == '\"' || ch == '\'') {
                        int end = cssSelector.indexOf(ch, index + 1);
                        if (end < 0) break;
                        String buffStr2 = buff.toString();
                        if (!buffStr2.isEmpty()) {
                            words.add(buffStr2);
                        }
                        buff = new StringBuilder();
                        String str = cssSelector.substring(index + 1, end);
                        words.add(str);
                        index = end + 1;
                        continue;
                    }
                    if (ch == '(') {
                        int end = cssSelector.indexOf(41, index + 1);
                        if (end < 0) break;
                        buff.append(cssSelector.substring(index, end + 1));
                        index = end + 1;
                        continue;
                    }
                    doSplit = false;
                    for (int i = 0; i < splitCh.length; ++i) {
                        if (splitCh[i] != ch) continue;
                        doSplit = true;
                        break;
                    }
                }
                if (doSplit) {
                    String buffStr3 = buff.toString();
                    if (!buffStr3.isEmpty()) {
                        words.add(buffStr3);
                    }
                    buff = new StringBuilder();
                    if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                        words.add(Character.toString(ch));
                    }
                } else {
                    buff.append(ch);
                }
                ++index;
            }
            if (!(buffStr = buff.toString()).isEmpty()) {
                words.add(buffStr);
            }
            return words;
        }

        private static ArrayList<NodeElement> mergeNodes(ArrayList<NodeElement> list1, ArrayList<NodeElement> list2) {
            if (list1 != null && list2 != null) {
                for (NodeElement node : list2) {
                    if (list1.contains(node)) continue;
                    list1.add(node);
                }
                return list1;
            }
            return list1 != null ? list1 : list2;
        }

        private static ArrayList<NodeElement> searchElement(ArrayList<Node> context, char oper1, String str1) {
            return Node.searchElement(context, oper1, str1, ' ', null);
        }

        private static ArrayList<NodeElement> searchElement(ArrayList<Node> context, char oper1, String str1, char oper2, String str2) {
            ArrayList<NodeElement> findNodes = null;
            switch (oper1) {
                case '\u0000': 
                case ' ': {
                    for (Node cNode : context) {
                        findNodes = Node.mergeNodes(findNodes, cNode.getElementsByTagName(str1));
                    }
                    break;
                }
                case '#': {
                    for (Node cNode : context) {
                        findNodes = Node.mergeNodes(findNodes, cNode.getElementById(str1));
                    }
                    break;
                }
                case '.': {
                    for (Node cNode : context) {
                        findNodes = Node.mergeNodes(findNodes, cNode.getElementsByClassName(str1));
                    }
                    break;
                }
                case '>': {
                    findNodes = Node.filterChildElementsByTagName(context, str1);
                    break;
                }
                case '+': {
                    findNodes = Node.filterNextElementsByTagName(context, str1, true);
                    break;
                }
                case '~': {
                    findNodes = Node.filterNextElementsByTagName(context, str1, false);
                    break;
                }
                case ':': {
                    findNodes = Node.filterElementsByPseudoSelector(context, str1);
                    break;
                }
                case '[': {
                    findNodes = Node.filterElementsByAttr(context, str1, str2, oper2);
                    break;
                }
            }
            return Node.mergeNodes(new ArrayList<NodeElement>(), findNodes);
        }

        private static ArrayList<NodeElement> filterElementsByAttr(ArrayList<Node> context, String attrName, String attrValue, char oper) {
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            block8: for (Node node : context) {
                if (!(node instanceof NodeElement)) continue;
                NodeElement element = (NodeElement)node;
                if (attrValue == null) {
                    if (element.getAttr(attrName) == null) continue;
                    result.add(element);
                    continue;
                }
                String getValue = element.getAttrValue(attrName);
                if (getValue == null) continue;
                block0 : switch (oper) {
                    case '\u0000': 
                    case ' ': {
                        if (!attrValue.equals(getValue)) break;
                        result.add(element);
                        break;
                    }
                    case '~': {
                        String[] getValues;
                        for (String val : getValues = getValue.split("\\s")) {
                            if (!attrValue.equals(val)) continue;
                            result.add(element);
                            break block0;
                        }
                        continue block8;
                    }
                    case '^': {
                        if (!getValue.startsWith(attrValue)) break;
                        result.add(element);
                        break;
                    }
                    case '$': {
                        if (!getValue.endsWith(attrValue)) break;
                        result.add(element);
                        break;
                    }
                    case '*': {
                        if (getValue.indexOf(attrValue) < 0) break;
                        result.add(element);
                        break;
                    }
                    case '|': {
                        String[] values1 = getValue.split("-");
                        String[] values2 = attrValue.split("-");
                        boolean match = true;
                        for (int i = 0; i < values2.length; ++i) {
                            if (values2[i].equals(values1[i])) continue;
                            match = false;
                            break;
                        }
                        if (!match) break;
                        result.add(element);
                        break;
                    }
                }
            }
            return result;
        }

        private static ArrayList<NodeElement> filterChildElementsByTagName(ArrayList<Node> context, String tagName) {
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            boolean addAll = "*".equals(tagName);
            for (Node node : context) {
                if (node.children == null) continue;
                for (Node child : node.children) {
                    if (!(child instanceof NodeElement)) continue;
                    NodeElement element = (NodeElement)child;
                    if (!addAll && !tagName.equals(element.name)) continue;
                    result.add(element);
                }
            }
            return result;
        }

        private static ArrayList<NodeElement> filterElementsByPseudoSelector(ArrayList<Node> context, String selector) {
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            selector = selector.toLowerCase();
            String inner = null;
            int startIndex = selector.indexOf(40);
            if (startIndex >= 0) {
                int endIndex = selector.indexOf(41);
                inner = selector.substring(startIndex + 1, endIndex);
                selector = selector.substring(0, startIndex);
            }
            for (Node node : context) {
                ArrayList<NodeElement> children;
                int size;
                ArrayList<NodeElement> children2;
                NodeElement element;
                if ("root".equals(selector)) {
                    if (!(node instanceof NodeElement)) continue;
                    NodeElement element2 = (NodeElement)node;
                    while (element2.parent != null && element2.parent instanceof NodeElement) {
                        element2 = (NodeElement)element2.parent;
                    }
                    result.add(element2);
                    continue;
                }
                if ("nth-child".equals(selector)) {
                    try {
                        int index = Integer.parseInt(inner);
                        if (!(node instanceof NodeElement) || node.parent == null) continue;
                        element = (NodeElement)node;
                        children2 = node.parent.getChildElements();
                        if (index < 0 || index >= children2.size() || !children2.get(index).equals(element)) continue;
                        result.add(element);
                    }
                    catch (Exception index) {}
                    continue;
                }
                if ("nth-last-child".equals(selector)) {
                    try {
                        int index = Integer.parseInt(inner);
                        if (!(node instanceof NodeElement) || node.parent == null) continue;
                        element = (NodeElement)node;
                        children2 = node.parent.getChildElements();
                        size = children2.size();
                        if (index < 0 || index >= size || !children2.get(size - index - 1).equals(element)) continue;
                        result.add(element);
                    }
                    catch (Exception index) {}
                    continue;
                }
                if ("nth-of-type".equals(selector)) {
                    try {
                        int index = Integer.parseInt(inner);
                        if (!(node instanceof NodeElement) || node.parent == null) continue;
                        element = (NodeElement)node;
                        children2 = node.parent.getChildElements(element.name);
                        if (index < 0 || index >= children2.size() || !children2.get(index).equals(element)) continue;
                        result.add(element);
                    }
                    catch (Exception index) {}
                    continue;
                }
                if ("nth-last-of-type".equals(selector)) {
                    try {
                        int index = Integer.parseInt(inner);
                        if (!(node instanceof NodeElement) || node.parent == null) continue;
                        element = (NodeElement)node;
                        children2 = node.parent.getChildElements(element.name);
                        size = children2.size();
                        if (index < 0 || index >= size || !children2.get(size - index - 1).equals(element)) continue;
                        result.add(element);
                    }
                    catch (Exception index) {}
                    continue;
                }
                if ("first-child".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element3 = (NodeElement)node;
                    children = node.parent.getChildElements();
                    if (children.isEmpty() || !children.get(0).equals(element3)) continue;
                    result.add(element3);
                    continue;
                }
                if ("last-child".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element4 = (NodeElement)node;
                    children = node.parent.getChildElements();
                    if (children.isEmpty() || !children.get(children.size() - 1).equals(element4)) continue;
                    result.add(element4);
                    continue;
                }
                if ("first-of-type".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element5 = (NodeElement)node;
                    children = node.parent.getChildElements(element5.name);
                    if (children.isEmpty() || !children.get(0).equals(element5)) continue;
                    result.add(element5);
                    continue;
                }
                if ("last-of-type".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element6 = (NodeElement)node;
                    children = node.parent.getChildElements(element6.name);
                    if (children.isEmpty() || !children.get(children.size() - 1).equals(element6)) continue;
                    result.add(element6);
                    continue;
                }
                if ("only-child".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element7 = (NodeElement)node;
                    children = node.parent.getChildElements();
                    if (children.size() != 1) continue;
                    result.add(element7);
                    continue;
                }
                if ("only-of-type".equals(selector)) {
                    if (!(node instanceof NodeElement) || node.parent == null) continue;
                    NodeElement element8 = (NodeElement)node;
                    children = node.parent.getChildElements(element8.name);
                    if (children.size() != 1) continue;
                    result.add(element8);
                    continue;
                }
                if (!"empty".equals(selector) || !(node instanceof NodeElement)) continue;
                NodeElement element9 = (NodeElement)node;
                if (element9.children != null && !element9.children.isEmpty()) continue;
                result.add(element9);
            }
            return result;
        }

        private static ArrayList<NodeElement> filterNextElementsByTagName(ArrayList<Node> context, String tagName, boolean immediately) {
            boolean addAll = "*".equals(tagName);
            ArrayList<NodeElement> result = new ArrayList<NodeElement>();
            block0: for (Node node : context) {
                if (node.parent == null) continue;
                boolean getNode = false;
                for (int i = 0; i < node.parent.children.size(); ++i) {
                    Node child;
                    if (getNode && (child = node.parent.children.get(i)) instanceof NodeElement) {
                        NodeElement element = (NodeElement)child;
                        if (addAll || tagName.equals(element.name)) {
                            result.add(element);
                            continue block0;
                        }
                        if (immediately) continue block0;
                    }
                    if (getNode || !node.parent.children.get(i).equals(node)) continue;
                    getNode = true;
                }
            }
            return result;
        }

        protected int getLevel() {
            int level = 0;
            Node node = this.parent;
            while (node != null) {
                ++level;
                node = node.parent;
            }
            return level;
        }

        public static interface FilterElement {
            public boolean match(NodeElement var1);
        }

        public static interface Filter {
            public boolean match(Node var1);
        }
    }
}

