/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.read.biff.BiffException;

public class ExcelReader {
    public Workbook ro_workbook;
    public Sheet ro_sheet;

    public boolean open(String filePath) {
        return this.open(new File(filePath));
    }

    public boolean open(File file) {
        try {
            this.ro_workbook = Workbook.getWorkbook((File)file);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BiffException ex) {
            Logger.getLogger(ExcelReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.ro_workbook = null;
        return false;
    }

    public boolean close() {
        if (this.ro_workbook != null) {
            this.ro_workbook.close();
            this.ro_sheet = null;
            this.ro_workbook = null;
            return true;
        }
        return false;
    }

    public String[] getSheetNames() {
        return this.ro_workbook == null ? null : this.ro_workbook.getSheetNames();
    }

    public boolean setSheet(int index) {
        if (this.ro_workbook != null) {
            Sheet[] sheets = this.ro_workbook.getSheets();
            if (index >= 0 && index < sheets.length) {
                this.ro_sheet = sheets[index];
                return true;
            }
            this.ro_sheet = null;
            return false;
        }
        this.ro_sheet = null;
        return false;
    }

    public boolean setSheet(String name) {
        boolean rtn = false;
        if (this.ro_workbook != null) {
            String[] sheetNames;
            for (String sheetName : sheetNames = this.ro_workbook.getSheetNames()) {
                if (!sheetName.equals(name)) continue;
                this.ro_sheet = this.ro_workbook.getSheet(name);
                rtn = true;
                break;
            }
        }
        if (!rtn) {
            this.ro_sheet = null;
        }
        return rtn;
    }

    public int getRows() {
        return this.ro_sheet == null ? 0 : this.ro_sheet.getRows();
    }

    public int getCols() {
        return this.ro_sheet == null ? 0 : this.ro_sheet.getColumns();
    }

    public boolean checkCell(int row, int col) {
        return this.ro_sheet != null && row >= 0 && row < this.getRows() && col >= 0 && col < this.getCols();
    }

    public Cell getCellObject(int row, int col) {
        return this.checkCell(row, col) ? this.ro_sheet.getCell(col, row) : null;
    }

    public String getCell(int row, int col) {
        return this.checkCell(row, col) ? this.ro_sheet.getCell(col, row).getContents() : null;
    }

    public Date getCellDate(int row, int col) {
        Cell cell;
        if (this.checkCell(row, col) && (cell = this.ro_sheet.getCell(col, row)).getType() == CellType.DATE) {
            DateCell dc = (DateCell)cell;
            return dc.getDate();
        }
        return null;
    }

    public double getCellNumber(int row, int col) {
        Cell cell;
        if (this.checkCell(row, col) && (cell = this.ro_sheet.getCell(col, row)).getType() == CellType.NUMBER) {
            NumberCell nc = (NumberCell)cell;
            return nc.getValue();
        }
        return 0.0;
    }

    public int getRowHeight(int row) {
        return this.ro_sheet == null ? 0 : this.ro_sheet.getRowView(row).getSize();
    }

    public int getColWidth(int col) {
        return this.ro_sheet == null ? 0 : this.ro_sheet.getColumnView(col).getSize();
    }

    public boolean getRowAutosize(int row) {
        return this.ro_sheet == null ? false : this.ro_sheet.getRowView(row).isAutosize();
    }

    public boolean getColAutosize(int col) {
        return this.ro_sheet == null ? false : this.ro_sheet.getColumnView(col).isAutosize();
    }

    public boolean getRowHidden(int row) {
        return this.ro_sheet == null ? false : this.ro_sheet.getRowView(row).isHidden();
    }

    public boolean getColHidden(int col) {
        return this.ro_sheet == null ? false : this.ro_sheet.getColumnView(col).isHidden();
    }

    public CellRange[] getMerages() {
        if (this.ro_sheet == null) {
            return null;
        }
        Range[] ranges = this.ro_sheet.getMergedCells();
        if (ranges == null) {
            return null;
        }
        CellRange[] rtn = new CellRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            Cell topLeft = ranges[i].getTopLeft();
            Cell bottomRight = ranges[i].getBottomRight();
            rtn[i] = new CellRange(topLeft.getRow(), topLeft.getColumn(), bottomRight.getRow(), bottomRight.getColumn());
        }
        return rtn;
    }

    public String getCellFontName(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getName();
        }
        return null;
    }

    public int getCellFontSize(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getPointSize();
        }
        return 0;
    }

    public boolean getCellFontItalic(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().isItalic();
        }
        return false;
    }

    public int getCellFontBoldWeight(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getBoldWeight();
        }
        return 0;
    }

    public Colour getCellFontColor(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getColour();
        }
        return null;
    }

    public Colour getCellBgColor(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getBackgroundColour();
        }
        return null;
    }

    public Alignment getCellAlignment(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getAlignment();
        }
        return null;
    }

    public VerticalAlignment getCellVerticalAlignment(int row, int col) {
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getVerticalAlignment();
        }
        return null;
    }

    public static class CellRange {
        public int row1;
        public int col1;
        public int row2;
        public int col2;

        public CellRange(int row1, int col1, int row2, int col2) {
            this.row1 = row1;
            this.col1 = col1;
            this.row2 = row2;
            this.col2 = col2;
        }
    }
}

