/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.modnut.framework2.tool.ToolStr;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HardwareInfo {
    private static final String SPECIAL_MAC = "00000000000000E0";

    public static String getWinCpuID() {
        String serial = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            try {
                sc.next();
                serial = sc.next();
            }
            finally {
                sc.close();
            }
        }
        catch (Exception ex) {
            serial = null;
        }
        if (serial != null) {
            if ((serial = serial.trim().toUpperCase()).isEmpty()) {
                serial = null;
            } else if (serial.indexOf("WMIC") >= 0) {
                serial = null;
            }
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxCpuID() {
        String serial = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"dmidecode", "-t", "processor"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            try {
                while (sc.hasNext()) {
                    String line = sc.nextLine();
                    if (line == null || !(line = line.trim()).startsWith("ID:") || line.length() <= 3) continue;
                    serial = line.substring(3).replace(" ", "");
                }
            }
            finally {
                sc.close();
            }
        }
        catch (Exception ex) {
            serial = null;
        }
        if (serial != null && (serial = serial.trim().toUpperCase()).isEmpty()) {
            serial = null;
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMacUUID() {
        String uuid = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ioreg", "-d2", "-c", "IOPlatformExpertDevice"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            try {
                while (sc.hasNext()) {
                    int index;
                    String line = sc.nextLine();
                    if (line == null || !(line = line.trim()).startsWith("\"IOPlatformUUID\"") || (index = line.indexOf("=")) < 0 || index >= line.length() - 1) continue;
                    String uuidStr = line.substring(index + 1).trim();
                    if (uuidStr.startsWith("\"") && uuidStr.endsWith("\"") && uuidStr.length() > 2) {
                        uuidStr = uuidStr.substring(1, uuidStr.length() - 1);
                    }
                    uuid = uuidStr;
                }
            }
            finally {
                sc.close();
            }
        }
        catch (Exception ex) {
            uuid = null;
        }
        if (uuid != null && (uuid = uuid.trim().toUpperCase()).isEmpty()) {
            uuid = null;
        }
        return uuid;
    }

    public static String getSerial() {
        String osname = System.getProperty("os.name");
        String string = osname = osname == null ? "" : osname.toLowerCase();
        if (osname.indexOf("windows") >= 0) {
            return HardwareInfo.getWinCpuID();
        }
        if (osname.indexOf("linux") >= 0) {
            return HardwareInfo.getLinuxCpuID();
        }
        if (osname.indexOf("mac") >= 0) {
            return HardwareInfo.getMacUUID();
        }
        return null;
    }

    public static ArrayList<String> getMacAddress() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                String mac;
                NetworkInterface ni = networkInterfaces.nextElement();
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null || hardwareAddress.length <= 0 || SPECIAL_MAC.equals(mac = ToolStr.bytes2Hex(hardwareAddress).toUpperCase())) continue;
                macList.add(mac);
            }
        }
        catch (SocketException ex) {
            Logger.getLogger(HardwareInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return macList;
    }
}

