/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.modnut.framework2.constant.ConstFramework;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HttpClient {
    protected static final METHOD DEFAULT_METHOD = METHOD.GET;
    protected static final int DEFAULT_TIMEOUT = 30000;
    protected static final int BUFF_SIZE = 4096;
    protected static int HttpClientRequestCounter = 0;
    protected static final String COOKIE = "Cookie";
    protected static final String SET_COOKIE = "Set-Cookie";
    protected static final String SECURE = "secure";
    protected static final String VERSION = "version";
    protected static final String COMMENT = "comment";
    protected static final String DOMAIN = "domain";
    protected static final String PATH = "path";
    protected static final String MAX_AGE = "max-age";
    protected static final String EXPIRES = "expires";
    protected static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"};
    public String accept;
    public String acceptCharset;
    public String acceptEncoding;
    public String acceptLanguage;
    public Charset charset;
    public String host;
    public String referer;
    public String userAgent;
    public final ArrayList<Cookie> cookies = new ArrayList();
    public METHOD defaultMethod = DEFAULT_METHOD;
    public int timeout = 30000;

    public void asBroswer(String userAgent) {
        this.accept = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8";
        this.acceptEncoding = "gzip, deflate, sdch";
        this.acceptLanguage = "zh-CN,zh;q=0.8,en-US;q=0.6,en;q=0.4";
        this.userAgent = userAgent;
    }

    public HttpClientRequest getNewRequest(String urlStr, HashMap<String, Object> paramMap) {
        return new HttpClientRequest(urlStr, paramMap);
    }

    public HttpClientRequest getNewRequest(String urlStr, HashMap<String, Object> paramMap, HttpClientListener listener) {
        return new HttpClientRequest(urlStr, paramMap, listener);
    }

    public HttpClientRequest getNewRequest(String urlStr, METHOD method, HashMap<String, String> paramMap) {
        return new HttpClientRequest(urlStr, method, paramMap);
    }

    public HttpClientRequest getNewRequest(String urlStr, METHOD method, HashMap<String, String> paramMap, HttpClientListener listener) {
        return new HttpClientRequest(urlStr, method, paramMap, listener);
    }

    public HttpClientRequest getNewRequest(String urlStr, byte[] dataBytes) {
        return new HttpClientRequest(urlStr, dataBytes);
    }

    public HttpClientRequest getNewRequest(String urlStr, byte[] dataBytes, HttpClientListener listener) {
        return new HttpClientRequest(urlStr, dataBytes, listener);
    }

    public HttpClientRequest getNewRequest(String urlStr, String dataStr) {
        Charset useCharset = this.charset == null ? ConstFramework.getCharset() : this.charset;
        dataStr = dataStr == null ? "" : dataStr;
        return new HttpClientRequest(urlStr, dataStr.getBytes(useCharset));
    }

    public HttpClientRequest getNewRequest(String urlStr, String dataStr, HttpClientListener listener) {
        Charset useCharset = this.charset == null ? ConstFramework.getCharset() : this.charset;
        dataStr = dataStr == null ? "" : dataStr;
        return new HttpClientRequest(urlStr, dataStr.getBytes(useCharset), listener);
    }

    public HttpClientResponse get(String urlStr, HashMap<String, String> paramMap) {
        return this.send(urlStr, METHOD.GET, paramMap);
    }

    public HttpClientResponse post(String urlStr, HashMap<String, String> paramMap) {
        return this.send(urlStr, METHOD.POST, paramMap);
    }

    public HttpClientResponse write(String urlStr, String dataStr) {
        Charset useCharset = this.charset == null ? ConstFramework.getCharset() : this.charset;
        dataStr = dataStr == null ? "" : dataStr;
        HttpClientRequest request = new HttpClientRequest(urlStr, dataStr.getBytes(useCharset));
        try {
            return request.initRequest().getResponse();
        }
        catch (Exception ex) {
            return new HttpClientResponse(ex);
        }
    }

    public HttpClientResponse write(String urlStr, byte[] dataBytes) {
        HttpClientRequest request = new HttpClientRequest(urlStr, dataBytes);
        try {
            return request.initRequest().getResponse();
        }
        catch (Exception ex) {
            return new HttpClientResponse(ex);
        }
    }

    public HttpClientResponse send(String urlStr, METHOD method, HashMap<String, String> paramMap) {
        HttpClientRequest request = new HttpClientRequest(urlStr, method, paramMap);
        try {
            return request.initRequest().getResponse();
        }
        catch (Exception ex) {
            return new HttpClientResponse(ex);
        }
    }

    public HttpClientResponse multipartPost(String urlStr, HashMap<String, Object> paramMap) {
        HttpClientRequest request = new HttpClientRequest(urlStr, paramMap);
        try {
            return request.initRequest().getResponse();
        }
        catch (Exception ex) {
            return new HttpClientResponse(ex);
        }
    }

    public File download(String urlStr, String path) {
        return this.download(urlStr, path, METHOD.GET, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(String urlStr, String path, METHOD method, HashMap<String, String> paramMap) {
        File dir;
        String dirPath;
        int ui;
        int index;
        if (urlStr == null || path == null) {
            return null;
        }
        String fileName = (path = path.replace('\\', File.separatorChar).replace('/', File.separatorChar)).substring((index = path.lastIndexOf(File.separatorChar)) + 1);
        if ("".equals(fileName) && (fileName = urlStr.substring((ui = urlStr.lastIndexOf(File.separatorChar)) >= 0 ? ui + 1 : 0)).equals("")) {
            fileName = "index.html";
        }
        if ((dirPath = path.substring(0, index + 1)) == null || dirPath.isEmpty()) {
            dirPath = "." + File.separator;
        }
        if (!(dir = new File(dirPath)).exists() && !dir.mkdirs()) {
            return null;
        }
        File file = new File(dirPath + fileName);
        HttpClientRequest request = new HttpClientRequest(urlStr, method, paramMap);
        try {
            boolean gzip;
            InputStream is = request.initRequest().conn.getInputStream();
            String contentEncoding = request.conn.getHeaderField("Content-Encoding");
            boolean bl = gzip = contentEncoding != null && contentEncoding.toLowerCase().equals("gzip");
            if (gzip) {
                is = new GZIPInputStream(is);
            }
            try {
                FileOutputStream os = new FileOutputStream(file);
                try {
                    int readCnt;
                    byte[] buff = new byte[4096];
                    while ((readCnt = is.read(buff)) != -1) {
                        os.write(buff, 0, readCnt);
                    }
                }
                finally {
                    os.close();
                }
            }
            finally {
                is.close();
            }
            request.initRequest().conn.disconnect();
            return file;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public HttpClientRequest doGet(HttpClientListener listener, String urlStr, HashMap<String, String> paramMap) {
        return this.doSend(listener, urlStr, METHOD.GET, paramMap);
    }

    public HttpClientRequest doPost(HttpClientListener listener, String urlStr, HashMap<String, String> paramMap) {
        return this.doSend(listener, urlStr, METHOD.POST, paramMap);
    }

    public HttpClientRequest doWrite(HttpClientListener listener, String urlStr, String dataStr) {
        Charset useCharset = this.charset == null ? ConstFramework.getCharset() : this.charset;
        dataStr = dataStr == null ? "" : dataStr;
        return new HttpClientRequest(urlStr, dataStr.getBytes(useCharset), listener).send();
    }

    public HttpClientRequest doWrite(HttpClientListener listener, String urlStr, byte[] dataBytes) {
        return new HttpClientRequest(urlStr, dataBytes, listener).send();
    }

    public HttpClientRequest doSend(HttpClientListener listener, String urlStr, METHOD method, HashMap<String, String> paramMap) {
        return new HttpClientRequest(urlStr, method, paramMap, listener).send();
    }

    public HttpClientRequest doMultipartPost(HttpClientListener listener, String urlStr, HashMap<String, Object> paramMap) {
        return new HttpClientRequest(urlStr, paramMap, listener).send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void solveSetCookie(Map<String, List<String>> headerFields) {
        if (headerFields == null || this.cookies == null) {
            return;
        }
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            List<String> values = headerFields.get(SET_COOKIE);
            if (values == null) {
                return;
            }
            for (String v : values) {
                int i;
                Cookie cookie;
                String[] fields = v.split(";");
                String[] cookieStrs = fields[0].split("=");
                String name = cookieStrs[0];
                if (cookieStrs.length > 1) {
                    String val = cookieStrs[1];
                    if (val != null && val.startsWith("\"") && val.endsWith("\"")) {
                        val = val.substring(1, val.length() - 1);
                    }
                    cookie = new Cookie(name, val);
                } else {
                    cookie = new Cookie(name, null);
                }
                block10: for (i = 1; i < fields.length; ++i) {
                    String headerValue;
                    String[] header = fields[i].split("=");
                    String headerName = header[0].trim().toLowerCase();
                    String string = headerValue = header.length > 1 ? header[1].trim() : "";
                    if (headerValue != null && headerValue.startsWith("\"") && headerValue.endsWith("\"")) {
                        headerValue = headerValue.substring(1, headerValue.length() - 1);
                    }
                    if (SECURE.equals(headerName)) {
                        cookie.secure = true;
                        continue;
                    }
                    if (VERSION.equals(headerName)) {
                        try {
                            cookie.version = Integer.parseInt(headerValue);
                        }
                        catch (Exception ex) {
                            cookie.version = 0;
                        }
                        continue;
                    }
                    if (COMMENT.equals(headerName)) {
                        cookie.comment = headerValue;
                        continue;
                    }
                    if (DOMAIN.equals(headerName)) {
                        cookie.domain = headerValue;
                        continue;
                    }
                    if (PATH.equals(headerName)) {
                        cookie.path = headerValue;
                        continue;
                    }
                    if (MAX_AGE.equals(headerName)) {
                        int maxAge;
                        try {
                            maxAge = Integer.parseInt(headerValue);
                        }
                        catch (Exception ex) {
                            maxAge = -1;
                        }
                        cookie.timeStamp = System.currentTimeMillis() + (long)(maxAge * 1000);
                        continue;
                    }
                    if (!EXPIRES.equals(headerName)) continue;
                    for (String dateFormat : DATE_FORMATS) {
                        try {
                            SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.US);
                            Date date = format.parse(headerValue);
                            cookie.timeStamp = date.getTime();
                            continue block10;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                for (i = 0; i < this.cookies.size(); ++i) {
                    if (!this.cookies.get((int)i).name.equals(cookie.name)) continue;
                    this.cookies.remove(i);
                    break;
                }
                if (cookie.timeStamp != 0L && cookie.timeStamp < System.currentTimeMillis()) continue;
                this.cookies.add(cookie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void solveCookie(HttpURLConnection url) {
        if (url == null || this.cookies == null) {
            return;
        }
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            String domain = url.getURL().getHost();
            String path = url.getURL().getPath();
            StringBuilder sb = null;
            Iterator<Cookie> iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                Cookie c = iterator.next();
                if (c.timeStamp != 0L && c.timeStamp < System.currentTimeMillis()) {
                    iterator.remove();
                    continue;
                }
                if (!c.matchDomain(domain) || !c.matchPath(path)) continue;
                if (sb == null) {
                    sb = new StringBuilder(c.name + "=" + c.value);
                    continue;
                }
                sb.append(";").append(c.name).append("=").append(c.value);
            }
            if (sb != null) {
                url.setRequestProperty(COOKIE, sb.toString());
            }
        }
    }

    protected static String buildParamData(HashMap<String, String> paramMap, Charset charset) throws UnsupportedEncodingException {
        StringBuilder dataBuilder = new StringBuilder();
        if (paramMap != null) {
            int paramCnt = 0;
            for (String key : paramMap.keySet()) {
                if (paramCnt > 0) {
                    dataBuilder.append("&");
                }
                String value = paramMap.get(key);
                dataBuilder.append(HttpClient.URLEncode(key, charset)).append("=").append(HttpClient.URLEncode(value, charset));
                ++paramCnt;
            }
        }
        return dataBuilder.toString();
    }

    public static String URLEncode(String str, Charset charset) throws UnsupportedEncodingException {
        return str == null ? "" : URLEncoder.encode(str, charset.name());
    }

    public static String URLDecode(String str, Charset charset) throws UnsupportedEncodingException {
        return str == null ? "" : URLDecoder.decode(str, charset.name());
    }

    public static String getRefUrlStr(String httpUrl, String url) {
        httpUrl = httpUrl.trim().toLowerCase();
        if ((url = url.trim().toLowerCase()).startsWith("http://")) {
            return url;
        }
        if (httpUrl.startsWith("http://")) {
            if (url.startsWith("/")) {
                int endIndex = httpUrl.indexOf(47, "http://".length());
                String prefix = httpUrl.substring(0, endIndex);
                return prefix + url;
            }
            int endIndex = httpUrl.lastIndexOf(47);
            String prefix = httpUrl.substring(0, endIndex + 1);
            return prefix + url;
        }
        return url;
    }

    public class HttpClientResponse {
        public static final int CODE_EXPCETION = -1;
        public static final int CODE_OK = 200;
        public int code;
        public Map<String, List<String>> headerFields;
        public String text;
        public Exception ex;

        public HttpClientResponse(int code, Map<String, List<String>> headerFields, String text) {
            this.code = code;
            this.headerFields = headerFields;
            this.text = text;
            this.ex = null;
        }

        public HttpClientResponse(Exception ex) {
            this.code = -1;
            this.text = null;
            this.ex = ex;
        }

        public String getStatus() {
            switch (this.code) {
                case -1: {
                    return "Exception";
                }
                case 100: {
                    return "Continue";
                }
                case 101: {
                    return "Switching Protocols";
                }
                case 200: {
                    return "OK";
                }
                case 201: {
                    return "Created";
                }
                case 202: {
                    return "Accepted";
                }
                case 203: {
                    return "Non-Authoritative Information";
                }
                case 204: {
                    return "No Content";
                }
                case 205: {
                    return "Reset Content";
                }
                case 206: {
                    return "Partial Content";
                }
                case 300: {
                    return "Multiple Choices";
                }
                case 301: {
                    return "Moved Permanently";
                }
                case 302: {
                    return "Found";
                }
                case 303: {
                    return "See Other";
                }
                case 304: {
                    return "Not Modified";
                }
                case 305: {
                    return "Use Proxy";
                }
                case 307: {
                    return "Temporary Redirect";
                }
                case 400: {
                    return "Bad Request";
                }
                case 401: {
                    return "Unauthorized";
                }
                case 402: {
                    return "Payment Required";
                }
                case 403: {
                    return "Forbidden";
                }
                case 404: {
                    return "Not Found";
                }
                case 405: {
                    return "Method Not Allowed";
                }
                case 406: {
                    return "Not Acceptable";
                }
                case 407: {
                    return "Proxy Authentication Required";
                }
                case 408: {
                    return "Request Time-out";
                }
                case 409: {
                    return "Conflict";
                }
                case 410: {
                    return "Gone";
                }
                case 411: {
                    return "Length Required";
                }
                case 412: {
                    return "Precondition Failed";
                }
                case 413: {
                    return "Request Entity Too Large";
                }
                case 414: {
                    return "Request-URI Too Large";
                }
                case 415: {
                    return "Unsupported Media Type";
                }
                case 416: {
                    return "Requested range not satisfiable";
                }
                case 417: {
                    return "Expectation Failed";
                }
                case 500: {
                    return "Internal Server Error";
                }
                case 501: {
                    return "Not Implemented";
                }
                case 502: {
                    return "Bad Gateway";
                }
                case 503: {
                    return "Service Unavailable";
                }
                case 504: {
                    return "Gateway Time-out";
                }
                case 505: {
                    return "HTTP Version not supported";
                }
            }
            return "Unknow";
        }
    }

    public class HttpClientRequest
    extends Thread {
        public long id = HttpClientRequestCounter++;
        public METHOD method;
        public String urlStr;
        public HashMap paramMap;
        public byte[] dataBytes;
        public URL url;
        public HttpURLConnection conn;
        protected HttpClientListener listener;
        protected boolean multipart;

        public HttpClientRequest(String urlStr, METHOD method, HashMap<String, String> paramMap) {
            this.urlStr = urlStr;
            this.method = method;
            this.paramMap = paramMap;
            this.listener = null;
            this.multipart = false;
        }

        public HttpClientRequest(String urlStr, METHOD method, HashMap<String, String> paramMap, HttpClientListener listener) {
            this.urlStr = urlStr;
            this.method = method;
            this.paramMap = paramMap;
            this.listener = listener;
            this.multipart = false;
        }

        public HttpClientRequest(String urlStr, HashMap<String, Object> paramMap) {
            this.urlStr = urlStr;
            this.method = METHOD.POST;
            this.paramMap = paramMap;
            this.listener = null;
            this.multipart = true;
        }

        public HttpClientRequest(String urlStr, HashMap<String, Object> paramMap, HttpClientListener listener) {
            this.urlStr = urlStr;
            this.method = METHOD.POST;
            this.paramMap = paramMap;
            this.listener = listener;
            this.multipart = true;
        }

        public HttpClientRequest(String urlStr, byte[] dataBytes) {
            this.urlStr = urlStr;
            this.method = METHOD.POST;
            this.paramMap = null;
            this.dataBytes = dataBytes;
            this.listener = null;
            this.multipart = false;
        }

        public HttpClientRequest(String urlStr, byte[] dataBytes, HttpClientListener listener) {
            this.urlStr = urlStr;
            this.method = METHOD.POST;
            this.paramMap = null;
            this.dataBytes = dataBytes;
            this.listener = listener;
            this.multipart = false;
        }

        @Override
        public void run() {
            HttpClientResponse response;
            try {
                this.initRequest();
                response = this.getResponse();
            }
            catch (Exception ex) {
                response = new HttpClientResponse(ex);
            }
            if (this.listener != null) {
                if (response.ex == null) {
                    if (response.code == 200) {
                        this.listener.onData(this, response, response.text);
                    } else {
                        this.listener.onError(this, response, response.code);
                    }
                } else {
                    this.listener.onException(this, response, response.ex);
                }
            }
        }

        public HttpClientRequest send() {
            this.start();
            return this;
        }

        public HttpClientRequest initRequest() throws Exception {
            return this.initRequest(null);
        }

        public HttpClientRequest initRequest(HashMap<String, String> propertys) throws Exception {
            String data;
            Charset useCharset = HttpClient.this.charset == null ? ConstFramework.getCharset() : HttpClient.this.charset;
            this.method = this.method == null ? HttpClient.this.defaultMethod : this.method;
            METHOD mETHOD = this.method = this.method == null ? DEFAULT_METHOD : this.method;
            this.url = this.method == METHOD.GET ? ("".equals(data = HttpClient.buildParamData(this.paramMap, useCharset)) ? new URL(this.urlStr) : (this.urlStr.indexOf("?") >= 0 ? new URL(this.urlStr + "&" + data) : new URL(this.urlStr + "?" + data))) : new URL(this.urlStr);
            this.conn = (HttpURLConnection)this.url.openConnection();
            if (this.url.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection conn2 = (HttpsURLConnection)this.conn;
                conn2.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (HttpClient.this.timeout > 0) {
                this.conn.setConnectTimeout(HttpClient.this.timeout);
                this.conn.setReadTimeout(HttpClient.this.timeout);
            }
            this.conn.setDoOutput(METHOD.POST == this.method);
            this.conn.setUseCaches(false);
            this.conn.setRequestMethod(this.method.name());
            this.conn.setRequestProperty("Connection", "Keep-Alive");
            if (HttpClient.this.accept != null) {
                this.conn.setRequestProperty("Accept", HttpClient.this.accept);
            }
            if (HttpClient.this.acceptCharset != null) {
                this.conn.setRequestProperty("Accept-Charset", HttpClient.this.acceptCharset);
            }
            if (HttpClient.this.acceptEncoding != null) {
                this.conn.setRequestProperty("Accept-Encoding", HttpClient.this.acceptEncoding);
            }
            if (HttpClient.this.acceptLanguage != null) {
                this.conn.setRequestProperty("Accept-Language", HttpClient.this.acceptLanguage);
            }
            if (HttpClient.this.charset != null) {
                this.conn.setRequestProperty("Charset", HttpClient.this.charset.name());
            }
            if (HttpClient.this.host != null) {
                this.conn.setRequestProperty("Host", HttpClient.this.host);
            }
            if (HttpClient.this.referer != null) {
                this.conn.setRequestProperty("Referer", HttpClient.this.referer);
            }
            if (HttpClient.this.userAgent != null) {
                this.conn.setRequestProperty("User-Agent", HttpClient.this.userAgent);
            }
            if (propertys != null) {
                for (String key : propertys.keySet()) {
                    this.conn.setRequestProperty(key, propertys.get(key));
                }
            }
            HttpClient.this.solveCookie(this.conn);
            if (METHOD.POST == this.method) {
                if (this.multipart) {
                    StringBuilder sbBoundary = new StringBuilder("----NutHttpClientFormBoundary");
                    sbBoundary.append(Long.toHexString(System.currentTimeMillis()));
                    this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + sbBoundary.toString());
                    byte[] startBoundary = sbBoundary.insert(0, "--").toString().getBytes();
                    byte[] endBoundary = sbBoundary.append("--").toString().getBytes();
                    byte[] fileContentType = "Content-Type: application/octet-stream".getBytes();
                    byte[] lineBreak = "\r\n".getBytes();
                    int disposotionLen1 = "Content-Disposition: form-data; name=\"\"".getBytes().length;
                    int disposotionLen2 = "Content-Disposition: form-data; name=\"\"; filename=\"\"".getBytes().length;
                    int contentLength = 0;
                    for (Object name : this.paramMap.keySet()) {
                        Object data2 = this.paramMap.get(name);
                        if (data2 instanceof String) {
                            String str = (String)data2;
                            contentLength += startBoundary.length + lineBreak.length + disposotionLen1 + name.toString().getBytes(useCharset).length + lineBreak.length + lineBreak.length + str.getBytes(useCharset).length + lineBreak.length;
                            continue;
                        }
                        if (data2 instanceof File) {
                            File file = (File)data2;
                            contentLength = (int)((long)contentLength + ((long)(startBoundary.length + lineBreak.length + disposotionLen2 + name.toString().getBytes(useCharset).length + file.getName().getBytes(useCharset).length + lineBreak.length + fileContentType.length + lineBreak.length + lineBreak.length) + file.length() + (long)lineBreak.length));
                            continue;
                        }
                        if (!(data2 instanceof byte[])) continue;
                        byte[] bytes = (byte[])data2;
                        contentLength += startBoundary.length + lineBreak.length + disposotionLen1 + name.toString().getBytes(useCharset).length + lineBreak.length + lineBreak.length + bytes.length + lineBreak.length;
                    }
                    this.conn.setRequestProperty("Content-Length", Integer.toString(contentLength += endBoundary.length + lineBreak.length));
                    OutputStream os = this.conn.getOutputStream();
                    for (Object name : this.paramMap.keySet()) {
                        String disposition;
                        Object data3 = this.paramMap.get(name);
                        if (data3 instanceof String) {
                            String str = (String)data3;
                            os.write(startBoundary);
                            os.write(lineBreak);
                            disposition = "Content-Disposition: form-data; name=\"" + name.toString() + "\"";
                            os.write(disposition.getBytes(useCharset));
                            os.write(lineBreak);
                            os.write(lineBreak);
                            os.write(str.getBytes(useCharset));
                            os.write(lineBreak);
                            continue;
                        }
                        if (data3 instanceof File) {
                            int readCnt;
                            File file = (File)data3;
                            os.write(startBoundary);
                            os.write(lineBreak);
                            disposition = "Content-Disposition: form-data; name=\"" + name.toString() + "\"; filename=\"" + file.getName() + "\"";
                            os.write(disposition.getBytes(useCharset));
                            os.write(lineBreak);
                            os.write(fileContentType);
                            os.write(lineBreak);
                            os.write(lineBreak);
                            FileInputStream is = new FileInputStream(file);
                            byte[] fileBuff = new byte[4096];
                            while ((readCnt = is.read(fileBuff)) != -1) {
                                os.write(fileBuff, 0, readCnt);
                            }
                            is.close();
                            os.write(lineBreak);
                            continue;
                        }
                        if (!(data3 instanceof byte[])) continue;
                        byte[] bytes = (byte[])data3;
                        os.write(startBoundary);
                        os.write(lineBreak);
                        disposition = "Content-Disposition: form-data; name=\"" + name.toString() + "\"";
                        os.write(disposition.getBytes(useCharset));
                        os.write(lineBreak);
                        os.write(lineBreak);
                        os.write(bytes);
                        os.write(lineBreak);
                    }
                    os.write(endBoundary);
                    os.write(lineBreak);
                    os.close();
                } else {
                    byte[] requestData = this.dataBytes;
                    if (requestData == null) {
                        String data4 = HttpClient.buildParamData(this.paramMap, useCharset);
                        requestData = data4.getBytes(useCharset);
                    }
                    this.conn.setRequestProperty("Content-Length", Integer.toString(requestData.length));
                    OutputStream os = this.conn.getOutputStream();
                    os.write(requestData);
                    os.close();
                }
            }
            return this;
        }

        public HttpClientResponse getResponse() throws Exception {
            HttpClientResponse response;
            int rtnCode = this.conn.getResponseCode();
            Map<String, List<String>> headerFields = this.conn.getHeaderFields();
            HttpClient.this.solveSetCookie(headerFields);
            if (rtnCode == 200) {
                int length;
                BufferedReader in;
                String contentEncoding;
                boolean gzip;
                String contentType = this.conn.getHeaderField("Content-Type");
                String responseCharset = null;
                if (contentType != null) {
                    String[] fields;
                    for (String field : fields = contentType.split(";")) {
                        String[] pair = field.trim().split("=");
                        if (pair.length < 2 || !"charset".equals(pair[0].trim().toLowerCase())) continue;
                        responseCharset = pair[1].trim();
                        break;
                    }
                }
                boolean bl = gzip = (contentEncoding = this.conn.getHeaderField("Content-Encoding")) != null && contentEncoding.toLowerCase().equals("gzip");
                if (responseCharset == null) {
                    responseCharset = HttpClient.this.acceptCharset;
                }
                if (responseCharset != null) {
                    in = new BufferedReader(new InputStreamReader(gzip ? new GZIPInputStream(this.conn.getInputStream()) : this.conn.getInputStream(), responseCharset));
                } else {
                    Charset useCharset = HttpClient.this.charset == null ? ConstFramework.getCharset() : HttpClient.this.charset;
                    in = new BufferedReader(new InputStreamReader(gzip ? new GZIPInputStream(this.conn.getInputStream()) : this.conn.getInputStream(), useCharset));
                }
                char[] buff = new char[4096];
                StringBuilder responseSb = new StringBuilder();
                while ((length = in.read(buff)) != -1) {
                    responseSb.append(new String(buff, 0, length));
                }
                in.close();
                response = new HttpClientResponse(rtnCode, headerFields, responseSb.toString());
            } else {
                response = new HttpClientResponse(rtnCode, headerFields, null);
            }
            this.conn.disconnect();
            return response;
        }
    }

    public static interface HttpClientListener {
        public void onData(HttpClientRequest var1, HttpClientResponse var2, String var3);

        public void onError(HttpClientRequest var1, HttpClientResponse var2, int var3);

        public void onException(HttpClientRequest var1, HttpClientResponse var2, Exception var3);
    }

    public static class Cookie {
        protected static final long TS_EXPIRE = 0L;
        public static final int DEFUALT_VERSION = 0;
        public static final int DEFUALT_MAX_AGE = -1;
        public String name;
        public String value;
        public boolean secure = false;
        public int version = 0;
        public String comment = null;
        public String domain = null;
        public String path = null;
        public long timeStamp = 0L;

        public Cookie(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean matchDomain(String domain) {
            if (this.domain == null) {
                return true;
            }
            return domain.indexOf(this.domain) >= 0;
        }

        public boolean matchPath(String path) {
            if (this.path == null) {
                return true;
            }
            return path.startsWith(this.path);
        }
    }

    public static class UserAgent {
        public static final String MAC_SAFARI = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_8; en-us) AppleWebKit/534.50 (KHTML, like Gecko) Version/5.1 Safari/534.50";
        public static final String MAC_CHROME = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36";
        public static final String MAC_FIREFOX = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:2.0.1) Gecko/20100101 Firefox/4.0.1";
        public static final String MAC_OPERA = "Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; en) Presto/2.8.131 Version/11.11";
        public static final String WIN_IE6 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
        public static final String WIN_IE7 = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)";
        public static final String WIN_IE8 = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)";
        public static final String WIN_IE9 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0;";
        public static final String WIN_SAFARI = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-us) AppleWebKit/534.50 (KHTML, like Gecko) Version/5.1 Safari/534.50";
        public static final String WIN_CHROME = "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36";
        public static final String WIN_FIREFOX = "Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1";
        public static final String WIN_OPERA = "Opera/9.80 (Windows NT 6.1; U; en) Presto/2.8.131 Version/11.11";
        public static final String APPLE_IPAD = "Mozilla/5.0 (iPad; CPU OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53";
        public static final String APPLE_IPHONE4 = "Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_2_1 like Mac OS X; en-us) AppleWebKit/533.17.9 (KHTML, like Gecko) Version/5.0.2 Mobile/8C148 Safari/6533.18.5";
        public static final String APPLE_IPHONE5 = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X; en-us) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53";
        public static final String APPLE_IPHONE6 = "Mozilla/5.0 (iPhone; CPU iPhone OS 8_0 like Mac OS X) AppleWebKit/600.1.3 (KHTML, like Gecko) Version/8.0 Mobile/12A4345d Safari/600.1.4";
        public static final String GOOGLE_NEXUS4 = "Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 4 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.166 Mobile Safari/535.19";
        public static final String GOOGLE_NEXUS5 = "Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.166 Mobile Safari/535.19";
        public static final String GOOGLE_NEXUS7 = "Mozilla/5.0 (Linux; Android 4.3; Nexus 7 Build/JSS15Q) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.72 Safari/537.36";
        public static final String GOOGLE_NEXUS10 = "Mozilla/5.0 (Linux; Android 4.3; Nexus 10 Build/JSS15Q) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.72 Safari/537.36";
        public static final String SAMSUNG_NOTE = "Mozilla/5.0 (Linux; U; Android 2.3; en-us; SAMSUNG-SGH-I717 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1";
        public static final String SAMSUNG_NOTE2 = "Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
        public static final String SAMSUNG_NOTE3 = "Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
    }

    public static enum METHOD {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }
}

