/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinYin {
    private static final ArrayList<Char> data = new ArrayList();

    public static boolean load() {
        try {
            String line;
            InputStream in = PinYin.class.getResourceAsStream("PinYin.txt");
            if (in == null) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            Pattern pattern = Pattern.compile("([a-z]*)(\\s*)([1-5])(\\s*)(.)(\\s*)");
            data.clear();
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                boolean matches;
                if ("".equals(line.trim()) || !(matches = (matcher = pattern.matcher(line)).matches())) continue;
                char chinese = matcher.group(5).toCharArray()[0];
                String spell = matcher.group(1);
                byte tone = Byte.parseByte(matcher.group(3));
                data.add(new Char(chinese, spell, tone));
            }
            reader.close();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(PinYin.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static ArrayList<Char> getData() {
        if (data.isEmpty()) {
            return PinYin.load() ? data : null;
        }
        return data;
    }

    public static ArrayList<String> getStrFirst(String text) {
        ArrayList<String> pinyin = new ArrayList<String>();
        pinyin.add("");
        for (int i = 0; i < text.length(); ++i) {
            pinyin = PinYin.addCharFirst(pinyin, text.charAt(i));
        }
        return pinyin;
    }

    private static ArrayList<String> addCharFirst(ArrayList<String> oldPinyin, char ch) {
        ArrayList<String> newPinyin = new ArrayList<String>();
        ArrayList<String> chPinyin = PinYin.getCharPinyin(ch);
        if (chPinyin.isEmpty()) {
            return oldPinyin;
        }
        for (String prefix : oldPinyin) {
            for (String suffix : chPinyin) {
                String str = prefix + suffix;
                if (newPinyin.contains(str)) continue;
                newPinyin.add(str);
            }
        }
        return newPinyin;
    }

    private static ArrayList<String> getCharPinyin(char ch) {
        ArrayList<String> pinyin = new ArrayList<String>();
        for (Char charObj : PinYin.getData()) {
            if (charObj.chinese != ch || charObj.spell == null || charObj.spell.length() <= 0) continue;
            pinyin.add(charObj.spell.toUpperCase().substring(0, 1));
        }
        return pinyin;
    }

    public static final class Char {
        public char chinese;
        public String spell;
        public byte tone;

        public Char(char chinese, String spell, byte tone) {
            this.chinese = chinese;
            this.spell = spell;
            this.tone = tone;
        }
    }
}

