/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.util.HashMap;

public class TagReplacer {
    private static final char[] CHARR_SPLIT = " =><!?)(][}{\t\n\r".toCharArray();

    public static String replace(String html, Replacer replacer) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < html.length()) {
            char ch = html.charAt(index);
            if (ch == '<') {
                int tagNameEndIndex;
                String tagName;
                int tagNameBeginIndex = TagReplacer.findNextChar(html, index + 1);
                boolean endTag = false;
                if (tagNameBeginIndex > 0) {
                    boolean bl = endTag = html.charAt(tagNameBeginIndex) == '/';
                    if (endTag) {
                        tagNameBeginIndex = TagReplacer.findNextChar(html, tagNameBeginIndex + 1);
                    }
                }
                if (tagNameBeginIndex > 0 && replacer.doreplace(tagName = html.substring(tagNameBeginIndex, tagNameEndIndex = TagReplacer.findWordEnd(html, tagNameBeginIndex)).toLowerCase())) {
                    int tagEndIndex = TagReplacer.indexOfNoneQuote(html, tagNameEndIndex, '>');
                    index = tagEndIndex + 1;
                    boolean doSkip = true;
                    if (!endTag) {
                        HashMap<String, String> attrs = TagReplacer.getAttrs(html, tagNameEndIndex, tagEndIndex);
                        String replaceHtml = replacer.replace(tagName, attrs);
                        if (replaceHtml != null) {
                            sb.append(replaceHtml);
                        } else {
                            doSkip = false;
                        }
                    }
                    if (doSkip) continue;
                }
            }
            sb.append(ch);
            ++index;
        }
        return sb.toString();
    }

    private static HashMap<String, String> getAttrs(String html, int start, int end) {
        int indexEnd;
        int indexStart;
        HashMap<String, String> attrs = new HashMap<String, String>();
        int index = start;
        while (index < end && (indexStart = TagReplacer.findNextChar(html, index)) >= 0 && (indexEnd = TagReplacer.findWordEnd(html, indexStart)) < end) {
            String attrValue;
            String attrName = html.substring(indexStart, indexEnd).toLowerCase();
            indexStart = TagReplacer.findNextChar(html, indexEnd);
            if (indexStart < 0) {
                attrs.put(attrName, null);
                break;
            }
            char ch = html.charAt(indexStart);
            if (ch != '=') {
                attrs.put(attrName, null);
                index = indexStart;
                continue;
            }
            if ((indexStart = TagReplacer.findNextChar(html, indexStart + 1)) < 0) {
                attrs.put(attrName, null);
                break;
            }
            ch = html.charAt(indexStart);
            if (ch == '\'' || ch == '\"') {
                if ((indexEnd = html.indexOf(ch, ++indexStart)) >= 0 && indexEnd < end) {
                    attrValue = html.substring(indexStart, indexEnd);
                    attrs.put(attrName, attrValue);
                    index = indexEnd + 1;
                    continue;
                }
                attrValue = html.substring(indexStart, end);
                attrs.put(attrName, attrValue);
                break;
            }
            for (indexEnd = indexStart; indexEnd < end && (ch = html.charAt(indexEnd)) != ' ' && ch != '>'; ++indexEnd) {
            }
            if (indexEnd < end) {
                attrValue = html.substring(indexStart, indexEnd);
                attrs.put(attrName, attrValue);
                index = indexEnd;
                continue;
            }
            attrValue = html.substring(indexStart, end);
            attrs.put(attrName, attrValue);
            break;
        }
        return attrs;
    }

    private static int indexOfNoneQuote(String source, int startIndex, char searchCh) {
        int index = startIndex;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '=' || ch == ' ' || ch == '\t' || ch == '\n' || ch == '_' || ch == '-' || ch == ':' || ch == '.') {
                ++index;
                continue;
            }
            if (searchCh == ch) {
                return index;
            }
            if (ch == '\"' || ch == '\'') {
                int match = source.indexOf(ch, index + 1);
                if (match < 0 || match >= source.length()) break;
                index = match + 1;
                continue;
            }
            ++index;
        }
        return -1;
    }

    private static boolean isWordChar(char ch) {
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == ':' || ch == '.') {
            return true;
        }
        for (int i = 0; i < CHARR_SPLIT.length; ++i) {
            if (ch != CHARR_SPLIT[i]) continue;
            return false;
        }
        return true;
    }

    private static int findNextChar(String source, int startIndex) {
        if (startIndex >= 0) {
            for (int i = startIndex; i < source.length(); ++i) {
                char ch = source.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
                return i;
            }
        }
        return -1;
    }

    private static int findWordEnd(String source, int startIndex) {
        if (startIndex >= 0) {
            for (int i = startIndex; i < source.length(); ++i) {
                if (TagReplacer.isWordChar(source.charAt(i))) continue;
                return i;
            }
        }
        return source.length();
    }

    public static abstract class Replacer {
        public abstract boolean doreplace(String var1);

        public abstract String replace(String var1, HashMap<String, String> var2);
    }
}

