/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import java.text.DecimalFormat;
import java.util.Date;

public class TimeMeter {
    private long timeStamp;

    public TimeMeter() {
        this.timeStamp = System.currentTimeMillis();
    }

    public TimeMeter(long ts) {
        this.timeStamp = ts;
    }

    public TimeMeter(Date d) {
        this.timeStamp = d.getTime();
    }

    public long get() {
        return this.timeStamp;
    }

    private String getPassStr(long ts) {
        String unit = "ms";
        double dts = ts;
        DecimalFormat format = new DecimalFormat("0.0");
        if (ts < 1000L) {
            return ts + unit;
        }
        dts /= 1000.0;
        unit = "s";
        if (dts < 60.0) {
            return format.format(dts) + unit;
        }
        dts /= 60.0;
        unit = "min(s)";
        if (dts < 60.0) {
            return format.format(dts) + unit;
        }
        dts /= 60.0;
        unit = "hour(s)";
        if (dts < 24.0) {
            return format.format(dts) + unit;
        }
        unit = "day(s)";
        return format.format(dts /= 24.0) + unit;
    }

    public String passStr() {
        return this.getPassStr(this.pass());
    }

    public String passStr(long ts) {
        return this.getPassStr(this.pass(ts));
    }

    public String passStr(Date d) {
        return this.getPassStr(this.pass(d));
    }

    public void mark() {
        this.timeStamp = System.currentTimeMillis();
    }

    public void mark(long ts) {
        this.timeStamp = ts;
    }

    public void mark(Date d) {
        this.timeStamp = d.getTime();
    }

    public long pass() {
        return System.currentTimeMillis() - this.timeStamp;
    }

    public long pass(long ts) {
        return ts - this.timeStamp;
    }

    public long pass(Date d) {
        return d.getTime() - this.timeStamp;
    }

    public boolean isAfter() {
        return this.timeStamp > System.currentTimeMillis();
    }

    public boolean isAfter(long ts) {
        return this.timeStamp > ts;
    }

    public boolean isAfter(Date d) {
        return this.timeStamp > d.getTime();
    }

    public boolean isBefore() {
        return this.timeStamp < System.currentTimeMillis();
    }

    public boolean isBefore(long ts) {
        return this.timeStamp < ts;
    }

    public boolean isBefore(Date d) {
        return this.timeStamp < d.getTime();
    }
}

