/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.tool.ToolImage;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class ZXingHelper {
    public static BufferedImage encodeQRCode(String content, int size, int correction) {
        return ZXingHelper.encodeQRCode(content, size, correction, ConstFramework.getCharsetName());
    }

    public static BufferedImage encodeQRCode(String content, int size, int correction, String charsetName) {
        try {
            String formatContent = new String(content.getBytes(charsetName), "ISO-8859-1");
            HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            if (correction >= 30) {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            } else if (correction >= 25) {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.Q);
            } else if (correction >= 15) {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            } else {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            }
            BitMatrix bitMatrix = new MultiFormatWriter().encode(formatContent, BarcodeFormat.QR_CODE, size, size, hints);
            return ToolImage.toNewRGB(MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decodeQRCode(BufferedImage img) {
        return ZXingHelper.decodeQRCode(img, ConstFramework.getCharsetName());
    }

    public static String decodeQRCode(BufferedImage img, String charsetName) {
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(img);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, charsetName);
            Result result = new MultiFormatReader().decode(bitmap, hints);
            return result.getText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage encodeBarcode(String content, int width, int height, BarcodeFormat format) {
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, format, width, height, null);
            return ToolImage.toNewRGB(MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static BufferedImage encodeEAN13(String content, int width, int height) {
        return ZXingHelper.encodeBarcode(content, width, height, BarcodeFormat.EAN_13);
    }

    public static BufferedImage encodeEAN8(String content, int width, int height) {
        return ZXingHelper.encodeBarcode(content, width, height, BarcodeFormat.EAN_8);
    }

    public static String createMod10Char(String str) {
        if (str == null) {
            return null;
        }
        int c1 = 0;
        int c2 = 0;
        int cc = 0;
        int c = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int num = 0;
            if (ch < '0' || ch > '9') {
                return null;
            }
            num = ch - 48;
            if (i % 2 == 0) {
                c1 += num;
                continue;
            }
            c2 += num;
        }
        cc = (c1 + (c2 *= 3)) % 10;
        c = (10 - cc) % 10;
        return Integer.toString(c);
    }

    public static String createStrEAN8(String str7) {
        if (str7 == null || str7.length() != 7) {
            return null;
        }
        return str7 + ZXingHelper.createMod10Char("00000" + str7);
    }

    public static String createStrEAN13(String str12) {
        if (str12 == null || str12.length() != 12) {
            return null;
        }
        return str12 + ZXingHelper.createMod10Char(str12);
    }

    public static String decodeBarcode(BufferedImage img) {
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(img);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Result result = new MultiFormatReader().decode(bitmap, null);
            return result.getText();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

