/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.json;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;

class JSONParser {
    private static final String ERR_OBJECT_NOT_BOOLEAN = "object can not be parse to boolean";
    private static final String ERR_OBJECT_NOT_CHAR = "object can not be parse to char";
    private static final String ERR_OBJECT_NOT_NUMBER = "object can not be parse to number";
    private static final String ERR_OBJECT_NOT_JSON_OBJECT = "object can not be parse to json object";
    private static final String ERR_OBJECT_NOT_JSON_ARRAY = "object can not be parse to json array";
    protected static final byte BOOLEAN_TURE_NUM = 1;
    protected static final byte BOOLEAN_FALSE_NUM = 0;
    protected static final boolean NULL_BOOLEAN = false;
    protected static final char NULL_CHAR = '\u0000';
    protected static final byte NULL_NUMBER = 0;

    JSONParser() {
    }

    public static boolean parseBoolean(Object obj) throws JSONException {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            try {
                return Boolean.parseBoolean((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue() != 0L;
        }
        throw new JSONException(ERR_OBJECT_NOT_BOOLEAN);
    }

    public static char parseChar(Object obj) throws JSONException {
        if (obj == null) {
            return '\u0000';
        }
        if (obj instanceof Number) {
            return (char)((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                String str = (String)obj;
                return str.isEmpty() ? (char)'\u0000' : str.charAt(0);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (char)((Boolean)obj != false ? 1 : 0);
        }
        throw new JSONException(ERR_OBJECT_NOT_CHAR);
    }

    public static byte parseByte(Object obj) throws JSONException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            try {
                return Byte.parseByte((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? (byte)1 : 0;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static short parseShort(Object obj) throws JSONException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? (short)1 : 0;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static int parseInteger(Object obj) throws JSONException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static long parseLong(Object obj) throws JSONException {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1L : 0L;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static float parseFloat(Object obj) throws JSONException {
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0f : 0.0f;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static double parseDouble(Object obj) throws JSONException {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception ex) {
                throw new JSONException(ex.getMessage());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        throw new JSONException(ERR_OBJECT_NOT_NUMBER);
    }

    public static String parseString(Object obj) throws JSONException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public static JSONObject parseJsonObject(Object obj) throws JSONException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        throw new JSONException(ERR_OBJECT_NOT_JSON_OBJECT);
    }

    public static JSONArray parseJsonArray(Object obj) throws JSONException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        throw new JSONException(ERR_OBJECT_NOT_JSON_ARRAY);
    }
}

