/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.json;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;

class JSONSolver {
    private int index;
    private char[] charArr;

    public JSONSolver(String source) throws JSONException {
        if (source == null || source.length() == 0) {
            throw new JSONException("no source string for JSONSolver()");
        }
        this.index = 0;
        this.charArr = source.toCharArray();
    }

    public HashMap<String, Object> solveJSONObject(boolean noException) throws JSONException {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        this.nextIndex();
        if (this.indexChSolve() != '{') {
            throw new JSONException("expected '{' at index " + this.index);
        }
        this.nextIndex();
        while (true) {
            if (this.indexCh() == '}') {
                ++this.index;
                break;
            }
            String name = this.solveName();
            this.nextIndex();
            if (this.indexChSolve() != ':') {
                throw new JSONException("expected ':' at index " + this.index);
            }
            this.nextIndex();
            Object value = this.solveObject(noException);
            if (rtn.containsKey(name)) {
                rtn.remove(name);
            }
            rtn.put(name, value);
            this.nextIndex();
            if (this.indexCh() != ',' && this.indexCh() != '}') {
                throw new JSONException("expected '}' or ',' at index " + this.index);
            }
            if (this.indexCh() == ',') {
                ++this.index;
            }
            this.nextIndex();
        }
        return rtn;
    }

    public ArrayList<Object> solveJSONArray(boolean noException) throws JSONException {
        ArrayList<Object> rtn = new ArrayList<Object>();
        this.nextIndex();
        if (this.indexChSolve() != '[') {
            throw new JSONException("expected '[' at index " + this.index);
        }
        this.nextIndex();
        while (true) {
            if (this.indexCh() == ']') {
                ++this.index;
                break;
            }
            Object value = this.solveObject(noException);
            rtn.add(value);
            this.nextIndex();
            if (this.indexCh() != ',' && this.indexCh() != ']') {
                throw new JSONException("expected ']' or ',' at index " + this.index);
            }
            if (this.indexCh() == ',') {
                ++this.index;
            }
            this.nextIndex();
        }
        return rtn;
    }

    private int solveUnicodeHex() throws JSONException {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val = val * 16 + JSONSolver.getHexCharVal(this.indexChSolve());
        }
        return val;
    }

    private String solveString() throws JSONException {
        StringBuilder sb = new StringBuilder();
        char quote = this.indexCh();
        if (quote != '\'' && quote != '\"') {
            throw new JSONException("expected \" or ' at index " + this.index);
        }
        ++this.index;
        while (this.index < this.charArr.length) {
            if (this.indexCh() == quote) {
                ++this.index;
                return sb.toString();
            }
            if (this.indexCh() == '\\') {
                ++this.index;
                if (this.indexCh() == '\'' || this.indexCh() == '\"' || this.indexCh() == '\\') {
                    sb.append(this.indexChSolve());
                    continue;
                }
                if (this.indexCh() == '/') {
                    sb.append(this.indexChSolve());
                    continue;
                }
                if (this.indexCh() == 'b') {
                    ++this.index;
                    sb.append("\b");
                    continue;
                }
                if (this.indexCh() == 'f') {
                    ++this.index;
                    sb.append("\f");
                    continue;
                }
                if (this.indexCh() == 'n') {
                    ++this.index;
                    sb.append("\n");
                    continue;
                }
                if (this.indexCh() == 'r') {
                    ++this.index;
                    sb.append("\r");
                    continue;
                }
                if (this.indexCh() == 't') {
                    ++this.index;
                    sb.append("\t");
                    continue;
                }
                if (this.indexCh() == 'u') {
                    ++this.index;
                    int chVal = this.solveUnicodeHex();
                    char unicodeCh = (char)chVal;
                    sb.append(unicodeCh);
                    continue;
                }
                throw new JSONException("unsolved escapes at index " + this.index);
            }
            sb.append(this.indexChSolve());
        }
        throw new JSONException("unexpected string end");
    }

    private Object solveNumber() throws JSONException {
        boolean isDouble = false;
        boolean isNegative = false;
        boolean isIndexNegative = false;
        int decimalCnt = 0;
        long partInteger = 0L;
        double partDecimal = 0.0;
        int partIndex = 0;
        int status = 0;
        if (this.matchStr("0x")) {
            this.index += "0x".length();
            StringBuilder sb = new StringBuilder();
            char ch = this.indexCh();
            while (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                sb.append(ch);
                ++this.index;
                ch = this.indexCh();
            }
            return Long.parseLong(sb.toString(), 16);
        }
        block10: while (status != -1) {
            char ch = this.indexCh();
            switch (status) {
                case 0: {
                    if (JSONSolver.isSymbol(ch)) {
                        isNegative = this.indexChSolve() == '-';
                        status = 1;
                        continue block10;
                    }
                    if (JSONSolver.isDigit(ch)) {
                        partInteger = partInteger * 10L + (long)(this.indexChSolve() - 48);
                        status = 2;
                        continue block10;
                    }
                    throw new JSONException("expect symbol or digit at index " + this.index);
                }
                case 1: {
                    if (JSONSolver.isDigit(ch)) {
                        partInteger = partInteger * 10L + (long)(this.indexChSolve() - 48);
                        status = 2;
                        continue block10;
                    }
                    throw new JSONException("expect digit at index " + this.index);
                }
                case 2: {
                    if (JSONSolver.isPoint(ch)) {
                        this.indexChSolve();
                        isDouble = true;
                        status = 3;
                        continue block10;
                    }
                    if (JSONSolver.isDigit(ch)) {
                        partInteger = partInteger * 10L + (long)(this.indexChSolve() - 48);
                        continue block10;
                    }
                    status = -1;
                    continue block10;
                }
                case 3: {
                    if (JSONSolver.isDigit(ch)) {
                        partDecimal += (double)(this.indexChSolve() - 48) / Math.pow(10.0, ++decimalCnt);
                        continue block10;
                    }
                    if (JSONSolver.isE(ch)) {
                        this.indexChSolve();
                        isDouble = true;
                        status = 4;
                        continue block10;
                    }
                    status = -1;
                    continue block10;
                }
                case 4: {
                    if (JSONSolver.isSymbol(ch)) {
                        isIndexNegative = this.indexChSolve() == '-';
                        status = 5;
                        continue block10;
                    }
                    if (JSONSolver.isDigit(ch)) {
                        partIndex = partIndex * 10 + (this.indexChSolve() - 48);
                        status = 6;
                        continue block10;
                    }
                    throw new JSONException("expect symbol or digit at index " + this.index);
                }
                case 5: {
                    if (JSONSolver.isDigit(ch)) {
                        partIndex = partIndex * 10 + (this.indexChSolve() - 48);
                        status = 6;
                        continue block10;
                    }
                    throw new JSONException("expect digit at index " + this.index);
                }
                case 6: {
                    if (JSONSolver.isDigit(ch)) {
                        partIndex = partIndex * 10 + (this.indexChSolve() - 48);
                        continue block10;
                    }
                    status = -1;
                    continue block10;
                }
            }
            throw new JSONException("solve number unknow status at index " + this.index);
        }
        if (isDouble) {
            partIndex = isIndexNegative ? -partIndex : partIndex;
            double value = ((double)partInteger + partDecimal) * Math.pow(10.0, partIndex);
            Double number = isNegative ? -value : value;
            return number;
        }
        Long number = new Long(isNegative ? -partInteger : partInteger);
        return number;
    }

    private Object solveObject(boolean noException) throws JSONException {
        Object rtn = null;
        this.nextIndex();
        char beginCh = this.indexCh();
        if (beginCh == '{') {
            HashMap<String, Object> data = this.solveJSONObject(noException);
            rtn = new JSONObject(data, noException);
        } else if (beginCh == '[') {
            ArrayList<Object> data = this.solveJSONArray(noException);
            rtn = new JSONArray(data);
        } else if (beginCh == '\'' || beginCh == '\"') {
            rtn = this.solveString();
        } else if (beginCh == '-' || beginCh >= '0' && beginCh <= '9') {
            rtn = this.solveNumber();
        } else {
            if (this.matchStr("true")) {
                this.index += "true".length();
                return Boolean.TRUE;
            }
            if (this.matchStr("false")) {
                this.index += "false".length();
                return Boolean.FALSE;
            }
            if (this.matchStr("null")) {
                this.index += "null".length();
                return null;
            }
        }
        if (rtn == null) {
            throw new JSONException("unsolved object at index " + this.index);
        }
        return rtn;
    }

    private String solveName() throws JSONException {
        this.nextIndex();
        char beginCh = this.indexCh();
        if (beginCh == '\'' || beginCh == '\"') {
            return this.solveString();
        }
        StringBuilder sb = new StringBuilder();
        char ch = beginCh;
        int startIndex = this.index;
        while (startIndex != this.index && ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '$' || ch == '_') {
            sb.append(ch);
            ++this.index;
            ch = this.indexCh();
        }
        return sb.toString();
    }

    private int nextIndex() throws JSONException {
        while (this.index < this.charArr.length) {
            if (this.indexCh() == '/') {
                if (this.matchStr("//")) {
                    this.index += 2;
                    while (this.index < this.charArr.length) {
                        if (this.indexCh() == '\n' || this.indexCh() == '\r') {
                            ++this.index;
                            break;
                        }
                        ++this.index;
                    }
                    if (this.index >= this.charArr.length) {
                        return -1;
                    }
                } else if (this.matchStr("/*")) {
                    this.index += 2;
                    while (this.index < this.charArr.length) {
                        if (this.matchStr("*/")) {
                            this.index += 2;
                            break;
                        }
                        ++this.index;
                    }
                    if (this.index >= this.charArr.length) {
                        return -1;
                    }
                }
            }
            if (this.indexCh() != ' ' && this.indexCh() != '\t' && this.indexCh() != '\n' && this.indexCh() != '\r') {
                return this.index;
            }
            ++this.index;
        }
        return -1;
    }

    private char indexCh() throws JSONException {
        return this.indexCh(0);
    }

    private char indexCh(int offset) throws JSONException {
        if (this.index + offset >= 0 && this.index + offset < this.charArr.length) {
            return this.charArr[this.index + offset];
        }
        throw new JSONException("unexpected json end");
    }

    private char indexChSolve() throws JSONException {
        if (this.index < this.charArr.length) {
            return this.charArr[this.index++];
        }
        throw new JSONException("unexpected json end");
    }

    private boolean matchStr(String str) throws JSONException {
        if (str == null || str.length() == 0) {
            return false;
        }
        if (this.charArr.length >= str.length() + this.index) {
            char[] tmpArr = str.toCharArray();
            for (int i = 0; i < tmpArr.length; ++i) {
                if (this.indexCh(i) == tmpArr[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int getHexCharVal(char ch) throws JSONException {
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new JSONException("expected hex char but get '" + ch + "'");
    }

    private static boolean isSymbol(char ch) {
        return ch == '+' || ch == '-';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isE(char ch) {
        return ch == 'e' || ch == 'E';
    }

    private static boolean isPoint(char ch) {
        return ch == '.';
    }
}

