/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.json;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;

class JSONWriter {
    private final StringBuilder writerBuff;
    private boolean simple = false;
    private boolean nonc = true;

    public JSONWriter() {
        this.writerBuff = new StringBuilder();
    }

    public JSONWriter(boolean simple) {
        this.simple = simple;
        this.writerBuff = new StringBuilder();
    }

    public JSONWriter(boolean simple, boolean nonc) {
        this.simple = simple;
        this.nonc = nonc;
        this.writerBuff = new StringBuilder();
    }

    public String getBuffString() {
        return this.writerBuff.toString();
    }

    public String toString() {
        return this.getBuffString();
    }

    protected void writeKey(String key) {
        if (this.simple) {
            this.writerBuff.append(key);
        } else {
            this.writeObj(key);
        }
    }

    protected void writeObj(Boolean obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Character obj) {
        this.writeObj(obj.toString());
    }

    protected void writeObj(Byte obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Short obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Integer obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Long obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Float obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(Double obj) {
        this.writerBuff.append(obj.toString());
    }

    protected void writeObj(String obj) {
        char[] chArr = obj.toCharArray();
        this.writerBuff.append(this.simple ? (char)'\'' : '\"');
        block11: for (char ch : chArr) {
            switch (ch) {
                case '\"': {
                    this.writerBuff.append(this.simple ? "\"" : "\\\"");
                    continue block11;
                }
                case '\'': {
                    this.writerBuff.append(this.simple ? "\\'" : "'");
                    continue block11;
                }
                case '\\': {
                    this.writerBuff.append("\\\\");
                    continue block11;
                }
                case '/': {
                    this.writerBuff.append("\\/");
                    continue block11;
                }
                case '\b': {
                    this.writerBuff.append("\\b");
                    continue block11;
                }
                case '\f': {
                    this.writerBuff.append("\\f");
                    continue block11;
                }
                case '\n': {
                    this.writerBuff.append("\\n");
                    continue block11;
                }
                case '\r': {
                    this.writerBuff.append("\\r");
                    continue block11;
                }
                case '\t': {
                    this.writerBuff.append("\\t");
                    continue block11;
                }
                default: {
                    if (this.nonc) {
                        this.writerBuff.append(ch);
                        continue block11;
                    }
                    if (ch >= '\u0000' && ch <= '\u007f') {
                        this.writerBuff.append(ch);
                        continue block11;
                    }
                    String uStr = Integer.toHexString(ch);
                    while (uStr.length() < 4) {
                        uStr = '0' + uStr;
                    }
                    this.writerBuff.append("\\u").append(uStr);
                }
            }
        }
        this.writerBuff.append(this.simple ? (char)'\'' : '\"');
    }

    protected void writeObj(Object obj) throws JSONException {
        if (obj == null) {
            this.writeJSONNull();
        } else if (obj instanceof Boolean) {
            this.writeObj((Boolean)obj);
        } else if (obj instanceof Character) {
            this.writeObj((Character)obj);
        } else if (obj instanceof Byte) {
            this.writeObj((Byte)obj);
        } else if (obj instanceof Short) {
            this.writeObj((Short)obj);
        } else if (obj instanceof Integer) {
            this.writeObj((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeObj((Long)obj);
        } else if (obj instanceof Float) {
            this.writeObj((Float)obj);
        } else if (obj instanceof Double) {
            this.writeObj((Double)obj);
        } else if (obj instanceof String) {
            this.writeObj((String)obj);
        } else if (obj instanceof JSONArray) {
            this.writeStr(((JSONArray)obj).toJsonString(this.simple, this.nonc));
        } else if (obj instanceof JSONObject) {
            this.writeStr(((JSONObject)obj).toJsonString(this.simple, this.nonc));
        } else if (obj instanceof ArrayList) {
            this.writeStr(new JSONArray((ArrayList)obj).toJsonString(this.simple, this.nonc));
        } else if (obj instanceof HashMap) {
            this.writeStr(new JSONObject((HashMap)obj).toJsonString(this.simple, this.nonc));
        } else {
            this.writeObj(obj.toString());
        }
    }

    protected void writeJSONObjectBegin() {
        this.writerBuff.append('{');
    }

    protected void writeJSONObjectEnd() {
        this.writerBuff.append('}');
    }

    protected void writeJSONArrayBegin() {
        this.writerBuff.append('[');
    }

    protected void writeJSONArrayEnd() {
        this.writerBuff.append(']');
    }

    protected void writeJSONComma() {
        this.writerBuff.append(',');
    }

    protected void writeJSONColon() {
        this.writerBuff.append(':');
    }

    protected void writeJSONNull() {
        this.writerBuff.append("null");
    }

    private void writeStr(String str) {
        this.writerBuff.append(str);
    }
}

