/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.listener;

import com.modnut.framework2.data.DataObj;
import com.modnut.framework2.listener.ListenerXBase;
import java.util.ArrayList;
import java.util.HashMap;

public class ListenerXPool {
    private static final HashMap<String, ListenerXBase> pool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has(String name) {
        HashMap<String, ListenerXBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.containsKey(name);
        }
    }

    public static boolean has(ListenerXBase listener) {
        return ListenerXPool.has(listener.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenerXBase add(ListenerXBase listener) {
        HashMap<String, ListenerXBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.put(listener.getName(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenerXBase remove(String name) {
        HashMap<String, ListenerXBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.remove(name);
        }
    }

    public static ListenerXBase remove(ListenerXBase listener) {
        return ListenerXPool.remove(listener.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenerXBase get(String name) {
        HashMap<String, ListenerXBase> hashMap = pool;
        synchronized (hashMap) {
            return pool.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<ListenerXBase> getListeners(String formName, String toName, String cmd) {
        ArrayList<ListenerXBase> listeners = new ArrayList<ListenerXBase>();
        HashMap<String, ListenerXBase> hashMap = pool;
        synchronized (hashMap) {
            for (ListenerXBase listener : pool.values()) {
                if (toName != null && !toName.equals(listener.getName()) || !listener.accept(formName, toName, cmd)) continue;
                listeners.add(listener);
            }
        }
        return listeners;
    }

    public static DataObj[] call(String formName, String toName, String cmd, DataObj param) {
        ArrayList<ListenerXBase> listeners = ListenerXPool.getListeners(formName, toName, cmd);
        ArrayList<DataObj> results = new ArrayList<DataObj>();
        for (ListenerXBase listener : listeners) {
            results.add(listener.send(formName, toName, cmd, param));
        }
        return results.toArray(new DataObj[results.size()]);
    }

    public static int doCall(String formName, String toName, String cmd, DataObj param, ListenerXBase.ListenerXCallback callback) {
        ArrayList<ListenerXBase> listeners = ListenerXPool.getListeners(formName, toName, cmd);
        for (ListenerXBase listener : listeners) {
            listener.doSend(formName, toName, cmd, param, callback);
        }
        return listeners.size();
    }
}

