/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.memcache;

import com.modnut.framework2.memcache.MemClient;
import com.modnut.framework2.memcache.MemConn;
import com.modnut.framework2.memcache.MemJava;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemPool {
    private static final HashMap<String, String> configs = new HashMap();
    private static final HashMap<String, MemConn> pool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has(String name) {
        HashMap<String, MemConn> hashMap = pool;
        synchronized (hashMap) {
            return pool.containsKey(name);
        }
    }

    public static boolean init(String name, String configStr) {
        return MemPool.init(name, configStr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init(String name, String configStr, boolean overwrite) {
        HashMap<String, Object> hashMap = configs;
        synchronized (hashMap) {
            if (configs.containsKey(name) && !overwrite) {
                return false;
            }
        }
        hashMap = pool;
        synchronized (hashMap) {
            if (pool.containsKey(name)) {
                MemPool.destroy(name);
            }
        }
        if (configStr != null) {
            hashMap = configs;
            synchronized (hashMap) {
                configs.put(name, configStr);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(String name) {
        HashMap<String, Object> hashMap = configs;
        synchronized (hashMap) {
            if (configs.containsKey(name)) {
                configs.remove(name);
            }
        }
        hashMap = pool;
        synchronized (hashMap) {
            MemConn conn = pool.get(name);
            if (conn != null) {
                conn.close();
                pool.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemConn getNewConn(String name) {
        boolean contains;
        HashMap<String, String> hashMap = configs;
        synchronized (hashMap) {
            contains = configs.containsKey(name);
        }
        if (contains) {
            try {
                String config;
                HashMap<String, String> hashMap2 = configs;
                synchronized (hashMap2) {
                    config = configs.get(name);
                }
                return new MemClient(config);
            }
            catch (IOException ex) {
                Logger.getLogger(MemPool.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return new MemJava();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemConn getConn(String name) {
        boolean contains;
        HashMap<String, MemConn> hashMap = pool;
        synchronized (hashMap) {
            contains = pool.containsKey(name);
        }
        if (contains) {
            hashMap = pool;
            synchronized (hashMap) {
                return pool.get(name);
            }
        }
        MemConn conn = MemPool.getNewConn(name);
        if (conn != null) {
            HashMap<String, MemConn> hashMap2 = pool;
            synchronized (hashMap2) {
                pool.put(name, conn);
            }
        }
        return conn;
    }
}

