/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.message;

import com.modnut.framework2.message.MessageObj;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MessageQueue<CO extends MessageObj> {
    private static final long DEFAULT_TIMEOUT = 300000L;
    private static final long MIN_TIMEOUT = 1000L;
    private static final long DEFAULT_DT = 60000L;
    private static final long MIN_DT = 1000L;
    private final AtomicInteger counter;
    private final AtomicLong last;
    private final long timeout;
    private final long dt;
    private final ArrayList<CO> list = new ArrayList();

    public MessageQueue() {
        this.counter = new AtomicInteger(0);
        this.last = new AtomicLong(System.currentTimeMillis());
        this.timeout = 300000L;
        this.dt = 60000L;
    }

    public MessageQueue(long expiry) {
        this.counter = new AtomicInteger(0);
        this.last = new AtomicLong(System.currentTimeMillis());
        this.timeout = Math.max(expiry, 1000L);
        this.dt = 60000L;
    }

    public MessageQueue(long timeout, long dt) {
        this.counter = new AtomicInteger(0);
        this.last = new AtomicLong(System.currentTimeMillis());
        this.timeout = Math.max(timeout, 1000L);
        this.dt = Math.max(dt, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = System.currentTimeMillis();
            long old = this.last.get();
            if (old + this.dt < now && this.last.compareAndSet(old, now)) {
                Iterator<CO> iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    MessageObj msg = (MessageObj)iterator.next();
                    if (!msg.before(now - this.timeout, 0L)) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CO newMsg) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.remove();
            if (newMsg != null) {
                ((MessageObj)newMsg).update();
                this.list.add(newMsg);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CO> listen(long timestamp, long timenano, long timeout) {
        ArrayList<MessageObj> result = new ArrayList<MessageObj>();
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            MessageObj msg;
            this.remove();
            if (this.list.isEmpty() || !((MessageObj)this.list.get(this.list.size() - 1)).after(timestamp, timenano)) {
                this.counter.incrementAndGet();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.counter.decrementAndGet();
                }
            }
            for (int i = this.list.size() - 1; i >= 0 && (msg = (MessageObj)this.list.get(i)).after(timestamp, timenano); --i) {
                result.add(0, msg);
            }
        }
        return result;
    }

    public int count() {
        return this.counter.get();
    }
}

