/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.page;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.constant.ConstUrlBase;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class PageBase<RC extends ResServlet> {
    protected static final String WAP_DOCTYPE = "html PUBLIC \"-//WAPFORUM//DTD XHTML Mobile 1.0//EN\" \"http://www.wapforum.org/DTD/xhtml-mobile10.dtd\"";
    private RC res;
    private ArrayList<String> cssFiles;
    private ArrayList<String> cssCode;
    private ArrayList<String> jsFiles;
    private ArrayList<String> jsCode;

    public void setRes(RC res) {
        this.res = res;
    }

    public RC getRes() {
        return this.res;
    }

    public void doInit() {
    }

    public void doDispose() {
    }

    public abstract String getPageTitle();

    public abstract void printPageBody(PrintWriter var1);

    public void addCssFile(String url) {
        if (this.cssFiles == null) {
            this.cssFiles = new ArrayList();
        }
        if (!this.cssFiles.contains(url)) {
            this.cssFiles.add(url);
        }
    }

    public void addCssFile(ConstUrlBase urlBase, String url) {
        this.addCssFile(urlBase.jointBaseCss(url));
    }

    public void addCssCode(String code) {
        if (this.cssCode == null) {
            this.cssCode = new ArrayList();
        }
        this.cssCode.add(code);
    }

    public void addJsFile(String url) {
        if (this.jsFiles == null) {
            this.jsFiles = new ArrayList();
        }
        if (!this.jsFiles.contains(url)) {
            this.jsFiles.add(url);
        }
    }

    public void addJsFile(ConstUrlBase urlBase, String url) {
        this.addJsFile(urlBase.jointBaseJs(url));
    }

    public void addJsCode(String code) {
        if (this.jsCode == null) {
            this.jsCode = new ArrayList();
        }
        this.jsCode.add(code);
    }

    private static String fixVersionHref(String href, String version) {
        return href + (href.indexOf(63) >= 0 ? "&" : "?") + ConstFramework.CODE_VERSION;
    }

    private static String buildCssTag(String href) {
        return "<link rel=\"stylesheet\" href=\"" + PageBase.fixVersionHref(href, ConstFramework.CODE_VERSION) + "\" type=\"text/css\"/>";
    }

    private static String buildCssCodeTag(String code) {
        return "<style type=\"text/css\">" + code + "</style>";
    }

    private static String buildJavascriptTag(String src) {
        return "<script src=\"" + PageBase.fixVersionHref(src, ConstFramework.CODE_VERSION) + "\" type=\"text/javascript\"></script>";
    }

    private static String buildJavaScriptCodeTag(String code) {
        return "<script type=\"text/javascript\">" + code + "</script>";
    }

    protected String getIconHref() {
        return null;
    }

    protected String getHtmlLang() {
        return null;
    }

    protected String getDocType() {
        return null;
    }

    protected String getBodyClassName() {
        return null;
    }

    protected boolean setViewPort() {
        return false;
    }

    protected void printAddonHeadDom(PrintWriter out) {
        if (this.setViewPort()) {
            out.print("<meta name=\"viewport\" content=\"user-scalable=no, initial-scale=1.0, maximum-scale=1.0, width=device-width\">");
        }
    }

    protected void printAddonBodyDom(PrintWriter out) {
    }

    public void printPage(PrintWriter out) {
        String docType = this.getDocType();
        out.print("<!DOCTYPE " + (docType == null ? "html" : docType) + ">");
        String lang = this.getHtmlLang();
        out.print(lang == null ? "<html>" : "<html lang=\"" + lang + "\">");
        out.print("<head>");
        out.print("<meta charset=\"" + ((ResPack)this.getRes()).getCharsetName() + "\" />");
        out.print("<title>" + this.getPageTitle() + "</title>");
        String iconHref = this.getIconHref();
        if (iconHref != null) {
            out.print("<link rel=\"shortcut icon\" href=\"" + iconHref + "\" />");
        }
        if (this.cssFiles != null) {
            for (String cssHref : this.cssFiles) {
                out.print(PageBase.buildCssTag(cssHref));
            }
        }
        if (this.cssCode != null) {
            for (String codeStr : this.cssCode) {
                out.print(PageBase.buildCssCodeTag(codeStr));
            }
        }
        this.printAddonHeadDom(out);
        out.print("</head>");
        String bodyClassName = this.getBodyClassName();
        if (bodyClassName == null) {
            out.print("<body>");
        } else {
            out.print("<body class=\"" + bodyClassName + "\">");
        }
        this.printPageBody(out);
        if (this.jsFiles != null) {
            for (String jsSrc : this.jsFiles) {
                out.print(PageBase.buildJavascriptTag(jsSrc));
            }
        }
        if (this.jsCode != null) {
            for (String codeStr : this.jsCode) {
                out.print(PageBase.buildJavaScriptCodeTag(codeStr));
            }
        }
        this.printAddonBodyDom(out);
        out.print("</body>");
        out.print("</html>");
    }
}

