/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.resource;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.database.DBConn;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBPool;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.memcache.MemConn;
import com.modnut.framework2.memcache.MemPool;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class ResPack {
    private final long timeStamp = System.currentTimeMillis();
    private HashMap<String, Object> varPool = null;
    private HashMap<String, DBStat> dbStatPool;
    private HashMap<String, DBConn> dbConnPool;

    public void disposeRes() {
        Set<String> keys;
        int cnt;
        this.printMsg("dispose resources...");
        if (this.varPool != null) {
            this.varPool.clear();
        }
        if (this.dbStatPool != null) {
            cnt = 0;
            keys = this.dbStatPool.keySet();
            for (String key : keys) {
                DBStat.close(this.dbStatPool.get(key));
                ++cnt;
            }
            this.dbStatPool = null;
            this.printMsg("dispose " + cnt + " statement(s)...");
        }
        if (this.dbConnPool != null) {
            cnt = 0;
            keys = this.dbConnPool.keySet();
            for (String key : keys) {
                DBConn.close(this.dbConnPool.get(key));
                ++cnt;
            }
            this.dbConnPool = null;
            this.printMsg("dispose " + cnt + " connection(s)...");
        }
        long costTime = System.currentTimeMillis() - this.timeStamp;
        this.printMsg("cost time " + costTime + " ms");
    }

    private HashMap<String, Object> getVarPool() {
        if (this.varPool == null) {
            this.varPool = new HashMap();
        }
        return this.varPool;
    }

    public boolean hasVar(String key) {
        return this.getVarPool().containsKey(key);
    }

    public Object removeVar(String key) {
        return this.getVarPool().remove(key);
    }

    public Object putVar(String key, Object obj) {
        return this.getVarPool().put(key, obj);
    }

    public void clearVars() {
        this.getVarPool().clear();
    }

    public Object getVar(String key) {
        return this.getVarPool().get(key);
    }

    public boolean getVarBoolean(String key, boolean defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue() != 0L;
        }
        if (obj instanceof String) {
            try {
                return Boolean.parseBoolean((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public char getVarChar(String key, char defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return (char)((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                String str = (String)obj;
                return str.isEmpty() ? defaultVal : str.charAt(0);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public byte getVarByte(String key, byte defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            try {
                return Byte.parseByte((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public short getVarShort(String key, short defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public int getVarInt(String key, int defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public long getVarLong(String key, long defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public float getVarFloat(String key, float defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public double getVarDouble(String key, double defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public String getVarString(String key, String defaultVal) {
        Object obj = this.getVar(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public MemConn getMemConn(String memName) {
        return MemPool.getConn(memName);
    }

    public DBStat getDBStat(String dbName) throws DBException {
        DBStat stat;
        if (this.dbStatPool == null) {
            this.dbStatPool = new HashMap();
        }
        if (this.dbStatPool.containsKey(dbName)) {
            DBStat statOld = this.dbStatPool.get(dbName);
            if (statOld != null && !statOld.isClosed()) {
                return statOld;
            }
            this.dbStatPool.remove(dbName);
        }
        if ((stat = DBPool.getNewStat(dbName)) != null) {
            this.dbStatPool.put(dbName, stat);
        }
        return stat;
    }

    public DBConn getDBConn(String dbName) throws DBException {
        DBConn conn;
        if (this.dbConnPool == null) {
            this.dbConnPool = new HashMap();
        }
        if (this.dbConnPool.containsKey(dbName)) {
            DBConn connOld = this.dbConnPool.get(dbName);
            if (connOld != null && !connOld.isClosed()) {
                return connOld;
            }
            this.dbConnPool.remove(dbName);
        }
        if ((conn = DBPool.getNewConn(dbName)) != null) {
            this.dbConnPool.put(dbName, conn);
        }
        return conn;
    }

    public void printMsg(String msg) {
        if (ConstFramework.getDebug()) {
            System.out.println(new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss]").format(new Date()) + msg);
        }
    }

    public Charset getCharset() {
        return ConstFramework.getCharset();
    }

    public String getCharsetName() {
        return this.getCharset().name();
    }
}

