/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.ajax.AjaxCmdBase;
import com.modnut.framework2.ajax.AjaxCmdException;
import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.json.JSONObject;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import com.modnut.framework2.tool.ToolClass;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;

public abstract class ServletAjaxCmdSolver<RC extends ResServlet>
extends ServletSolver<RC> {
    public static final String DEFAULT_URL = "/cmd";
    public static final String LISTEN_URL = "/listen";
    public static final String API_URL = "/api";
    public static final String URL_PATTERN = "/*";
    public static final long DEBUG_DELAY = 1500L;

    public ServletAjaxCmdSolver(RC res) {
        super(res);
    }

    @Override
    protected void setResponseContentType() {
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Type", "text/plain");
        ((ResServlet)this.getRes()).getResponse().setContentType("text/plain;charset=" + ((ResPack)this.getRes()).getCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSolve() throws ServletException {
        if (ConstFramework.getDebug()) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ServletAjaxCmdSolver.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        PrintWriter out = ((ResServlet)this.getRes()).getWriter();
        try {
            try {
                AjaxCmdBase ajax = this.build(((ResServlet)this.getRes()).getPathInfo());
                ajax.setRes(this.getRes());
                ajax.doInit();
                String outStr = ajax.put("code", ajax.getCode()).toString();
                ajax.doDispose();
                out.print(outStr);
            }
            catch (AjaxCmdException ex) {
                JSONObject error = new JSONObject();
                error.put("code", ex.code);
                error.put("msg", ex.msg);
                out.print(error.toString());
            }
        }
        finally {
            out.close();
        }
    }

    private AjaxCmdBase build(String pathInfo) throws AjaxCmdException {
        try {
            String ajaxName = null;
            if (pathInfo == null || !pathInfo.startsWith("/")) {
                throw new AjaxCmdException(-1, "ajax name path missing");
            }
            ajaxName = pathInfo.substring(1).replace('/', '.');
            Class<?> ajaxClass = this.forName(ajaxName);
            if (ajaxClass != null && ToolClass.baseOfClass(ajaxClass, AjaxCmdBase.class)) {
                return (AjaxCmdBase)ajaxClass.newInstance();
            }
            throw new AjaxCmdException(-1, "ajax name not accept");
        }
        catch (AjaxCmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AjaxCmdException(-1, ex.getMessage());
        }
    }

    protected abstract Class<?> forName(String var1) throws ClassNotFoundException;
}

