/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;

public abstract class ServletSolver<RC extends ResServlet> {
    private final RC res;

    public ServletSolver(RC res) {
        this.res = res;
    }

    public RC getRes() {
        return this.res;
    }

    public void doInit() throws ServletException {
        this.setRequestCharacterEncoding();
        this.setResponseContentType();
        this.setResponseCache();
    }

    public abstract void doSolve() throws ServletException;

    public void doDispose() throws ServletException {
    }

    public void doException(ServletException ex) throws ServletException {
        throw ex;
    }

    protected void setRequestCharacterEncoding() throws ServletException {
        try {
            String reqCharset = ((ResServlet)this.getRes()).getRequest().getHeader("Charset");
            ((ResServlet)this.getRes()).getRequest().setCharacterEncoding(reqCharset == null ? ((ResPack)this.getRes()).getCharsetName() : reqCharset);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ServletSolver.class.getName()).log(Level.SEVERE, null, ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected void setResponseContentType() {
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Type", this.getContentType());
        ((ResServlet)this.getRes()).getResponse().setContentType(this.getContentType() + ";charset=" + ((ResPack)this.getRes()).getCharset());
    }

    protected String getContentType() {
        return "text/html";
    }

    protected void setResponseCache() throws ServletException {
        long ct = this.getCacheTime();
        if (ct <= 0L) {
            ((ResServlet)this.getRes()).getResponse().setHeader("Cache-Control", "no-cache");
            ((ResServlet)this.getRes()).getResponse().setHeader("Pragma", "no-cache");
            ((ResServlet)this.getRes()).getResponse().setDateHeader("Expires", 0L);
        } else {
            long now = System.currentTimeMillis();
            ((ResServlet)this.getRes()).getResponse().addHeader("Cache-Control", "max-age=" + ct / 1000L);
            ((ResServlet)this.getRes()).getResponse().setDateHeader("Last-Modified", now);
            ((ResServlet)this.getRes()).getResponse().setDateHeader("Expires", now + ct);
        }
    }

    protected long getCacheTime() {
        return -1L;
    }
}

