/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Part;

public abstract class ServletUploadSolver<RC extends ResServlet>
extends ServletSolver<RC> {
    private static final String DISPOSITION_NAME = "name";
    private static final String DISPOSITION_FILENAME = "filename";

    public ServletUploadSolver(RC res) {
        super(res);
    }

    @Override
    public void doSolve() throws ServletException {
        try {
            Collection parts = ((ResServlet)this.getRes()).getRequest().getParts();
            this.beginSolve();
            for (Part part : parts) {
                this.partSolve(new PartWrap(part));
                if (this.multiple()) continue;
                break;
            }
            this.endSolve();
        }
        catch (IOException ex) {
            Logger.getLogger(ServletUploadSolver.class.getName()).log(Level.SEVERE, null, ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected boolean multiple() {
        return false;
    }

    protected void beginSolve() {
    }

    protected abstract void partSolve(PartWrap var1);

    protected void endSolve() {
    }

    protected static class PartWrap {
        private Part part;
        private HashMap<String, String> contentDisposition;

        public PartWrap(Part part) {
            this.part = part;
        }

        public Part getOrigin() {
            return this.part;
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public void write(String fileName) throws IOException {
            this.part.write(fileName);
        }

        public void delete() throws IOException {
            this.part.delete();
        }

        public long getSize() {
            return this.part.getSize();
        }

        public String getContentDisposition(ResServlet res, String name) {
            if (this.contentDisposition == null) {
                this.contentDisposition = new HashMap();
                String disposition = this.part.getHeader("content-disposition");
                if (disposition != null) {
                    char[] chArr = disposition.toCharArray();
                    SCAN_STATUS status = SCAN_STATUS.BEGIN_NAME;
                    StringBuilder buff = null;
                    String nameBuff = null;
                    block7: for (int i = 0; i < chArr.length; ++i) {
                        char ch = chArr[i];
                        switch (status) {
                            case BEGIN_NAME: {
                                buff = new StringBuilder();
                                buff.append(ch);
                                status = SCAN_STATUS.SOLVE_NAME;
                                continue block7;
                            }
                            case SOLVE_NAME: {
                                if (ch == '=') {
                                    nameBuff = buff.toString();
                                    status = SCAN_STATUS.BEGIN_VAL;
                                    continue block7;
                                }
                                if (ch == ';') {
                                    this.contentDisposition.put(buff.toString().trim(), null);
                                    status = SCAN_STATUS.BEGIN_NAME;
                                    continue block7;
                                }
                                buff.append(ch);
                                continue block7;
                            }
                            case BEGIN_VAL: {
                                if (ch != '\"') continue block7;
                                buff = new StringBuilder();
                                status = SCAN_STATUS.SOLVE_VAL;
                                continue block7;
                            }
                            case SOLVE_VAL: {
                                if (ch == '\"') {
                                    String valBuff = buff.toString();
                                    this.contentDisposition.put(nameBuff.trim(), valBuff.trim());
                                    status = SCAN_STATUS.END_VAL;
                                    continue block7;
                                }
                                buff.append(ch);
                                continue block7;
                            }
                            case END_VAL: {
                                if (ch != ';') continue block7;
                                status = SCAN_STATUS.BEGIN_NAME;
                            }
                        }
                    }
                }
            }
            return this.contentDisposition.get(name);
        }

        public String getName(ResServlet res) {
            return this.getContentDisposition(res, ServletUploadSolver.DISPOSITION_NAME);
        }

        public String getFileName(ResServlet res) {
            String filename = this.getContentDisposition(res, ServletUploadSolver.DISPOSITION_FILENAME);
            if (filename != null) {
                int dir1 = 92;
                int dir2 = 47;
                int searchIndex = filename.lastIndexOf(dir1);
                filename = filename.substring(searchIndex + 1);
                searchIndex = filename.lastIndexOf(dir2);
                filename = filename.substring(searchIndex + 1);
                return filename;
            }
            return filename;
        }
    }

    private static enum SCAN_STATUS {
        BEGIN_NAME,
        SOLVE_NAME,
        BEGIN_VAL,
        SOLVE_VAL,
        END_VAL;

    }
}

