/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.extend.DomParser;
import com.modnut.framework2.extend.HttpClient;
import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletBase;
import com.modnut.framework2.servlet.ServletSolver;
import com.modnut.framework2.str.StrConvert;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.framework2.tool.ToolStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletWX<RC extends ResServlet>
extends ServletBase<RC> {
    public static final String DEFAULT_URL = "/weixin";
    public static final String URL_PATTERN = "/*";
    public static final String PATTERN_OAUTH = "/oauth";
    public static final String PATTERN_CONFIG_JS = "/config.js";
    public static final String PATTERN_MESSAGE = "/message";
    public static final String SESSION_WXOPENID = "wxopenid";
    public static final int QRCODE_EXPIRY_MAX = 2592000;
    public static final int QRCODE_ID_MAX = 100000;
    private static final String PARAM_DEBUG = "debug";
    private static final String PARAM_LIST = "list";
    private static final String PARAM_SIGNATURE = "signature";
    private static final String PARAM_TIMESTAMP = "timestamp";
    private static final String PARAM_NONCE = "nonce";
    private static final String PARAM_ECHOSTR = "echostr";
    private static final int MAX_PART = 1000;

    @Override
    protected abstract RC createRes(HttpServletRequest var1, HttpServletResponse var2);

    @Override
    protected ServletSolver getSolver(RC res) {
        return new ServletSolver<RC>((ResServlet)res){

            @Override
            public void doException(ServletException ex) throws ServletException {
                if (ex instanceof WXPageException) {
                    PrintWriter out = ((ResServlet)this.getRes()).getWriter();
                    try {
                        out.print(((WXPageException)ex).getDom());
                    }
                    finally {
                        out.close();
                    }
                    return;
                }
                super.doException(ex);
            }

            @Override
            protected long getCacheTime() {
                return 0L;
            }

            @Override
            protected String getContentType() {
                String pattern = ServletWX.this.getCore(this.getRes()).getPattern(this.getRes());
                if (pattern != null && pattern.equals(ServletWX.PATTERN_CONFIG_JS)) {
                    return "text/javascript";
                }
                return super.getContentType();
            }

            @Override
            public void doSolve() throws ServletException {
                String pattern = ServletWX.this.getCore(this.getRes()).getPattern(this.getRes());
                if (pattern != null) {
                    if (pattern.equals(ServletWX.PATTERN_OAUTH)) {
                        ServletWX.this.getCore(this.getRes()).handleOAuth(this.getRes());
                        return;
                    }
                    if (pattern.equals(ServletWX.PATTERN_CONFIG_JS)) {
                        ServletWX.this.getCore(this.getRes()).handleConfigJs(this.getRes());
                        return;
                    }
                    if (pattern.equals(ServletWX.PATTERN_MESSAGE)) {
                        if (ServletWX.this.getCore(this.getRes()).fromWeixin(this.getRes())) {
                            ServletWX.this.getCore(this.getRes()).handleMessage(this.getRes());
                        }
                        return;
                    }
                }
                throw new WXPageException("\u672a\u77e5\u63a5\u53e3", "\u8bf7\u6c42\u63a5\u53e3\u65e0\u6cd5\u5904\u7406");
            }
        };
    }

    protected abstract WXCore getCore(RC var1);

    private static void log(boolean debug, String ... msgs) {
        if (debug) {
            for (String msg : msgs) {
                System.out.println(ToolDate.format(ToolDate.now(), "[yyyy-MM-DD HH:mm:ss]") + msg);
            }
        }
    }

    public static class WXPageException
    extends ServletException {
        public String title;
        public String content;

        public WXPageException(String title, String content) {
            this.title = title;
            this.content = content;
        }

        public String getDom() {
            return "<!DOCTYPE html><html><head><meta charset=\"UTF-8\" /><title>" + this.title + "</title><style type=\"text/css\">*{margin:0;padding:0;}html{background:#eee;color:#555;text-shadow:#fff 0 1px;font-size:14px;font-family:\"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;}html,body{width:100%;height:100%;}a,a:visited{color:#333;text-decoration:underline;}a:hover{text-decoration:none;}.centerxy{width:100%;height:100%;border:none;}.centerxy tr{border:none;}.centerxy td{border:none;text-align:center;}.title{padding:5px;font-size:24px;font-weight:bold;color:#333;}.content{padding:5px;font-size:14px;font-weight:bold;color:#999;}</style><meta name=\"viewport\" content=\"user-scalable=no, initial-scale=1.0, maximum-scale=1.0, width=device-width\"></head><body><table class=\"centerxy\"><tbody><tr><td><div class=\"title\">" + this.title + "</div><div class=\"content\">" + this.content + "</div></td></tr></tbody></table></body></html>";
        }
    }

    public static class WXApiException
    extends Exception {
        public String text;

        public WXApiException(String msg) {
            this.text = msg;
        }
    }

    public static class WXUser {
        public boolean subscribe;
        public String openid;
        public String nickname;
        public String sex;
        public String language;
        public String province;
        public String city;
        public String country;
        public String headImgUrl;
        public long subscribeTime;
        public String unionid;

        public static WXUser fromJson1(JSONObject json) throws JSONException {
            WXUser wxuser = new WXUser();
            wxuser.subscribe = json.getBoolean("subscribe");
            if (wxuser.subscribe) {
                wxuser.openid = json.getString("openid");
                wxuser.nickname = json.getString("nickname");
                wxuser.sex = json.getString("sex");
                wxuser.language = json.getString("language");
                wxuser.city = json.getString("city");
                wxuser.province = json.getString("province");
                wxuser.country = json.getString("country");
                wxuser.headImgUrl = json.getString("headimgurl");
                wxuser.subscribeTime = json.getLong("subscribe_time") * 1000L;
                wxuser.unionid = json.getString("unionid");
            }
            return wxuser;
        }

        public static WXUser fromJson2(JSONObject json) throws JSONException {
            WXUser wxuser = new WXUser();
            wxuser.subscribe = false;
            wxuser.openid = json.getString("openid");
            wxuser.nickname = json.getString("nickname");
            wxuser.sex = json.getString("sex");
            wxuser.language = null;
            wxuser.city = json.getString("city");
            wxuser.province = json.getString("province");
            wxuser.country = json.getString("country");
            wxuser.headImgUrl = json.getString("headimgurl");
            wxuser.subscribeTime = 0L;
            wxuser.unionid = json.getString("unionid");
            return wxuser;
        }

        public String toString() {
            return this.openid + " : " + this.nickname;
        }
    }

    public static class WXQrcode {
        public String ticket;
        public String url;
        public int expireSeconds;

        public String getImageUrl() {
            return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ToolStr.URLEncode(this.ticket);
        }

        public static WXQrcode fromJson(JSONObject json) throws JSONException {
            WXQrcode qrcode = new WXQrcode();
            qrcode.ticket = json.getString("ticket");
            qrcode.url = json.getString("url");
            qrcode.expireSeconds = json.getInteger("expire_seconds");
            return qrcode;
        }
    }

    public static class WXIp {
        public long ip;
        public int mask;

        public WXIp(String str) {
            int index = str.indexOf(47);
            this.ip = 0L;
            if (index >= 0) {
                this.mask = ToolStr.parseInt(str.substring(index + 1), 0);
                str = str.substring(0, index);
            } else {
                this.mask = 0;
            }
            while ((index = str.indexOf(46)) >= 0) {
                this.ip = this.ip * 256L + (long)ToolStr.parseInt(str.substring(0, index), 0);
                str = str.substring(index + 1);
            }
            this.ip = this.ip * 256L + (long)ToolStr.parseInt(str, 0);
        }

        public boolean match(String str) {
            WXIp wxip = new WXIp(str);
            long val1 = this.ip;
            long val2 = wxip.ip;
            if (this.mask > 0 && this.mask < 32) {
                int move = 32 - this.mask;
                val1 >>>= move;
                val2 >>>= move;
            }
            return val1 == val2;
        }
    }

    public static abstract class WXCore<RC extends ResServlet> {
        public final HttpClient client = new HttpClient();
        public final ArrayList<WXIp> ips = new ArrayList();
        public String accessToken = null;
        public long expiryToken = 0L;
        public String apiTicket = null;
        public long expiryTicket = 0L;
        public static final String EVENT_SUBSCRIBE = "subscribe";
        public static final String EVENT_UNSUBSCRIBE = "unsubscribe";
        public static final String EVENT_CLICK = "click";
        public static final String EVENT_SCAN = "scan";
        public static final String EVENT_VIEW = "view";

        public abstract String getHost();

        public abstract String getContext();

        public String getPath() {
            return ServletWX.DEFAULT_URL;
        }

        public boolean getDebug() {
            return false;
        }

        public abstract String getToken();

        public abstract String getAppId();

        public abstract String getAppSecret();

        public String getPattern(RC res) {
            return ((ResServlet)res).getPathInfo();
        }

        public String getMchId() {
            return null;
        }

        public String getMchKey() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAccessToken() {
            WXCore wXCore = this;
            synchronized (wXCore) {
                long now = ToolDate.now();
                if (this.expiryToken < now) {
                    String newAccessToken = null;
                    long newExpiryToken = now;
                    HttpClient.HttpClientResponse response = this.client.get("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.getAppId() + "&secret=" + this.getAppSecret(), null);
                    if (response.code == 200) {
                        try {
                            JSONObject json = new JSONObject(response.text);
                            if (json.has("access_token")) {
                                newAccessToken = json.getString("access_token");
                            }
                            if (json.has("expires_in")) {
                                long expiryIn = json.getLong("expires_in") * 1000L;
                                newExpiryToken = now + expiryIn;
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (newAccessToken == null) {
                        return null;
                    }
                    this.accessToken = newAccessToken;
                    this.expiryToken = newExpiryToken;
                }
                return this.accessToken;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getApiTicket() {
            WXCore wXCore = this;
            synchronized (wXCore) {
                long now = ToolDate.now();
                if (this.expiryTicket < now) {
                    String newApiTicket = null;
                    long newExpiryTicket = now;
                    String token = this.getAccessToken();
                    if (token == null) {
                        return null;
                    }
                    HttpClient.HttpClientResponse response = this.client.get("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + token, null);
                    if (response.code == 200) {
                        try {
                            JSONObject json = new JSONObject(response.text);
                            if (json.has("ticket")) {
                                newApiTicket = json.getString("ticket");
                            }
                            if (json.has("expires_in")) {
                                long expiryIn = json.getLong("expires_in") * 1000L;
                                newExpiryTicket = now + expiryIn;
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (newApiTicket == null) {
                        return null;
                    }
                    this.apiTicket = newApiTicket;
                    this.expiryTicket = newExpiryTicket;
                }
                return this.apiTicket;
            }
        }

        public boolean setMenu(JSONArray menuButtons) {
            String token = this.getAccessToken();
            if (token != null) {
                String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + ToolStr.URLEncode(token);
                String menu = new JSONObject().put("button", menuButtons).toString(false, true);
                HttpClient.HttpClientResponse response = this.client.write(url, menu);
                if (response.code == 200) {
                    try {
                        JSONObject result = new JSONObject(response.text);
                        return result.has("errcode") && result.getInteger("errcode") == 0;
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fromWeixin(RC res) {
            ArrayList<WXIp> arrayList = this.ips;
            synchronized (arrayList) {
                if (this.ips.isEmpty()) {
                    String url = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=" + this.getAccessToken();
                    HttpClient.HttpClientResponse response = this.client.get(url, null);
                    if (response.code != 200) {
                        return false;
                    }
                    try {
                        JSONObject json = new JSONObject(response.text);
                        JSONArray list = json.getJsonArray("ip_list");
                        if (list != null) {
                            for (int i = 0; i < list.length(); ++i) {
                                this.ips.add(new WXIp(list.getString(i)));
                            }
                        }
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                        return false;
                    }
                }
                String clientIP = ((ResServlet)res).getClientIP();
                for (WXIp ip : this.ips) {
                    if (!ip.match(clientIP)) continue;
                    return true;
                }
                return false;
            }
        }

        public WXQrcode getQrcode(int sceneId, int expireSeconds) {
            return this.getQrcode(sceneId, null, Math.max(expireSeconds, 1));
        }

        public WXQrcode getQrcode(int sceneId) {
            return this.getQrcode(sceneId, null, 0);
        }

        public WXQrcode getQrcode(String sceneStr) {
            return this.getQrcode(0, ToolStr.nullToEmpty(sceneStr), 0);
        }

        private WXQrcode getQrcode(int sceneId, String sceneStr, int expireSeconds) {
            String token = this.getAccessToken();
            if (token != null) {
                String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + ToolStr.URLEncode(token);
                JSONObject json = new JSONObject();
                if (expireSeconds > 0) {
                    sceneId = Math.max(sceneId, 1);
                    expireSeconds = Math.min(expireSeconds, 2592000);
                    json.put("action_name", "QR_SCENE");
                    json.put("action_info", new JSONObject().put("scene", new JSONObject().put("scene_id", sceneId)));
                    if (expireSeconds > 30) {
                        json.put("expire_seconds", expireSeconds);
                    }
                } else if (sceneStr != null) {
                    json.put("action_name", "QR_LIMIT_STR_SCENE");
                    json.put("action_info", new JSONObject().put("scene", new JSONObject().put("scene_str", sceneStr)));
                } else {
                    sceneId = Math.min(Math.max(sceneId, 1), 100000);
                    json.put("action_name", "QR_LIMIT_SCENE");
                    json.put("action_info", new JSONObject().put("scene", new JSONObject().put("scene_id", sceneId)));
                }
                HttpClient.HttpClientResponse response = this.client.write(url, json.toString(false, true));
                if (response.code == 200) {
                    try {
                        JSONObject result = new JSONObject(response.text, true);
                        return WXQrcode.fromJson(result);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            return null;
        }

        public boolean redirectOAuth(RC res) {
            return this.redirectOAuth(res, null);
        }

        public boolean redirectOAuth(RC res, String notWxUrl) {
            String session = ((ResServlet)res).getSession(ServletWX.SESSION_WXOPENID);
            if (session != null) {
                return false;
            }
            if (notWxUrl != null && ToolStr.nullToEmpty(((ResServlet)res).getUserAgent()).toLowerCase().indexOf("micromessenger") < 0) {
                ((ResServlet)res).sendRedirect(notWxUrl);
                return true;
            }
            String uri = ((ResServlet)res).getRequest().getRequestURI();
            byte[] bytes = uri.getBytes(ConstFramework.getCharset());
            String hex = ToolStr.bytes2Hex(bytes).toLowerCase();
            String state = StrConvert.convert(hex, "0123456789abcdef", "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            String redirect = "http://" + this.getHost() + this.getContext() + this.getPath() + ServletWX.PATTERN_OAUTH;
            ((ResServlet)res).sendRedirect("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.getAppId() + "&redirect_uri=" + ToolStr.URLEncode(redirect) + "&response_type=code&scope=snsapi_userinfo&state=" + state + "#wechat_redirect");
            return true;
        }

        public boolean hasOAuthUser(RC res, String openid, String uri) {
            return false;
        }

        public boolean setOAuthUser(RC res, String openid, WXUser wxuser, String uri) {
            return true;
        }

        protected void handleOAuth(RC res) throws ServletException {
            String code = ((ResServlet)res).getParam("code");
            String state = ((ResServlet)res).getParam("state");
            String error = "\u6388\u6743\u5931\u8d25";
            if (code == null || code.trim().isEmpty() || state == null || state.trim().isEmpty()) {
                throw new WXPageException(error, "\u56de\u8c03\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931");
            }
            String hex = StrConvert.convert(state, "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789abcdef");
            byte[] bytes = ToolStr.hex2Bytes(hex);
            String uri = new String(bytes, ConstFramework.getCharset());
            try {
                HttpClient.HttpClientResponse response1 = this.client.get("https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + this.getAppId() + "&secret=" + this.getAppSecret() + "&code=" + code + "&grant_type=authorization_code", null);
                if (response1.code != 200) {
                    throw new WXPageException(error, "\u83b7\u53d6\u7528\u6237OPENID\u5931\u8d25");
                }
                JSONObject json1 = new JSONObject(response1.text, true);
                String openid = json1.getString("openid");
                if (!this.hasOAuthUser(res, openid, uri)) {
                    String token = json1.getString("access_token");
                    HttpClient.HttpClientResponse response2 = this.client.get("https://api.weixin.qq.com/sns/userinfo?access_token=" + token + "&openid=" + openid + "&lang=zh_CN", null);
                    if (response2.code != 200) {
                        throw new WXPageException(error, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    }
                    JSONObject json2 = new JSONObject(response2.text, true);
                    WXUser wxuser = WXUser.fromJson2(json2);
                    if (wxuser.openid == null) {
                        throw new WXPageException(error, "\u89e3\u6790\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    }
                    if (!this.setOAuthUser(res, openid, wxuser, uri)) {
                        throw new WXPageException(error, "\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    }
                }
                ((ResServlet)res).setSession(ServletWX.SESSION_WXOPENID, openid);
            }
            catch (JSONException ex) {
                throw new WXPageException(error, "\u5fae\u4fe1\u6570\u636e\u89e3\u6790\u5931\u8d25");
            }
            ((ResServlet)res).sendRedirect(uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleConfigJs(RC res) throws ServletException {
            PrintWriter out = ((ResServlet)res).getWriter();
            try {
                JSONArray list = new JSONArray();
                String apis = ToolStr.emptyToNull(((ResServlet)res).getParam(ServletWX.PARAM_LIST), true);
                if (apis != null) {
                    for (String api : apis.replace('\uff0c', ',').split(",")) {
                        list.put(api);
                    }
                }
                boolean debug = ((ResServlet)res).hasParam(ServletWX.PARAM_DEBUG);
                String appId = this.getAppId();
                String timestamp = Long.toString(ToolDate.now() / 1000L);
                String nonceStr = ToolStr.randomMD5();
                String ticket = this.getApiTicket();
                String signature = null;
                if (ticket != null) {
                    signature = this.getSignature(res, timestamp, nonceStr, ticket);
                }
                JSONObject config = new JSONObject();
                config.put(ServletWX.PARAM_DEBUG, debug);
                config.put("appId", appId);
                config.put(ServletWX.PARAM_TIMESTAMP, timestamp);
                config.put("nonceStr", nonceStr);
                config.put(ServletWX.PARAM_SIGNATURE, signature);
                config.put("jsApiList", list);
                out.print("jWeixin.config(" + config.toString() + ");");
            }
            finally {
                out.close();
            }
        }

        public String getWeixinJsUrl() {
            return "http://res.wx.qq.com/open/js/jweixin-1.0.0.js";
        }

        public String getConfigJsUrl(String ... list) {
            return this.getConfigJsUrl(false, list);
        }

        public String getConfigJsUrl(boolean debug, String ... list) {
            String url = this.getContext() + this.getPath() + ServletWX.PATTERN_CONFIG_JS;
            url = url + "?list=" + ToolStr.joinArr(list, ",");
            if (debug) {
                url = url + "&debug";
            }
            return url;
        }

        protected String getSignature(RC res, String timestamp, String nonceStr, String ticket) {
            String url = ((ResServlet)res).getRequest().getHeader("Referer");
            String params = "jsapi_ticket=" + ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
            return ToolStr.SHA(params);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(RC res) throws ServletException {
            block23: {
                boolean hasEchoStr = ((ResServlet)res).hasParam(ServletWX.PARAM_ECHOSTR);
                if (hasEchoStr) {
                    String token = this.getToken();
                    String signature = ToolStr.nullToEmpty(((ResServlet)res).getParam(ServletWX.PARAM_SIGNATURE));
                    String timestamp = ToolStr.nullToEmpty(((ResServlet)res).getParam(ServletWX.PARAM_TIMESTAMP));
                    String nonce = ToolStr.nullToEmpty(((ResServlet)res).getParam(ServletWX.PARAM_NONCE));
                    String echostr = ToolStr.nullToEmpty(((ResServlet)res).getParam(ServletWX.PARAM_ECHOSTR));
                    Object[] tmpArr = new String[]{token, timestamp, nonce};
                    Arrays.sort(tmpArr);
                    StringBuilder sb = new StringBuilder();
                    for (Object str : tmpArr) {
                        sb.append((String)str);
                    }
                    String tmpStr = ToolStr.SHA(sb.toString());
                    if (tmpStr.equals(signature)) {
                        PrintWriter out = ((ResServlet)res).getWriter();
                        try {
                            out.print(echostr);
                        }
                        finally {
                            out.close();
                        }
                    }
                } else {
                    try {
                        String rawdata = null;
                        ServletInputStream in = ((ResServlet)res).getRequest().getInputStream();
                        try {
                            rawdata = ToolStream.read((InputStream)in, ConstFramework.getCharset());
                        }
                        finally {
                            in.close();
                        }
                        if (rawdata == null) break block23;
                        ServletWX.log(this.getDebug(), new String[]{rawdata});
                        String rtnxml = null;
                        String toUserName = null;
                        String fromUserName = null;
                        try {
                            DomParser dom = DomParser.create(rawdata);
                            toUserName = WXCore.getCDATA(dom, "ToUserName");
                            fromUserName = WXCore.getCDATA(dom, "FromUserName");
                            String msgType = WXCore.getCDATA(dom, "MsgType");
                            if ("text".equals(msgType)) {
                                String content = ToolStr.nullToEmpty(WXCore.getCDATA(dom, "Content")).trim();
                                rtnxml = this.solveTextMessage(res, toUserName, fromUserName, content);
                            } else if ("event".equals(msgType)) {
                                String event = ToolStr.nullToEmpty(WXCore.getCDATA(dom, "Event")).trim();
                                String eventKey = ToolStr.nullToEmpty(WXCore.getCDATA(dom, "EventKey")).trim();
                                rtnxml = this.solveEventMessage(res, toUserName, fromUserName, event, eventKey);
                            }
                        }
                        catch (WXApiException ex) {
                            if (toUserName != null && fromUserName != null) {
                                rtnxml = WXCore.xmlText(toUserName, fromUserName, ex.text);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        if (rtnxml == null) break block23;
                        PrintWriter out = ((ResServlet)res).getWriter();
                        try {
                            out.print(rtnxml);
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }

        public String solveTextMessage(RC res, String toUserName, String fromUserName, String content) throws WXApiException {
            return null;
        }

        public String solveEventMessage(RC res, String toUserName, String fromUserName, String event, String eventKey) throws WXApiException {
            return null;
        }

        protected static String getQrcodeScene(String eventKey) {
            String prefix = "qrscene_";
            if (eventKey != null && eventKey.startsWith(prefix)) {
                return eventKey.substring(prefix.length());
            }
            return null;
        }

        protected static int getQrcodeScene(String eventKey, int errorVal) {
            return ToolStr.parseInt(WXCore.getQrcodeScene(eventKey), errorVal);
        }

        protected static String getCDATA(DomParser dom, String tag) {
            ArrayList<DomParser.NodeElement> results = dom.document.search(tag);
            if (!results.isEmpty()) {
                for (DomParser.Node node : results.get((int)0).children) {
                    if (!(node instanceof DomParser.NodeCDATA)) continue;
                    DomParser.NodeCDATA cdata = (DomParser.NodeCDATA)node;
                    return cdata.content;
                }
            }
            return null;
        }

        public static String xmlText(String toUser, String fromUser, String content) {
            StringBuilder sb = new StringBuilder();
            sb.append("<xml>");
            sb.append("<ToUserName><![CDATA[").append(WXCore.fixXmlStr(toUser)).append("]]></ToUserName>");
            sb.append("<FromUserName><![CDATA[").append(WXCore.fixXmlStr(fromUser)).append("]]></FromUserName>");
            sb.append("<CreateTime>").append(ToolDate.now() / 1000L).append("</CreateTime>");
            sb.append("<MsgType><![CDATA[text]]></MsgType>");
            sb.append("<Content><![CDATA[").append(WXCore.fixXmlStr(content)).append("]]></Content>");
            sb.append("<FuncFlag>0</FuncFlag>");
            sb.append("</xml>");
            return sb.toString();
        }

        public static String xmlNews(String toUser, String fromUser, String title, String description, String picurl, String url) {
            StringBuilder sb = new StringBuilder();
            sb.append("<xml>");
            sb.append("<ToUserName><![CDATA[").append(WXCore.fixXmlStr(toUser)).append("]]></ToUserName>");
            sb.append("<FromUserName><![CDATA[").append(WXCore.fixXmlStr(fromUser)).append("]]></FromUserName>");
            sb.append("<CreateTime>").append(ToolDate.now() / 1000L).append("</CreateTime>");
            sb.append("<MsgType><![CDATA[news]]></MsgType>");
            sb.append("<ArticleCount>1</ArticleCount>");
            sb.append("<Articles>");
            sb.append("<item>");
            sb.append("<Title><![CDATA[").append(WXCore.fixXmlStr(title)).append("]]></Title>");
            sb.append("<Description><![CDATA[").append(WXCore.fixXmlStr(description)).append("]]></Description>");
            sb.append("<PicUrl><![CDATA[").append(WXCore.fixXmlStr(picurl)).append("]]></PicUrl>");
            sb.append("<Url><![CDATA[").append(WXCore.fixXmlStr(url)).append("]]></Url>");
            sb.append("</item>");
            sb.append("</Articles>");
            sb.append("<FuncFlag>0</FuncFlag>");
            sb.append("</xml>");
            return sb.toString();
        }

        protected static String fixXmlStr(String cdata) {
            return cdata == null ? "" : cdata.replaceAll("]]>", "] ]>");
        }

        public static String jsonText(String toUser, String content) {
            JSONObject json = new JSONObject();
            JSONObject text = new JSONObject();
            json.put("touser", toUser);
            json.put("msgtype", "text");
            json.put("text", text);
            text.put("content", content);
            return ToolStr.fromUnicode(json.toString());
        }

        public static String jsonNews(String toUser, String title, String description, String picurl, String url) {
            JSONObject json = new JSONObject();
            JSONObject news = new JSONObject();
            JSONArray articles = new JSONArray();
            JSONObject article = new JSONObject();
            json.put("touser", toUser);
            json.put("msgtype", "news");
            json.put("news", news);
            news.put("articles", articles);
            articles.put(article);
            article.put("title", title);
            article.put("description", description);
            article.put("url", url);
            article.put("picurl", picurl);
            return ToolStr.fromUnicode(json.toString());
        }

        private static ArrayList<String> getParts(String content) {
            ArrayList<String> parts = new ArrayList<String>();
            String[] lines = content.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (sb.length() + line.length() > 1000) {
                    parts.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            if (sb.length() > 0) {
                parts.add(sb.toString());
            }
            return parts;
        }

        public void doSendText(final String openid, final String content) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WXCore.this.sendText(openid, content);
                }
            }).start();
        }

        public boolean sendText(String openid, String content) {
            if (content != null && content.length() > 1000) {
                boolean success = true;
                ArrayList<String> parts = WXCore.getParts(content);
                for (int i = 0; i < parts.size(); ++i) {
                    String part = parts.get(i);
                    part = part + "\n(\u7b2c " + (i + 1) + " / " + parts.size() + " \u6761)";
                    String jsonStr = WXCore.jsonText(openid, part);
                    success = success && this.sendMsg(jsonStr);
                }
                return success;
            }
            String jsonText = WXCore.jsonText(openid, content);
            return this.sendMsg(jsonText);
        }

        public void doSendNews(final String openid, final String title, final String description, final String picurl, final String url) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WXCore.this.sendNews(openid, title, description, picurl, url);
                }
            }).start();
        }

        public boolean sendNews(String openid, String title, String description, String picurl, String url) {
            String jsonStr = WXCore.jsonNews(openid, title, description, picurl, url);
            return this.sendMsg(jsonStr);
        }

        public boolean sendMsg(String jsonStr) {
            String token = this.getAccessToken();
            if (token == null) {
                return false;
            }
            String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + token;
            HttpClient.HttpClientResponse response = this.client.write(url, jsonStr);
            if (response.code == 200) {
                try {
                    JSONObject result = new JSONObject(response.text);
                    if (result.has("errcode") && result.getInteger("errcode") == 0) {
                        return true;
                    }
                }
                catch (JSONException ex) {
                    Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return false;
        }

        public WXUser getUser(String openid) {
            String token = this.getAccessToken();
            if (token == null) {
                return null;
            }
            String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + token + "&openid=" + openid + "&lang=zh_CN";
            HttpClient.HttpClientResponse response = this.client.get(url, null);
            if (response.code == 200) {
                try {
                    JSONObject result = new JSONObject(response.text, true);
                    return WXUser.fromJson1(result);
                }
                catch (JSONException ex) {
                    Logger.getLogger(ServletWX.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return null;
        }
    }
}

