/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.str;

import java.util.ArrayList;

public abstract class StrAnalyer {
    protected static final int STATE_ZERO = 0;
    protected final ArrayList<String> tokens;
    private int state;
    protected int index;

    public StrAnalyer(ArrayList<String> tokens) throws AnalyerException {
        this.tokens = tokens;
        this.index = 0;
        this.state = 0;
        this.scan();
    }

    private void scan() throws AnalyerException {
        try {
            this.start();
            while (this.index >= 0 && this.index < this.tokens.size()) {
                this.state = this.run(this.state, this.tokens.get(this.index));
            }
            this.end(this.state);
        }
        catch (Exception ex) {
            throw new AnalyerException(ex);
        }
    }

    protected boolean next() {
        return this.next(1);
    }

    protected boolean next(int offset) {
        this.index += offset;
        return this.index >= 0 && this.index < this.tokens.size();
    }

    protected String read() throws AnalyerException {
        return this.read(false);
    }

    protected String read(boolean test) throws AnalyerException {
        String val = this.read(this.index, test);
        if (val != null) {
            this.next();
        }
        return val;
    }

    protected String read(int index) throws AnalyerException {
        return this.read(index, false);
    }

    protected String read(int index, boolean test) throws AnalyerException {
        if (index >= 0 && index < this.tokens.size()) {
            return this.tokens.get(index);
        }
        if (test) {
            return null;
        }
        throw new AnalyerException("read reach end of tokens");
    }

    protected String readStr(char quote) throws AnalyerException {
        return this.readStr(Character.toString(quote), false);
    }

    protected String readStr(String quotes) throws AnalyerException {
        return this.readStr(quotes, false);
    }

    protected String readStr(char quote, boolean test) throws AnalyerException {
        return this.readStr(Character.toString(quote), test);
    }

    protected String readStr(String quotes, boolean test) throws AnalyerException {
        String val = this.readStr(this.index, quotes, test);
        if (val != null) {
            this.next();
        }
        return val;
    }

    protected String readStr(int index, char quote) throws AnalyerException {
        return this.readStr(index, Character.toString(quote), false);
    }

    protected String readStr(int index, char quote, boolean test) throws AnalyerException {
        return this.readStr(index, Character.toString(quote), test);
    }

    protected String readStr(int index, String quotes) throws AnalyerException {
        return this.readStr(index, quotes, false);
    }

    protected String readStr(int index, String quotes, boolean test) throws AnalyerException {
        String str = this.read(index, test);
        if (str != null && str.length() > 0 && StrAnalyer.contain(str.charAt(0), quotes.toCharArray())) {
            return str.substring(1);
        }
        if (test) {
            return null;
        }
        throw new AnalyerException("expect string at index " + index);
    }

    protected boolean test(String word) throws AnalyerException {
        return this.match(this.index, word, false);
    }

    protected boolean test(String word, boolean sensitive) throws AnalyerException {
        return this.match(this.index, word, sensitive);
    }

    protected boolean match(String word) throws AnalyerException {
        return this.match(word, false);
    }

    protected boolean match(String word, boolean sensitive) throws AnalyerException {
        if (this.match(this.index, word, sensitive)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean match(int index, String word) throws AnalyerException {
        return this.match(index, word, false);
    }

    protected boolean match(int index, String word, boolean sensitive) throws AnalyerException {
        return StrAnalyer.strEqual(this.read(index, true), word, sensitive);
    }

    protected boolean match(String[] words) throws AnalyerException {
        return this.match(words, false);
    }

    protected boolean match(String[] words, boolean sensitive) throws AnalyerException {
        if (this.match(this.index, words, sensitive)) {
            this.next(words.length);
            return true;
        }
        return false;
    }

    protected boolean match(int index, String[] words) throws AnalyerException {
        return this.match(index, words, false);
    }

    protected boolean match(int index, String[] words, boolean sensitive) throws AnalyerException {
        for (int i = 0; i < words.length; ++i) {
            if (StrAnalyer.strEqual(this.read(index + i, true), words[i], sensitive)) continue;
            return false;
        }
        return true;
    }

    protected void throwMatch(String str) throws AnalyerException {
        this.throwMatch(str, false);
    }

    protected void throwMatch(String str, boolean sensitive) throws AnalyerException {
        if (!this.match(str, sensitive)) {
            String val = this.read();
            val = val == null ? "end" : "'" + val + "'";
            throw new AnalyerException("expect '" + str + "' at " + val);
        }
    }

    protected void throwMatch(String[] strs) throws AnalyerException {
        this.throwMatch(strs, false);
    }

    protected void throwMatch(String[] strs, boolean sensitive) throws AnalyerException {
        if (!this.match(strs, sensitive)) {
            StringBuilder sb = new StringBuilder(strs[0]);
            for (int i = 1; i < strs.length; ++i) {
                sb.append(" ").append(strs[i]);
            }
            String val = this.read();
            val = val == null ? "end" : "'" + val + "'";
            throw new AnalyerException("expect '" + sb.toString() + "' at " + val);
        }
    }

    protected void throwIllegal() throws AnalyerException {
        if (this.index >= 0 && this.index <= this.tokens.size()) {
            throw new AnalyerException("illegal state at token '" + this.tokens.get(this.index) + "'");
        }
        throw new AnalyerException("illegal state at end of string");
    }

    protected void start() throws AnalyerException {
    }

    protected void end(int state) throws AnalyerException {
    }

    protected abstract int run(int var1, String var2) throws AnalyerException;

    protected static boolean strEqual(String str1, String str2) {
        return StrAnalyer.strEqual(str1, str2, false);
    }

    protected static boolean strEqual(String str1, String str2, boolean sensitive) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return sensitive ? str1.equals(str2) : str1.toLowerCase().equals(str2.toLowerCase());
    }

    protected static boolean contain(char ch, char[] arr) {
        for (char c : arr) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    protected static boolean contain(String str, String[] arr) {
        for (String s : arr) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static class AnalyerException
    extends Exception {
        public Object ex;

        public AnalyerException(String ex) {
            this.ex = ex;
        }

        public AnalyerException(Exception ex) {
            this.ex = ex;
        }

        @Override
        public String toString() {
            return this.ex.toString();
        }
    }
}

