/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.str;

import java.util.ArrayList;

public abstract class StrLexer {
    protected static final int STATE_ZERO = 0;
    private int state;
    protected final String str;
    protected int index;
    protected final ArrayList<String> tokens;

    public StrLexer(String str) throws LexerException {
        this.str = str;
        this.index = 0;
        this.state = 0;
        this.tokens = new ArrayList();
        this.scan();
    }

    private void scan() throws LexerException {
        try {
            this.start();
            while (this.index >= 0 && this.index < this.str.length()) {
                this.state = this.run(this.state, this.str.charAt(this.index));
            }
            this.end(this.state);
        }
        catch (Exception ex) {
            throw new LexerException(ex);
        }
    }

    protected boolean next() {
        return this.next(1);
    }

    protected boolean next(int offset) {
        this.index += offset;
        return this.index >= 0 && this.index < this.str.length();
    }

    protected char read() throws LexerException {
        return this.read(false);
    }

    protected char read(boolean test) throws LexerException {
        char ch = this.read(this.index, test);
        if (ch != '\u0000') {
            ++this.index;
        }
        return ch;
    }

    protected char read(int index) throws LexerException {
        return this.read(index, false);
    }

    protected char read(int index, boolean test) throws LexerException {
        if (index >= 0 && index < this.str.length()) {
            return this.str.charAt(index);
        }
        if (test) {
            return '\u0000';
        }
        throw new LexerException("read reach end of string");
    }

    protected boolean match(String str) throws LexerException {
        return this.match(this.index, str, false);
    }

    protected boolean match(String str, boolean sensitive) throws LexerException {
        if (this.match(this.index, str, sensitive)) {
            this.index += str.length();
            return true;
        }
        return false;
    }

    protected boolean match(int index, String str) throws LexerException {
        return this.match(index, str, false);
    }

    protected boolean match(int index, String str, boolean sensitive) throws LexerException {
        for (int i = 0; i < str.length(); ++i) {
            if (StrLexer.chEqual(this.read(index + i, true), str.charAt(i), sensitive)) continue;
            return false;
        }
        return true;
    }

    protected void start() throws LexerException {
    }

    protected void end(int state) throws LexerException {
    }

    protected abstract int run(int var1, char var2) throws LexerException;

    protected void throwIllegal() throws LexerException {
        if (this.index >= 0 && this.index <= this.str.length()) {
            throw new LexerException("illegal state at character '" + this.str.charAt(this.index) + "'");
        }
        throw new LexerException("illegal state at end of string");
    }

    public ArrayList<String> getTokens() {
        return this.tokens;
    }

    protected void addToken(char token) {
        this.tokens.add(Character.toString(token));
    }

    protected void addToken(String token) {
        this.tokens.add(token);
    }

    protected boolean isSpaceChar(char ch) {
        return ch <= ' ';
    }

    protected boolean isQuoteChar(char ch) {
        return ch == '\'' || ch == '\"';
    }

    protected boolean isWordChar(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_';
    }

    protected boolean isNumChar(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected void solveCommonWord() throws LexerException {
        int cursor = this.index;
        char ch = this.read(cursor);
        if (!this.isWordChar(ch)) {
            throw new LexerException("not a word character '" + ch + "'");
        }
        StringBuilder sb = new StringBuilder();
        while (this.isWordChar(ch) || this.isNumChar(ch)) {
            sb.append(ch);
            ch = this.read(++cursor, true);
        }
        this.tokens.add(sb.toString());
        this.index = cursor;
    }

    protected void solveCommonNumber() throws LexerException {
        int cursor = this.index;
        char ch = this.read(cursor);
        if (!this.isNumChar(ch)) {
            throw new LexerException("not a number character '" + ch + "'");
        }
        StringBuilder sb = new StringBuilder();
        boolean dot = true;
        while (this.isNumChar(ch)) {
            sb.append(ch);
            if ((ch = this.read(++cursor, true)) != '.' || !dot) continue;
            sb.append(ch);
            ch = this.read(++cursor, true);
            dot = false;
        }
        this.tokens.add(sb.toString());
        this.index = cursor;
    }

    protected void solveCommonString() throws LexerException {
        int cursor = this.index;
        char quote = this.read(cursor);
        char ch = this.read(++cursor);
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        while (ch != quote) {
            block15: {
                block14: {
                    if (ch != '\\') break block14;
                    ch = this.read(++cursor);
                    switch (ch) {
                        case 'u': {
                            int val = 0;
                            for (int i = 0; i < 4; ++i) {
                                val = val * 16 + StrLexer.getHexCharVal(this.read(++cursor));
                            }
                            sb.append((char)val);
                            break block15;
                        }
                        case '\\': {
                            sb.append('\\');
                            break block15;
                        }
                        case '/': {
                            sb.append('/');
                            break block15;
                        }
                        case '\'': {
                            sb.append('\'');
                            break block15;
                        }
                        case '\"': {
                            sb.append('\"');
                            break block15;
                        }
                        case 'b': {
                            sb.append('\b');
                            break block15;
                        }
                        case 'f': {
                            sb.append('\f');
                            break block15;
                        }
                        case 'n': {
                            sb.append('\n');
                            break block15;
                        }
                        case 'r': {
                            sb.append('\r');
                            break block15;
                        }
                        case 't': {
                            sb.append('\t');
                            break block15;
                        }
                        default: {
                            throw new LexerException("unsolve escape character '" + ch + "'");
                        }
                    }
                }
                sb.append(ch);
            }
            ch = this.read(++cursor, true);
        }
        this.tokens.add(sb.toString());
        this.index = cursor + 1;
    }

    protected void solveComment(String start, String end) throws LexerException {
        int i = this.index;
        if (!this.match(i, start)) {
            throw new LexerException("expected comment start '" + start + "' at " + this.index);
        }
        i += start.length();
        this.index = (i = this.str.indexOf(end, i)) >= 0 ? i + end.length() : this.str.length();
    }

    protected void solveComment(String start, char[] chArr) throws LexerException {
        int i = this.index;
        if (!this.match(i, start)) {
            throw new LexerException("expected comment start '" + start + "' at " + this.index);
        }
        i += start.length();
        int end = this.str.length();
        for (char ch : chArr) {
            int j = this.str.indexOf(ch, i);
            if (j < 0 || j >= end) continue;
            end = j;
        }
        this.index = end + 1;
    }

    protected static int getHexCharVal(char ch) throws LexerException {
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new LexerException("expected hex char but get '" + ch + "'");
    }

    protected static boolean chEqual(char ch1, char ch2, boolean sensitive) {
        if (ch1 == '\u0000' || ch2 == '\u0000') {
            return false;
        }
        return sensitive ? ch1 == ch2 : Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
    }

    public static class LexerException
    extends Exception {
        public Object ex;

        public LexerException(String ex) {
            this.ex = ex;
        }

        public LexerException(Exception ex) {
            this.ex = ex;
        }

        @Override
        public String toString() {
            return this.ex.toString();
        }
    }
}

