/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.tool.ToolArr;
import com.modnut.framework2.tool.ToolStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolClass {
    private static final int BUFF_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] class2bytes(Class c) throws IOException {
        String name = c.getName().replace('.', '/') + ".class";
        InputStream is = c.getClassLoader().getResourceAsStream(name);
        try {
            int read;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((read = is.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static Class[] getTypes(Object ... args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getClass();
        }
        return types;
    }

    public static Object invoke(Class c, String name, Object ... args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return c.getMethod(name, ToolClass.getTypes(args)).invoke(null, args);
    }

    public static Object invoke(Object o, String name, Object ... args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return o.getClass().getMethod(name, ToolClass.getTypes(args)).invoke(o, args);
    }

    public static boolean baseOfClass(Class c, Class baseclass) {
        Class superclass = c;
        while (superclass != null) {
            if (superclass.equals(baseclass)) {
                return true;
            }
            c = superclass;
            superclass = c.getSuperclass();
        }
        return false;
    }

    public static int enumCount(Class enumClass) {
        if (enumClass != null && enumClass.isEnum()) {
            return enumClass.getEnumConstants().length;
        }
        return -1;
    }

    public static Object ordinal2Enum(Class enumClass, int ordinal) {
        T[] constants;
        if (enumClass != null && enumClass.isEnum() && ordinal < (constants = enumClass.getEnumConstants()).length) {
            return constants[ordinal];
        }
        return null;
    }

    public static int enum2Ordinal(Class enumClass, Object enumObject) {
        if (enumClass != null && enumClass.isEnum()) {
            T[] constants = enumClass.getEnumConstants();
            for (int i = 0; i < constants.length; ++i) {
                if (!constants[i].equals(enumObject)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Object name2Enum(Class enumClass, String name) {
        if (enumClass != null && enumClass.isEnum()) {
            for (Object e : enumClass.getEnumConstants()) {
                if (!e.toString().equals(name)) continue;
                return e;
            }
        }
        return null;
    }

    public static int name2Ordinal(Class enumClass, String name) {
        if (enumClass != null && enumClass.isEnum()) {
            T[] constants = enumClass.getEnumConstants();
            for (int i = 0; i < constants.length; ++i) {
                if (!constants[i].toString().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T parseObj(Object obj, Class<T> parse) {
        return ToolClass.parseObj(obj, parse, false);
    }

    public static <T> T parseObj(Object obj, Class<T> parse, boolean accurate) {
        if (obj != null && parse != null && (accurate ? parse.equals(obj.getClass()) : ToolClass.baseOfClass(obj.getClass(), parse))) {
            return (T)obj;
        }
        return null;
    }

    public static <T> ArrayList<T> publicStatics(Class c, Class<T> parse) {
        return ToolClass.publicStatics(c, parse, null, false);
    }

    public static <T> ArrayList<T> publicStatics(Class c, Class<T> parse, String prefix) {
        return ToolClass.publicStatics(c, parse, prefix, false);
    }

    public static <T> ArrayList<T> publicStatics(Class c, Class<T> parse, boolean accurate) {
        return ToolClass.publicStatics(c, parse, null, accurate);
    }

    public static <T> ArrayList<T> publicStatics(Class c, Class<T> parse, String prefix, boolean accurate) {
        if (c != null) {
            ArrayList<T> list = new ArrayList<T>();
            for (Field f : c.getFields()) {
                int modifiers;
                String name = f.getName();
                if (prefix != null && !name.startsWith(prefix) || accurate && !f.getDeclaringClass().equals(c) || !Modifier.isPublic(modifiers = f.getModifiers()) || !Modifier.isStatic(modifiers)) continue;
                try {
                    T obj = ToolClass.parseObj(f.get(null), parse);
                    if (obj == null) continue;
                    list.add(obj);
                }
                catch (Exception ex) {
                    Logger.getLogger(ToolClass.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return list;
        }
        return null;
    }

    public static HashMap<String, Object> publicObjects(Object o, boolean isStatic) {
        return ToolClass.publicObjects(o, isStatic, null);
    }

    public static HashMap<String, Object> publicObjects(Object o, boolean isStatic, String prefix) {
        if (o != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> c = o.getClass();
            for (Field f : c.getFields()) {
                int modifiers;
                String name = f.getName();
                if (prefix != null && !name.startsWith(prefix) || !Modifier.isPublic(modifiers = f.getModifiers()) || Modifier.isStatic(modifiers) != isStatic) continue;
                try {
                    map.put(name, f.get(o));
                }
                catch (Exception ex) {
                    Logger.getLogger(ToolClass.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return map;
        }
        return null;
    }

    public static String[] publicStrings(Class c) {
        return ToolClass.publicStrings(c, null, false);
    }

    public static String[] publicStrings(Class c, String prefix) {
        return ToolClass.publicStrings(c, prefix, false);
    }

    public static String[] publicStrings(Class c, String prefix, boolean accurate) {
        ArrayList<String> strs = ToolClass.publicStatics(c, String.class, prefix, accurate);
        return ToolArr.toArray(strs);
    }

    public static Field getField(Class c, String name) {
        Field f = null;
        try {
            f = c.getField(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static void copyObject(Object src, Object dest) {
        if (src == null || dest == null) {
            return;
        }
        Class<?> srcCls = src.getClass();
        Class<?> destCls = dest.getClass();
        for (Field srcFld : srcCls.getFields()) {
            Class<?> type;
            int destModifiers;
            Field destFld;
            int srcModifiers = srcFld.getModifiers();
            if (Modifier.isStatic(srcModifiers) || !Modifier.isPublic(srcModifiers) || (destFld = ToolClass.getField(destCls, srcFld.getName())) == null || Modifier.isStatic(destModifiers = srcFld.getModifiers()) || !Modifier.isPublic(destModifiers) || !(type = srcFld.getType()).equals(destFld.getType())) continue;
            try {
                if (Boolean.TYPE.equals(type)) {
                    srcFld.setBoolean(dest, srcFld.getBoolean(src));
                    continue;
                }
                if (Byte.TYPE.equals(type)) {
                    srcFld.setByte(dest, srcFld.getByte(src));
                    continue;
                }
                if (Character.TYPE.equals(type)) {
                    srcFld.setChar(dest, srcFld.getChar(src));
                    continue;
                }
                if (Short.TYPE.equals(type)) {
                    srcFld.setShort(dest, srcFld.getShort(src));
                    continue;
                }
                if (Integer.TYPE.equals(type)) {
                    srcFld.setInt(dest, srcFld.getInt(src));
                    continue;
                }
                if (Long.TYPE.equals(type)) {
                    srcFld.setLong(dest, srcFld.getLong(src));
                    continue;
                }
                if (Float.TYPE.equals(type)) {
                    srcFld.setFloat(dest, srcFld.getFloat(src));
                    continue;
                }
                if (Double.TYPE.equals(type)) {
                    srcFld.setDouble(dest, srcFld.getDouble(src));
                    continue;
                }
                srcFld.set(dest, srcFld.get(src));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ToolClass.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ToolClass.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static <T> T parseObject(Object o, Class<T> c) {
        if (o != null && ToolClass.baseOfClass(o.getClass(), c)) {
            return (T)o;
        }
        return null;
    }

    public static boolean hasInterface(Class c, Class i) {
        for (Class<?> ci : c.getInterfaces()) {
            if (!i.equals(ci)) continue;
            return true;
        }
        return false;
    }

    public static <T> T newInstance(Class<T> c) {
        T obj = null;
        try {
            obj = c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public static class ByteArrayClassLoader
    extends ClassLoader {
        public Class getLoadedClass(String name) {
            return this.findLoadedClass(name);
        }

        public Class loadClass(String name, InputStream in) throws IOException {
            return this.loadClass(name, ToolStream.getBytes(in), false);
        }

        public Class loadClass(String name, InputStream in, boolean resolve) throws IOException {
            return this.loadClass(name, ToolStream.getBytes(in), resolve);
        }

        public Class loadClass(String name, byte[] data) {
            return this.loadClass(name, data, false);
        }

        public Class loadClass(String name, byte[] data, boolean resolve) {
            Class<?> loadedClass;
            if (name != null && (loadedClass = this.findLoadedClass(name)) != null) {
                return loadedClass;
            }
            Class<?> c = this.defineClass(name, data, 0, data.length);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

