/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

public class ToolConsole {
    public static final String NONE = "\u001b[0m";
    public static final String HIGH_LIGHT = "\u001b[1m";
    public static final String UNDER_LINE = "\u001b[4m";
    public static final String FLASH = "\u001b[5m";
    public static final String INVERSE = "\u001b[7m";
    public static final String OFF = "\u001b[8m";
    private static final String COLOR_PREFIX = "\u001b[";
    private static final String COLOR_SUFFIX = "m";
    private static final int COLOR_BASE = 30;
    private static final int BG_COLOR_BASE = 40;

    public static void print(String str) {
        System.out.print(str);
    }

    public static void print(String str, String[] ctrls) {
        if (ctrls != null) {
            for (String ctrl : ctrls) {
                ToolConsole.print(ctrl);
            }
        }
        ToolConsole.print(str);
        ToolConsole.print(NONE);
    }

    public static void print(String str, COLOR color) {
        ToolConsole.print(str, color, null);
    }

    public static void print(String str, COLOR color, COLOR bgColor) {
        if (color != null) {
            ToolConsole.print(color.getStr());
        }
        if (bgColor != null) {
            ToolConsole.print(bgColor.getBGStr());
        }
        ToolConsole.print(str);
        ToolConsole.print(NONE);
    }

    public static enum COLOR {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        PURPLE,
        DARKGREEN,
        WHITE;


        public String getStr() {
            int colorStr = 30 + this.ordinal();
            return ToolConsole.COLOR_PREFIX + colorStr + ToolConsole.COLOR_SUFFIX;
        }

        public String getBGStr() {
            int colorStr = 40 + this.ordinal();
            return ToolConsole.COLOR_PREFIX + colorStr + ToolConsole.COLOR_SUFFIX;
        }
    }
}

