/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.Digest;
import com.modnut.framework2.tool.ToolStr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolFile {
    public static final FileFilter NONE_FILTER = null;
    private static int DEFAULT_BUFF_SIZE = 1024;
    private static final long UNIT_RATE = 1024L;
    private static final String[] UNIT_NAME = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final int NEW_FILENAME_LEN = 8;
    private static final int NEW_FILENAME_RETRY = 16;
    private static final int READ_BYTES_MAX = 0xA00000;
    public static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public static final FileFilter NOT_DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    };
    private static final String[] SPECIAL_EXT = new String[]{".tar.bz2", ".tar.gz", ".tar.tar", ".tar.zip", ".tar.z"};

    public static String getFileNoExtName(String fileName) {
        int extDotIndex;
        int i;
        for (i = 0; i < SPECIAL_EXT.length; ++i) {
            if (!fileName.endsWith(SPECIAL_EXT[i])) continue;
            return fileName.substring(0, fileName.length() - SPECIAL_EXT[i].length());
        }
        if (i == SPECIAL_EXT.length && (extDotIndex = fileName.lastIndexOf(46)) >= 0) {
            return fileName.substring(0, extDotIndex);
        }
        return fileName;
    }

    public static String getFileExt(String fileName) {
        int extDotIndex;
        int i;
        for (i = 0; i < SPECIAL_EXT.length; ++i) {
            if (!fileName.endsWith(SPECIAL_EXT[i])) continue;
            return SPECIAL_EXT[i].substring(1);
        }
        if (i == SPECIAL_EXT.length && (extDotIndex = fileName.lastIndexOf(46)) >= 0) {
            return fileName.substring(extDotIndex + 1);
        }
        return "";
    }

    public static boolean moveFile(File source, File target) throws IOException {
        if (source == null || target == null) {
            return false;
        }
        if (source.exists()) {
            if (target.exists()) {
                ToolFile.deleteFile(target);
            }
            if (!source.renameTo(target)) {
                return ToolFile.copyFile(source, target) && ToolFile.deleteFile(source);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File target) throws IOException {
        if (source == null || target == null) {
            return false;
        }
        if (source.exists()) {
            if (source.isDirectory()) {
                if (!target.exists()) {
                    target.mkdirs();
                } else if (!target.isDirectory()) {
                    ToolFile.deleteFile(target);
                    target.mkdirs();
                }
                for (File f : source.listFiles()) {
                    if (ToolFile.copyFile(f, new File(target.getAbsolutePath() + File.separator + f.getName()))) continue;
                    return false;
                }
                return true;
            }
            if (target.exists()) {
                ToolFile.deleteFile(target);
            }
            FileInputStream in = new FileInputStream(source);
            try {
                ToolFile.writeInputStreamToFile((InputStream)in, target);
            }
            finally {
                in.close();
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFile(String filePath) {
        if (filePath == null) {
            return true;
        }
        return ToolFile.deleteFile(new File(filePath));
    }

    public static boolean deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    ToolFile.deleteFile(child);
                }
            }
            return file.delete();
        }
        return true;
    }

    public static boolean existFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean checkFileName(String fileName) {
        return ToolFile.checkFileName(fileName, null);
    }

    public static boolean checkFileName(String fileName, String ext) {
        String fileExt;
        if (fileName == null) {
            return false;
        }
        if (fileName.indexOf(47) >= 0) {
            return false;
        }
        if (fileName.indexOf(92) >= 0) {
            return false;
        }
        return ext == null || ToolStr.equals(fileExt = ToolFile.getFileExt(fileName), ext, false);
    }

    public static boolean checkPath(String dirPath) {
        if (dirPath == null) {
            return false;
        }
        File dir = new File(dirPath);
        return dir.exists() ? dir.isDirectory() : dir.mkdirs();
    }

    public static long size(String filePath) {
        if (filePath == null) {
            return 0L;
        }
        File file = new File(filePath);
        return ToolFile.size(file);
    }

    public static long size(File file) {
        if (file == null || !file.exists()) {
            return 0L;
        }
        if (!file.isDirectory()) {
            return file.length();
        }
        File[] listFiles = file.listFiles();
        long total = 0L;
        for (File f : listFiles) {
            total += ToolFile.size(f);
        }
        return total;
    }

    public static String read(String path) {
        return ToolFile.read(new File(path), ConstFramework.getCharset());
    }

    public static String read(File file) {
        return ToolFile.read(file, ConstFramework.getCharset());
    }

    public static String read(String path, String charset) {
        return ToolFile.read(new File(path), charset);
    }

    public static String read(String path, Charset charset) {
        return ToolFile.read(new File(path), charset);
    }

    public static String read(File file, String charset) {
        try {
            charset = ToolStr.nullToDefault(charset, ConstFramework.getCharsetName());
            byte[] bytes = ToolFile.readByte(file);
            return new String(bytes, charset);
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String read(File file, Charset charset) {
        byte[] bytes = ToolFile.readByte(file);
        charset = charset != null ? charset : ConstFramework.getCharset();
        return new String(bytes, charset);
    }

    public static byte[] readByte(String path) {
        return ToolFile.readByte(new File(path));
    }

    public static byte[] readByte(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            long length = file.length();
            if (length > 0xA00000L) {
                return null;
            }
            FileInputStream in = new FileInputStream(file);
            byte[] data = new byte[(int)length];
            int read = in.read(data);
            in.close();
            if ((long)read == length) {
                return data;
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static boolean write(String path, String content) {
        return ToolFile.write(new File(path), content, ConstFramework.getCharsetName());
    }

    public static boolean write(File file, String content) {
        return ToolFile.write(file, content, ConstFramework.getCharsetName());
    }

    public static boolean write(String path, String content, String charset) {
        return ToolFile.write(new File(path), content, charset);
    }

    public static boolean write(String path, String content, Charset charset) {
        return ToolFile.writeBytes(path, content.getBytes(charset));
    }

    public static boolean write(File file, String content, String charset) {
        try {
            charset = ToolStr.nullToDefault(charset, ConstFramework.getCharsetName());
            return ToolFile.writeBytes(file, content.getBytes(charset));
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean write(File file, String content, Charset charset) {
        charset = charset != null ? charset : ConstFramework.getCharset();
        return ToolFile.writeBytes(file, content.getBytes(charset));
    }

    public static boolean writeBytes(String path, byte[] data) {
        return ToolFile.writeBytes(new File(path), data);
    }

    public static boolean writeBytes(File file, byte[] data) {
        try {
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream out = new FileOutputStream(file);
            if (data != null) {
                out.write(data);
            }
            out.close();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static ArrayList<String> readLines(String filePath, String charset) {
        if (filePath == null) {
            return null;
        }
        return ToolFile.readLines(new File(filePath), charset);
    }

    public static ArrayList<String> readLines(File file, String charset) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static boolean writeLines(String filePath, String charset, ArrayList<String> lines, boolean append) {
        if (filePath == null) {
            return false;
        }
        return ToolFile.writeLines(new File(filePath), charset, lines, append);
    }

    public static boolean writeLines(File file, String charset, ArrayList<String> lines, boolean append) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset));
            boolean echoBr = append;
            for (String line : lines) {
                if (!echoBr) {
                    echoBr = true;
                } else {
                    writer.newLine();
                }
                writer.write(line);
            }
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static ArrayList<File> find(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, true, NONE_FILTER);
        return list;
    }

    public static ArrayList<File> find(File dir, FilePatternFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, true, filter);
        return list;
    }

    public static ArrayList<File> findFile(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, false, NONE_FILTER);
        return list;
    }

    public static ArrayList<File> findFile(File dir, FilePatternFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, false, filter);
        return list;
    }

    public static ArrayList<File> find(File dir, FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, true, filter);
        return list;
    }

    public static ArrayList<File> find(File dir, FilenameFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        ToolFile.findAndAdd(dir, list, true, filter);
        return list;
    }

    private static void findAndAdd(File file, ArrayList<File> list, boolean hasDir, FileFilter filter) {
        File[] dirs;
        File[] childs;
        if (!file.isDirectory()) {
            return;
        }
        for (File cf : childs = file.listFiles(filter)) {
            if (cf.isDirectory() && !hasDir) continue;
            list.add(cf);
        }
        for (File df : dirs = file.listFiles(DIR_FILTER)) {
            ToolFile.findAndAdd(df, list, hasDir, filter);
        }
    }

    private static void findAndAdd(File file, ArrayList<File> list, boolean hasDir, FilenameFilter filter) {
        File[] dirs;
        File[] childs;
        if (!file.isDirectory()) {
            return;
        }
        for (File cf : childs = file.listFiles(filter)) {
            if (cf.isDirectory() && !hasDir) continue;
            list.add(cf);
        }
        for (File df : dirs = file.listFiles(DIR_FILTER)) {
            ToolFile.findAndAdd(df, list, hasDir, filter);
        }
    }

    public static String getSizeStr(long size) {
        int index;
        float num = size;
        if (size < 1024L) {
            return size + UNIT_NAME[0];
        }
        for (index = 0; num >= 1024.0f && index < UNIT_NAME.length; num /= 1024.0f, ++index) {
        }
        return ToolFile.fixSizeStr(num) + UNIT_NAME[index];
    }

    private static String fixSizeStr(float num) {
        if (num < 10.0f) {
            DecimalFormat format = new DecimalFormat("0.0");
            return format.format(num);
        }
        return Integer.toString((int)num);
    }

    public static String getDatePath(boolean hasDay) {
        if (hasDay) {
            return new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        return new SimpleDateFormat("yyyy/MM").format(new Date());
    }

    public static String getRealPath(String path) {
        boolean hasSuffix;
        if (path == null) {
            return null;
        }
        boolean hasPrefix = (path = path.replace('\\', '/')).startsWith("/");
        if (hasPrefix) {
            path = path.substring(1);
        }
        if (hasSuffix = path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String name : path.split("/")) {
            if (name.equals("..")) {
                if (names.size() > 0 && !((String)names.get(names.size() - 1)).equals("..")) {
                    names.remove(names.size() - 1);
                    continue;
                }
                names.add(name);
                continue;
            }
            if (name.equals(".")) continue;
            names.add(name);
        }
        StringBuilder newPath = null;
        for (String name : names) {
            if (newPath == null) {
                newPath = new StringBuilder(name);
                continue;
            }
            newPath.append("/").append(name);
        }
        if (newPath == null) {
            newPath = new StringBuilder();
        }
        return (hasPrefix ? "/" : "") + newPath.toString() + (hasSuffix ? "/" : "");
    }

    public static String convertPath(String path, String[] oldPrefix, String[] newPrefix) {
        return ToolFile.convertPath(path, oldPrefix, newPrefix, null);
    }

    public static String convertPath(String path, String[] oldPrefix, String[] newPrefix, String defaultPath) {
        if (path == null || oldPrefix == null || newPrefix == null || oldPrefix.length != newPrefix.length) {
            return defaultPath;
        }
        for (int i = 0; i < oldPrefix.length; ++i) {
            if (!path.startsWith(oldPrefix[i])) continue;
            return newPrefix[i] + path.substring(oldPrefix[i].length());
        }
        return path;
    }

    public static String getNewFileName(String path, String ext) {
        return ToolFile.getNewFileName(path, ext, 8, 16);
    }

    public static String getNewFileName(String path, String ext, int len) {
        return ToolFile.getNewFileName(path, ext, len, 16);
    }

    public static String getNewFileName(String path, String ext, int len, int cnt) {
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        for (int i = 0; i < cnt; ++i) {
            String fileName = ToolStr.randomMD5().substring(0, len) + ext;
            if (new File(path + fileName).exists()) continue;
            return fileName;
        }
        return null;
    }

    public static String getFileMd5(String path) {
        return ToolFile.getFileMd5(new File(path));
    }

    public static String getFileMd5(File file) {
        if (file.exists()) {
            try {
                return ToolStr.bytes2Hex(Digest.encode(new FileInputStream(file), Digest.ALGORITHM.MD5));
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static void writeInputStreamToFile(InputStream in, String filepath) throws IOException {
        ToolFile.writeInputStreamToFile(in, new File(filepath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToFile(InputStream in, File file) throws IOException {
        byte[] data = new byte[DEFAULT_BUFF_SIZE];
        FileOutputStream out = new FileOutputStream(file);
        try {
            int read;
            while ((read = in.read(data)) != -1) {
                out.write(data, 0, read);
            }
        }
        finally {
            out.close();
        }
    }

    public static long lineCount(String path) {
        return ToolFile.lineCount(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lineCount(File file) {
        if (!file.exists() || file.length() == 0L) {
            return 0L;
        }
        try {
            long count = 0L;
            boolean content = false;
            FileInputStream in = new FileInputStream(file);
            try {
                int read;
                while ((read = in.read()) != -1) {
                    if (read == 13 || read == 10) {
                        if (content) {
                            ++count;
                        }
                        content = false;
                        continue;
                    }
                    if (content) continue;
                    content = true;
                }
            }
            finally {
                in.close();
            }
            if (content) {
                ++count;
            }
            return count;
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public static class FilePatternFilter
    implements FilenameFilter {
        private final Pattern pettern;
        private final boolean useMatches;

        public FilePatternFilter(String regex) {
            this.pettern = Pattern.compile(regex);
            this.useMatches = false;
        }

        public FilePatternFilter(String regex, boolean matches) {
            this.pettern = Pattern.compile(regex);
            this.useMatches = matches;
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher matcher = this.pettern.matcher(name);
            return this.useMatches ? matcher.matches() : matcher.find();
        }
    }
}

