/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.constant.ConstFramework;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.bmp.BMPImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class ToolImage {
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_JPEG = "jpeg";
    public static final String FORMAT_JPG = "jpg";
    public static final String FORMAT_BMP = "bmp";
    public static final String FORMAT_GIF = "gif";
    private static final int BUFF_SIZE = 1024;
    private static final float IMG_QUALITY = 0.95f;

    public static String getExt(InputStream is) {
        byte[] head = new byte[10];
        try {
            is.read(head, 0, head.length);
            if (head[0] == 71 && head[1] == 73 && head[2] == 70 && head[3] == 56 && (head[4] == 55 || head[4] == 57) && head[5] == 97) {
                return FORMAT_GIF;
            }
            if (head[6] == 74 && head[7] == 70 && head[8] == 73 && head[9] == 70) {
                return FORMAT_JPEG;
            }
            if (head[6] == 69 && head[7] == 120 && head[8] == 105 && head[9] == 102) {
                return FORMAT_JPG;
            }
            if (head[0] == 66 && head[1] == 77) {
                return FORMAT_BMP;
            }
            if (head[1] == 80 && head[2] == 78 && head[3] == 71) {
                return FORMAT_PNG;
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static BufferedImage getFromFile(String path) {
        try {
            return ImageIO.read(new FileInputStream(path));
        }
        catch (Exception ex) {
            Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static BufferedImage resize(BufferedImage img, float zoom) {
        return ToolImage.resize(img, zoom, 0, 0, 0, 0, 0, 0);
    }

    public static BufferedImage resize(BufferedImage img, float zoom, int cutLeft, int cutTop, int cutWidth, int cutHeight) {
        return ToolImage.resize(img, zoom, cutLeft, cutTop, cutWidth, cutHeight, 0, 0);
    }

    public static BufferedImage resize(BufferedImage img, float zoom, int cutLeft, int cutTop, int cutWidth, int cutHeight, int maxWidth, int maxHeight) {
        int newWidth = Math.round((float)img.getWidth() * zoom);
        int newHeight = Math.round((float)img.getHeight() * zoom);
        if (maxWidth > 0 && newWidth > maxWidth || maxHeight > 0 && newHeight > maxHeight) {
            return null;
        }
        Image scale = img.getScaledInstance(newWidth, newHeight, 4);
        if (cutWidth == 0 || cutHeight == 0) {
            BufferedImage newImg = ToolImage.getNewRGB(newWidth, newHeight);
            Graphics graphics = newImg.getGraphics();
            graphics.drawImage(scale, 0, 0, null);
            graphics.dispose();
            return newImg;
        }
        BufferedImage newImg = ToolImage.getNewRGB(cutWidth, cutHeight);
        Graphics graphics = newImg.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, cutWidth, cutHeight);
        graphics.drawImage(scale, -cutLeft, -cutTop, null);
        graphics.dispose();
        return newImg;
    }

    public static BufferedImage thumbnails(BufferedImage img, int width, int height) {
        int curHeight;
        float zoomHeight;
        int curWidth = img.getWidth();
        float zoomWidth = (float)curWidth / (float)width;
        float zoom = zoomWidth > (zoomHeight = (float)(curHeight = img.getHeight()) / (float)height) ? zoomHeight : zoomWidth;
        int newWidth = Math.round((float)curWidth / zoom);
        int newHeight = Math.round((float)curHeight / zoom);
        Image scale = img.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage newImg = ToolImage.getNewRGB(width, height);
        Graphics graphics = newImg.getGraphics();
        graphics.drawImage(scale, -(newWidth - width) / 2, -(newHeight - height) / 2, null);
        graphics.dispose();
        return newImg;
    }

    public static boolean limitSizeSaveJpg(BufferedImage img, String path, int maxWidth, int maxHeight) {
        return ToolImage.limitSizeSave(img, path, maxWidth, maxHeight, FORMAT_JPEG);
    }

    public static boolean limitSizeSavePng(BufferedImage img, String path, int maxWidth, int maxHeight) {
        return ToolImage.limitSizeSave(img, path, maxWidth, maxHeight, FORMAT_PNG);
    }

    public static boolean limitSizeSaveGif(BufferedImage img, String path, int maxWidth, int maxHeight) {
        return ToolImage.limitSizeSave(img, path, maxWidth, maxHeight, FORMAT_GIF);
    }

    public static boolean limitSizeSaveBmp(BufferedImage img, String path, int maxWidth, int maxHeight) {
        return ToolImage.limitSizeSave(img, path, maxWidth, maxHeight, FORMAT_BMP);
    }

    public static boolean limitSizeSave(BufferedImage img, String path, int maxWidth, int maxHeight, String format) {
        int curWidth = img.getWidth();
        int curHeight = img.getHeight();
        float zoomWidth = (float)curWidth / (float)maxWidth;
        float zoomHeight = (float)curHeight / (float)maxHeight;
        float zoom = 1.0f;
        if (zoomWidth > 1.0f || zoomHeight > 1.0f) {
            zoom = zoomWidth > zoomHeight ? zoomWidth : zoomHeight;
        }
        int newWidth = Math.round((float)curWidth / zoom);
        int newHeight = Math.round((float)curHeight / zoom);
        if (zoom != 1.0f) {
            Image scale = img.getScaledInstance(newWidth, newHeight, 4);
            BufferedImage newImg = ToolImage.getNewRGB(newWidth, newHeight);
            Graphics graphics = newImg.getGraphics();
            graphics.drawImage(scale, 0, 0, null);
            graphics.dispose();
            img = newImg;
        }
        return ToolImage.save(img, path, format);
    }

    public static boolean saveJpg(BufferedImage img, String path) {
        return ToolImage.save(img, path, FORMAT_JPEG);
    }

    public static boolean savePng(BufferedImage img, String path) {
        return ToolImage.save(img, path, FORMAT_PNG);
    }

    public static boolean saveGif(BufferedImage img, String path) {
        return ToolImage.save(img, path, FORMAT_GIF);
    }

    public static boolean saveBmp(BufferedImage img, String path) {
        return ToolImage.save(img, path, FORMAT_BMP);
    }

    public static boolean save(BufferedImage img, String path, String format) {
        return ToolImage.save(img, new File(path), format, 0.95f);
    }

    public static boolean save(BufferedImage img, String path, String format, float quality) {
        return ToolImage.save(img, new File(path), format, quality);
    }

    public static boolean save(BufferedImage img, File file, String format) {
        return ToolImage.save(img, file, format, 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(BufferedImage img, File file, String format, float quality) {
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            try {
                writer.setOutput(ios);
                ImageWriteParam iwparam = ToolImage.getImageWriteParam(format, quality);
                writer.write(null, new IIOImage(img, null, null), iwparam);
                ios.flush();
                writer.dispose();
            }
            finally {
                ios.close();
            }
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static byte[] toDataJpg(BufferedImage img) {
        return ToolImage.toData(img, FORMAT_JPEG, 0.95f);
    }

    public static byte[] toDataPng(BufferedImage img) {
        return ToolImage.toData(img, FORMAT_PNG, 0.95f);
    }

    public static byte[] toDataGif(BufferedImage img) {
        return ToolImage.toData(img, FORMAT_GIF, 0.95f);
    }

    public static byte[] toDataBmp(BufferedImage img) {
        return ToolImage.toData(img, FORMAT_BMP, 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toData(BufferedImage img, String format, float quality) {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(1024);
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(byteOutput);
            try {
                writer.setOutput(ios);
                ImageWriteParam iwparam = ToolImage.getImageWriteParam(format, quality);
                writer.write(null, new IIOImage(img, null, null), iwparam);
                ios.flush();
                writer.dispose();
            }
            finally {
                ios.close();
            }
            return byteOutput.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage fromData(byte[] data) {
        block13: {
            try {
                ByteArrayInputStream byteInput = new ByteArrayInputStream(data);
                ImageInputStream stream = ImageIO.createImageInputStream(byteInput);
                try {
                    Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                    if (iter.hasNext()) {
                        BufferedImage bufferedImage;
                        ImageReader reader = iter.next();
                        if (FORMAT_JPEG.equals(reader.getFormatName().toLowerCase()) || FORMAT_JPG.equals(reader.getFormatName().toLowerCase())) {
                            ImageIcon icon = new ImageIcon(data);
                            Image image = icon.getImage();
                            if (image instanceof BufferedImage) {
                                BufferedImage bufferedImage2 = (BufferedImage)image;
                                return bufferedImage2;
                            }
                            BufferedImage bimage = ToolImage.getNewRGB(image.getWidth(null), image.getHeight(null));
                            Graphics2D bGr = bimage.createGraphics();
                            bGr.drawImage(image, 0, 0, null);
                            bGr.dispose();
                            BufferedImage bufferedImage3 = bimage;
                            return bufferedImage3;
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(data);
                        try {
                            bufferedImage = ImageIO.read(in);
                        }
                        catch (Throwable throwable) {
                            in.close();
                            throw throwable;
                        }
                        in.close();
                        return bufferedImage;
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception ex) {
                if (!ConstFramework.getDebug()) break block13;
                Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static BufferedImage openImage(String path) {
        return ToolImage.openImage(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage openImage(File file) {
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(file);
            try {
                Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                if (!iter.hasNext()) return null;
                ImageReader reader = iter.next();
                if (FORMAT_JPEG.equals(reader.getFormatName().toLowerCase()) || FORMAT_JPG.equals(reader.getFormatName().toLowerCase())) {
                    byte[] data = new byte[(int)file.length()];
                    int read = stream.read(data);
                    if ((long)read != file.length()) {
                        BufferedImage bufferedImage = null;
                        return bufferedImage;
                    }
                    ImageIcon icon = new ImageIcon(data);
                    Image image = icon.getImage();
                    if (image instanceof BufferedImage) {
                        BufferedImage bufferedImage = (BufferedImage)image;
                        return bufferedImage;
                    }
                    BufferedImage bimage = ToolImage.getNewRGB(image.getWidth(null), image.getHeight(null));
                    Graphics2D bGr = bimage.createGraphics();
                    bGr.drawImage(image, 0, 0, null);
                    bGr.dispose();
                    BufferedImage bufferedImage = bimage;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = ImageIO.read(file);
                return bufferedImage;
            }
            finally {
                stream.close();
            }
        }
        catch (Exception ex) {
            if (!ConstFramework.getDebug()) return null;
            Logger.getLogger(ToolImage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static BufferedImage getNewRGB(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public static BufferedImage toNewRGB(BufferedImage oldImg) {
        if (oldImg == null) {
            return null;
        }
        BufferedImage newImg = ToolImage.getNewRGB(oldImg.getWidth(), oldImg.getHeight());
        Graphics g = newImg.getGraphics();
        g.drawImage(oldImg, 0, 0, null);
        g.dispose();
        return newImg;
    }

    private static ImageWriteParam getImageWriteParam(String format, float quality) {
        ImageWriteParam iwparam;
        if (FORMAT_PNG.equals(format)) {
            iwparam = new JPEGImageWriteParam(null);
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(quality);
        } else if (FORMAT_JPEG.equals(format) || FORMAT_JPG.equals(format)) {
            iwparam = new JPEGImageWriteParam(null);
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(quality);
        } else if (FORMAT_BMP.equals(format)) {
            iwparam = new BMPImageWriteParam(null);
        } else if (FORMAT_GIF.equals(format)) {
            iwparam = new JPEGImageWriteParam(null);
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(quality);
        } else {
            iwparam = new ImageWriteParam(null);
        }
        return iwparam;
    }
}

