/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.tool.ToolStr;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Security;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class ToolMail {
    public static final String SUBTYPE_PLAIN = "plain";
    public static final String SUBTYPE_HTML = "html";
    public static final int DEFAULT_RETRY = 3;
    public static final int NOLIMIT_RETRY = -1;
    private static final HashMap<String, Config> configPool = new HashMap();

    public static boolean has(String configName) {
        return configPool.containsKey(configName);
    }

    public static Config get(String configName) {
        return configPool.get(configName);
    }

    public static Config copy(String configName) {
        Config configOld = ToolMail.get(configName);
        if (configOld != null) {
            Config configNew = new Config();
            configNew.username = configOld.username;
            configNew.password = configOld.password;
            configNew.server = configOld.server;
            configNew.port = configOld.port;
            configNew.address = configOld.address;
            configNew.ssl = configOld.ssl;
            configNew.personal = configOld.personal;
            configNew.charset = configOld.charset;
            return configNew;
        }
        return null;
    }

    public static Config copy(String configName, String personalNew) {
        Config configNew = ToolMail.copy(configName);
        if (configNew != null) {
            configNew.personal = ToolStr.nullToDefault(personalNew, configNew.personal);
        }
        return configNew;
    }

    public static boolean remove(String configName) {
        if (configPool.containsKey(configName)) {
            configPool.remove(configName);
            return true;
        }
        return false;
    }

    public static boolean init(String configName, Config config) {
        return ToolMail.init(configName, config, true);
    }

    public static boolean init(String configName, Config config, boolean overwrite) {
        if (configPool.containsKey(configName) && !overwrite) {
            return false;
        }
        configPool.put(configName, config);
        return true;
    }

    public static void doSend(String configName, String email, String title, String content) {
        ToolMail.doSend(configName, email, title, content, SUBTYPE_PLAIN, 3, null, null);
    }

    public static void doSend(String configName, String email, String title, String content, String subtype) {
        ToolMail.doSend(configName, email, title, content, subtype, 3, null, null);
    }

    public static void doSend(String configName, String email, String title, String content, String subtype, int retry) {
        ToolMail.doSend(configName, email, title, content, subtype, retry, null, null);
    }

    public static void doSend(String configName, String email, String title, String content, String subtype, int retry, File[] files) {
        ToolMail.doSend(configName, email, title, content, subtype, retry, files, null);
    }

    public static void doSend(final String configName, final String email, final String title, final String content, final String subtype, final int retry, final File[] files, final Listener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean success = ToolMail.send(configName, email, title, content, subtype, retry, files);
                if (listener != null) {
                    listener.callback(success);
                }
            }
        }).start();
    }

    public static void doSend(Config config, String email, String title, String content) {
        ToolMail.doSend(config, email, title, content, null, 3, null, null);
    }

    public static void doSend(Config config, String email, String title, String content, String subtype) {
        ToolMail.doSend(config, email, title, content, subtype, 3, null, null);
    }

    public static void doSend(Config config, String email, String title, String content, String subtype, int retry) {
        ToolMail.doSend(config, email, title, content, subtype, retry, null, null);
    }

    public static void doSend(Config config, String email, String title, String content, String subtype, int retry, File[] files) {
        ToolMail.doSend(config, email, title, content, subtype, retry, files, null);
    }

    public static void doSend(final Config config, final String email, final String title, final String content, final String subtype, final int retry, final File[] files, final Listener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean success = ToolMail.send(config, email, title, content, subtype, retry, files);
                if (listener != null) {
                    listener.callback(success);
                }
            }
        }).start();
    }

    public static boolean send(String configName, String email, String title, String content) {
        return ToolMail.send(configName, email, title, content, null, 3, null);
    }

    public static boolean send(String configName, String email, String title, String content, String subtype) {
        return ToolMail.send(configName, email, title, content, subtype, 3, null);
    }

    public static boolean send(String configName, String email, String title, String content, String subtype, int retry) {
        return ToolMail.send(configName, email, title, content, subtype, retry, null);
    }

    public static boolean send(String configName, String email, String title, String content, String subtype, int retry, File[] files) {
        Config config = configPool.get(configName);
        if (config == null) {
            return false;
        }
        return ToolMail.send(config, email, title, content, subtype, retry, files);
    }

    public static boolean send(Config config, String email, String title, String content) {
        return ToolMail.send(config, email, title, content, null, 3, null);
    }

    public static boolean send(Config config, String email, String title, String content, String subtype) {
        return ToolMail.send(config, email, title, content, subtype, 3, null);
    }

    public static boolean send(Config config, String email, String title, String content, String subtype, int retry) {
        return ToolMail.send(config, email, title, content, subtype, retry, null);
    }

    public static boolean send(Config config, String email, String title, String content, String subtype, int retry, File[] files) {
        MimeMessage msg = new MimeMessage(config.getNewSession());
        try {
            if (config.personal != null && config.address != null) {
                try {
                    msg.setFrom((Address)new InternetAddress(config.address, config.personal, config.charset.name()));
                }
                catch (UnsupportedEncodingException ex) {
                    msg.setFrom((Address)new InternetAddress(config.address));
                }
            } else if (config.address != null) {
                msg.setFrom((Address)new InternetAddress(config.address));
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email, (boolean)false));
            msg.setSubject(title == null ? "" : title, config.charset.name());
            if (files != null) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(content == null ? "" : content, config.charset.name(), subtype == null ? SUBTYPE_PLAIN : subtype);
                multipart.addBodyPart((BodyPart)messageBodyPart);
                for (File file : files) {
                    if (file == null || !file.exists()) continue;
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(file);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(file.getName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                msg.setContent((Multipart)multipart);
            } else {
                msg.setText(content == null ? "" : content, config.charset.name(), subtype == null ? SUBTYPE_PLAIN : subtype);
            }
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(ToolMail.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (retry > 0) {
                return ToolMail.send(config, email, title, content, subtype, retry - 1, files);
            }
            if (retry < 0) {
                return ToolMail.send(config, email, title, content, subtype, retry, files);
            }
            return false;
        }
        return true;
    }

    public static class Config {
        public String address;
        public String personal;
        public String username;
        public String password;
        public String server;
        public String port;
        public boolean ssl;
        public Charset charset = ConstFramework.getCharset();

        public Session getNewSession() {
            String usePort;
            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Security.addProvider((java.security.Provider)new Provider());
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", this.server);
            if (this.ssl) {
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            if ((usePort = this.port) == null || usePort.isEmpty()) {
                usePort = this.ssl ? "465" : "25";
            }
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", usePort);
            props.setProperty("mail.smtp.socketFactory.port", usePort);
            props.put("mail.smtp.auth", "true");
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Config.this.username, Config.this.password);
                }
            });
        }

        public Config() {
        }

        public Config(String username, String password, String server) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = null;
            this.address = username;
            this.ssl = false;
            this.personal = null;
            this.charset = ConstFramework.getCharset();
        }

        public Config(String username, String password, String server, String port) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = username;
            this.ssl = false;
            this.personal = null;
            this.charset = ConstFramework.getCharset();
        }

        public Config(String username, String password, String server, String port, String address) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = address;
            this.ssl = false;
            this.personal = null;
            this.charset = ConstFramework.getCharset();
        }

        public Config(String username, String password, String server, String port, String address, boolean ssl) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = address;
            this.ssl = ssl;
            this.personal = null;
            this.charset = ConstFramework.getCharset();
        }

        public Config(String username, String password, String server, String port, String address, boolean ssl, String personal) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = address;
            this.ssl = ssl;
            this.personal = personal;
            this.charset = ConstFramework.getCharset();
        }

        public Config(String username, String password, String server, String port, String address, boolean ssl, String personal, String charsetName) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = address;
            this.ssl = ssl;
            this.personal = personal;
            this.charset = charsetName == null ? ConstFramework.getCharset() : Charset.forName(charsetName);
        }

        public Config(String username, String password, String server, String port, String address, boolean ssl, String personal, Charset charset) {
            this.username = username;
            this.password = password;
            this.server = server;
            this.port = port;
            this.address = address;
            this.ssl = ssl;
            this.personal = personal;
            this.charset = charset == null ? ConstFramework.getCharset() : charset;
        }
    }

    public static interface Listener {
        public void callback(boolean var1);
    }
}

