/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.tool.ToolFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ToolZip {
    private static final int BUFF_SIZE = 4096;

    public static boolean gzip(File source, File dist) {
        try {
            int read;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
            BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(dist)));
            byte[] buff = new byte[4096];
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolZip.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean ungzip(File source, File dist) {
        try {
            int read;
            BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(source)));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dist));
            byte[] buff = new byte[4096];
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolZip.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean zip(File[] files, File zipFile) {
        return ToolZip.zip(files, zipFile, false, -1);
    }

    public static boolean zip(File[] files, File zipFile, boolean stored) {
        return ToolZip.zip(files, zipFile, stored, -1);
    }

    public static boolean zip(File[] files, File zipFile, int level) {
        return ToolZip.zip(files, zipFile, false, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zip(File[] files, File zipFile, boolean stored, int level) {
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            try {
                out.setMethod(stored ? 0 : 8);
                out.setLevel(level);
                for (File f : files) {
                    ToolZip.zip(out, f, stored, "");
                }
            }
            finally {
                out.close();
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolZip.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream out, File file, boolean stored, String basePath) throws IOException {
        if (file.isDirectory()) {
            File[] listFiles;
            String name = basePath + file.getName() + "/";
            ZipEntry entry = new ZipEntry(name);
            entry.setMethod(0);
            entry.setCompressedSize(0L);
            entry.setSize(0L);
            entry.setTime(file.lastModified());
            entry.setCrc(0L);
            out.putNextEntry(entry);
            out.closeEntry();
            for (File f : listFiles = file.listFiles()) {
                ToolZip.zip(out, f, stored, name);
            }
        } else {
            String name = basePath + file.getName();
            ZipEntry entry = new ZipEntry(name);
            if (stored) {
                entry.setMethod(0);
                entry.setCompressedSize(file.length());
                entry.setSize(file.length());
                entry.setTime(file.lastModified());
                entry.setCrc(ToolZip.getCRC32(file));
            } else {
                entry.setMethod(8);
            }
            out.putNextEntry(entry);
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                try {
                    int read;
                    byte[] buff = new byte[4096];
                    while ((read = in.read(buff)) != -1) {
                        out.write(buff, 0, read);
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                out.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(File zipFile, String basePath) {
        try {
            if (!ToolFile.checkPath(basePath)) {
                return false;
            }
            if (!basePath.endsWith(File.separator)) {
                basePath = basePath + File.separator;
            }
            ZipInputStream in = new ZipInputStream(new FileInputStream(zipFile));
            try {
                ZipEntry entry;
                while ((entry = in.getNextEntry()) != null) {
                    String entryName = entry.getName().replace('/', File.separatorChar);
                    if (entry.isDirectory() || entryName.endsWith(File.separator)) {
                        File dir = new File(basePath + entryName);
                        dir.mkdir();
                        continue;
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(basePath + entryName));
                    try {
                        int read;
                        byte[] buff = new byte[4096];
                        while ((read = in.read(buff)) != -1) {
                            out.write(buff, 0, read);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
            }
            finally {
                in.close();
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolZip.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) {
        try {
            long checksum = 0L;
            CheckedInputStream cin = new CheckedInputStream(new FileInputStream(file), new CRC32());
            byte[] buff = new byte[4096];
            try {
                while (cin.read(buff) != -1) {
                }
                checksum = cin.getChecksum().getValue();
            }
            finally {
                cin.close();
            }
            return checksum;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolZip.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }
}

